# arch.mk for BerkeleyGW codes
#
# SolarisStudio12.2-linux-x86 serial
# needs packages liblapack-dev, fftw-dev
#
# D. Strubbe
# December 2010, UCB

# Precompiler options
#
COMPFLAG  = -DSUN
MATHFLAG  = 
DEBUGFLAG = -DVERBOSE
# doesn't seem to be a way to use line lengths beyond 132
# this prevents use of DEBUG with the SAFE_ALLOCATE macros
#DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = cpp -P -ansi
F90free = sunf90 -free 
LINK    = sunf90
FOPTS   = -O3
# sigma_main may cause segfault or system crash at compile time if -O3!
FNOOPTS = -O2
MOD_OPT = -moddir=
INCFLAG = -I

# sunCC segfaults mysteriously at the very beginning of surface.cpp and icm.cpp
CC_COMP = g++
C_COMP  = gcc
C_LINK  = g++
C_OPTS  = -O3

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWLIB      = -L/usr/lib/ -lfftw
FFTWINCLUDE  = /usr/share/doc/fftw-dev/fortran
LAPACKLIB    = -L/usr/lib/ -llapack
