# arch.mk for BerkeleyGW codes
#
# suitable for SCRS North cluster mako.berkeley.edu
#
# Known issue: surface.x in CUBE test crashes if mpiCC is used
# surface.x: symbol lookup error: surface.x: undefined symbol: TPp__curr_eh_stack_entry
# Use of pgCC for this executable (which is serial anyway) solves the problem.
#
# D. Strubbe
# February 2010, UC Berkeley
#
# module load pgi/10.2
# module load openmpi/1.4.2-pgi
# module load fftw/2.1.5-pgi
# module load mkl/11.1.072

# Precompiler options
#
COMPFLAG  = -DPGI
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK
DEBUGFLAG = -DDEBUG -DVERBOSE

FCPP    = cpp -ansi
F90free = mpif90 -Mfree
LINK    = mpif90
FOPTS   = -fast
FNOOPTS = $(FOPTS)
MOD_OPT = -module 
INCFLAG = -I

C_PARAFLAG = -DPARA
CC_COMP = mpiCC
C_COMP  = mpicc
C_LINK  = mpiCC
C_OPTS  = -fast

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /global/software/centos-5.x86_64/modules/fftw/2.1.5-pgi
FFTWLIB      = -L$(FFTWPATH)/lib -ldfftw
FFTWINCLUDE  = $(FFTWPATH)/include
MKLPATH      = /global/software/centos-5.x86_64/modules/intel/Compiler/11.1/072/mkl/lib/em64t
LAPACKLIB    = -Wl,--start-group $(MKLPATH)/libmkl_intel_lp64.a $(MKLPATH)/libmkl_sequential.a \
               $(MKLPATH)/libmkl_core.a $(MKLPATH)/libmkl_blacs_openmpi_lp64.a -Wl,--end-group -lpthread
SCALAPACKLIB = $(MKLPATH)/libmkl_scalapack_lp64.a 

TESTSCRIPT = qsub mako.scr
