# arch.mk for BerkeleyGW codes
#
# suitable for Hopper at NERSC with Cray compiler
# module swap PrgEnv-pgi PrgEnv-cray
# Status: all tests passed r3507, 3 Nov 2011
# except convert_old_to_new does not compile due to missing intrinsics ftell, fseek
#
# http://docs.cray.com/books/S-3695-35/html-S-3695-35/pdollsmg.html
# Unit numbers 100, 101, and 102 are permanently associated with the standard input, standard output, and standard error files, respectively.
#
# D. Strubbe
# Sept 2011, UC Berkeley

# Precompiler options
#
COMPFLAG  = -DCRAY
PARAFLAG  = -DMPI
MATHFLAG  = -DUSESCALAPACK -DUNPACKED
DEBUGFLAG = -DDEBUG -DVERBOSE

# use of the cpp line numbers gives incorrect reference for error messages, so we need -P
FCPP    = /usr/bin/cpp -P -ansi
F90free = ftn -em -f free
LINK    = ftn
# debugging flags: -R bscpd
# default is like -fast, according to Cray recommendations
FOPTS   =
FNOOPTS =
MOD_OPT = -J 
INCFLAG = -I

C_PARAFLAG  = -DPARA -DMPICH_IGNORE_CXX_SEEK
CC_COMP  = CC
C_COMP  = cc
C_LINK  = CC
# default is like -fast, according to Cray recommendations
C_OPTS  = 

REMOVE  = /bin/rm -f

# Math Libraries
#
FFTWPATH     = /opt/fftw/2.1.5.4
FFTWLIB      = -L$(FFTWPATH)/lib -ldfftw
FFTWINCLUDE  = $(FFTWPATH)/include
#PERFORMANCE  = -L/usr/common/usg/ipm/0.921/lib -lipm
PERFORMANCE  = 

TESTSCRIPT = qsub hopper.scr
