#include "f_defs.h"

!*************************************************************************
module fft_m

  use SysParams, only : double, twopi, zero, half, one, two, imaginary
  use fftw_m, only : fftw_forward, fftw_measure, fftw_in_place, fftw_use_wisdom, fftw_backward
  use push_pop_m
  implicit none

  public :: fft

contains

subroutine fft(grid, nn, ndim, isign)
!*************************************************************************
! gsm [2010-10-15] replaced the original fft routine with FFTW
!*************************************************************************

  integer, intent(in)            :: isign, ndim, nn(ndim)
  complex(double), intent(inout) :: grid(:)

  logical, save :: first_call = .true.
  integer*8, save :: minus_plan_3D, plus_plan_3D

  PUSH_SUB(fft)

  if (first_call) then
    call fftwnd_f77_create_plan(minus_plan_3D,3,nn, &
     fftw_forward,fftw_measure+fftw_in_place+fftw_use_wisdom)
    call fftwnd_f77_create_plan(plus_plan_3D,3,nn, &
     fftw_backward,fftw_measure+fftw_in_place+fftw_use_wisdom)
  endif

  if (isign .eq. 1) then
    call fftwnd_f77_one(minus_plan_3D,grid,0)
  elseif (isign .eq. -1) then
    call fftwnd_f77_one(plus_plan_3D,grid,0)
  elseif (isign .eq. 99) then
    call fftwnd_f77_destroy_plan(minus_plan_3D)
    call fftwnd_f77_destroy_plan(plus_plan_3D)
    ! should forget wisdom here, but I cannot figure out how... --DAS
  endif

  first_call = .false.

  POP_SUB(fft)
  return

end subroutine fft

end module fft_m
