#!/usr/bin/python

# asciify.py -- converts bitmap image to ASCII art -- Sep 9, 2010 -- Georgy Samsonidze
# based on ASCII Art Maker by Steven Kay
# http://stevendkay.wordpress.com/2009/09/08/generating-ascii-art-from-photographs-in-python/
# the ASCII grayscale table is taken from IMG2ASCII by Ueli Weiss
# http://img2ascii.sourceforge.net/

def main(argv = None):
  if argv is None:
    argv = sys.argv
  argc = len(argv)
  self = "asciify.py"
  if argv[0][-len(self):] != self:
    print("\n   Rename script to %s\n" % self)
    return 1
  if argc != 8:
    print("\n   Usage: %s mode fimage fproc awidth aoffset charw charh\n" % self)
    print("      mode = 1 - preprocess & write | 2 - read & display | 3 - normal")
    print("    fimage = name of file to read image from (format supported by PIL)")
    print("     fproc = name of file to write/read preprocessed image to/from")
    print("    awidth = width of asciified image in characters")
    print("   aoffset = number of blank characters in front of asciified image")
    print("     charw = width of a character in pixels (for aspect ratio)")
    print("     charh = height of a character in pixels (for aspect ratio)\n")
    return 2

  try:
    mode = int(argv[1])
  except:
    mode = -1
  fimage = argv[2]
  fproc = argv[3]
  try:
    awidth = int(argv[4])
  except:
    awidth = -1
  try:
    aoffset = int(argv[5])
  except:
    aoffset = -1
  try:
    charw = int(argv[6])
  except:
    charw = -1
  try:
    charh = int(argv[7])
  except:
    charh = -1

  if mode < 1 or mode > 3:
    print("\n   Error: illegal value %s for mode\n" % argv[1])
    return 2
  if awidth < 1:
    print("\n   Error: illegal value %s for awidth\n" % argv[4])
    return 2
  if aoffset < 0:
    print("\n   Error: illegal value %s for aoffset\n" % argv[5])
    return 2
  if charw < 1:
    print("\n   Error: illegal value %s for charw\n" % argv[6])
    return 2
  if charh < 1:
    print("\n   Error: illegal value %s for charh\n" % argv[7])
    return 2

  if mode == 1 or mode == 3:
    try:
      from PIL import Image
    except:
      print("\n   Error: unable to load module PIL\n")
      return 2
    try:
      img = Image.open(fimage)
      (oldwidth, oldheight) = img.size
      newwidth = awidth
      newheight = int(float(oldheight * newwidth * charw) / float(oldwidth * charh) + 0.5)
      img = img.resize((newwidth, newheight), Image.ANTIALIAS)
      img = img.convert('L')
      nx = img.size[0]
      ny = img.size[1]
      dat = []
      for iy in range(ny):
        dat.append([])
        for ix in range(nx):
          dat[iy].append(img.getpixel((ix, iy)))
    except:
      print("\n   Error: unable to read file %s\n" % fimage)
      return 2

  if mode == 1:
    try:
      h = open(fproc, 'w')
      s = ' %i %i\n' % (nx, ny)
      h.write(s)
      for iy in range(ny):
        s = ''
        for ix in range(nx):
          s = s + ' %i'  % dat[iy][ix]
        s = s + '\n'
        h.write(s)
      h.close()
    except:
      print("\n   Error: unable to write file %s\n" % fproc)
      return 2

  if mode == 2:
    try:
      h = open(fproc, 'r')
      s = h.readline()
      t = s.split()
      nx = int(t[0])
      ny = int(t[1])
      dat = []
      for iy in range(ny):
        s = h.readline()
        t = s.split()
        dat.append([])
        for ix in range(nx):
          dat[iy].append(int(t[ix]))
      h.close()
    except:
      print("\n   Error: unable to read file %s\n" % fproc)
      return 2

  if mode == 2 or mode == 3:
    import random
    greyscale = [ ' ',
                  ' ',
                  '`',
                  '`',
                  '\'.',
                  '\'.',
                  '!,-^~',
                  '!,-^~',
                  ':_',
                  ';{}',
                  '()/<>\\',
                  '*?',
                  '"=',
                  '%+il',
                  '17,t',
                  '3Ccjr',
                  '&2IJovxz',
                  '$Lu',
                  '6OTYZ',
                  '45Genswy',
                  '0ADFPVf',
                  '9SUahp',
                  '8Xbdk',
                  'QRq',
                  'BEKWgm',
                  '@',
                  '@',
                  'H',
                  '#',
                  'N',
                  'M' ]
    greylength = len(greyscale)
    s = ''
    for iy in range(ny):
      for j in range(aoffset):
        s = s + ' '
      for ix in range(nx):
        lum = int(float((255 - dat[iy][ix]) * (greylength - 1)) / float(255) + 0.5)
        possibles = greyscale[lum]
        s = s + possibles[random.randint(0, len(possibles) - 1)]
      s = s + '\n'
    print(s)

  return 0

if __name__ == "__main__":
   import sys
   sys.exit(main())

