!
! SIB: This routine looks the same as input().
! Except it reads from WFNq and
! writes to itpv='INT_VWFQ' and only valence bands.
! And k-point information is read into kpq.
!
!     SUBROUTINE READS CRYSTAL DATA AND WAVEFUNCTIONS FROM TAPE26
!     AND PARAMETERS FOR POLARIZABILITY CALCULATION FROM TAPE5
!     TAPE10 (OUTPUT TAPE) IS INITIALIZED

#include "f_defs.h"

subroutine input_q(gvec,kpq,cwfn,vwfn,pol,intwfnvq)

  use global_m
  use eqpcor_m
  use input_utils_m
  use misc_m
  use wfn_rho_vxc_io_m
  implicit none

  type (gspace), intent(in) :: gvec
  type (kpoints), intent(out) :: kpq
  type (conduction_wfns), intent(in) :: cwfn
  type (valence_wfns), intent(in) :: vwfn
  type (polarizability), intent(inout) :: pol
  type (int_wavefunction), intent(out) :: intwfnvq

  integer, allocatable :: isort(:)
  SCALAR, allocatable :: zc(:,:)
  type (crystal) :: crys
  type (symmetry) :: syms

! ... local from file 26
  real(DP) :: vcell
  integer :: itval

! ... local variables
  integer :: i,j,k,ik
  integer :: itpv
  integer :: iiii
  real(DP) :: qk(3)
  character :: filenamevq*20
  character :: fncor*32
  logical :: dont_read

  character(len=3) :: sheader
  integer :: iflavor
  type(gspace) :: gvecq, gvec_kpt

  PUSH_SUB(input_q)

  if (peinf%inode .eq. 0) write(6,*) ""
  if (peinf%inode .eq. 0) write(6,*) "Reading Shifted Wavefunction WFNq"

  if (peinf%inode .eq. 0) call open_file(26,file='WFNq',form='unformatted',status='old')

  sheader = 'WFN'
  iflavor = 0
  call read_binary_header_type(26, sheader, iflavor, kpq, gvecq, syms, crys, warn = .false.)

  SAFE_ALLOCATE(gvecq%k, (3, gvecq%ng))
  call read_binary_gvectors(26, gvecq%ng, gvecq%ng, gvecq%k, dont_read = .true.)
  SAFE_DEALLOCATE_P(gvecq%k)

  call scissor_shift(kpq, kpq%mnband, vwfn%evs, vwfn%evdel, vwfn%ev0, cwfn%ecs, cwfn%ecdel, cwfn%ec0)

  if(peinf%inode == 0) then
    call get_volume(vcell,crys%bdot)
    if (abs(crys%celvol-vcell).gt.TOL_Small) then
      call die('volume mismatch')
    endif

!-----------------------------------------------------------------
! If a quasi-particle correction file exists, read the corrected
! quasiparticle energies from file (in eV)

    if(pol%eqp_corrections) then
      fncor='eqp_q.dat'
      call eqpcor(fncor,0,1, &
        kpq,kpq%mnband,1,vwfn%nband+pol%ncrit, &
        kpq%mnband,0,kpq%mnband,0,kpq%el,kpq%el,kpq%el,1,0)
    endif
    
    call find_efermi(pol%rfermi, pol%efermi, pol%efermi_input, kpq, kpq%mnband, &
      "shifted grid", should_search = .false., should_update = .false., write7 = .true.)
    ! note: here ifmax may be updated. We will never use it, so it does not matter that it only happens on proc 0. -DAS

    if(any (kpq%ifmax(:,:) < vwfn%nband .or. kpq%ifmax(:,:) > vwfn%nband + pol%ncrit)) then
      write(0,'(a,i6,a,i6,a)') 'epsilon.inp says there are ', vwfn%nband, ' fully occupied bands and ', &
        pol%ncrit, ' partially occupied.'
      write(0,'(a,2i6)') 'This is inconsistent with highest bands in WFNq file; min, max = ', minval(kpq%ifmax), maxval(kpq%ifmax)
      call die("band_occupation, number_partial_occup, and WFNq inconsistent.")
    endif
    
    if(maxval(kpq%ifmax) - minval(kpq%ifmax) > pol%ncrit) then
      write(0,'(a,i6,a)') 'epsilon.inp says there are ', pol%ncrit, ' partially occupied bands.'
      write(0,'(a,i6)') 'This is less than the number partially occupied in WFNq file: ', maxval(kpq%ifmax) - minval(kpq%ifmax)
      call die("number_partial_occup and WFNq inconsistent.")
    endif

  endif ! of proc 0 reading

!      if (peinf%inode .eq. 0) write(6,*) ""
!      if (peinf%inode .eq. 0) write(6,*) "Q Read Header", kpq%nspin,kpq%nrk,kpq%kgrid,kpq%shift

! JRD:  proc 0 opens unit (itpv) with name 'INT_VWFQ'
      
  if (pol%iwriteint .eq. 0) then
    if(peinf%inode.eq.0) then
      write(filenamevq,'(a)') 'INT_VWFQ'
      itpv=300028
      call open_file(itpv,file=filenamevq,form='unformatted',status='replace')
    endif
  else
    itval=vwfn%nband+pol%ncrit  
    SAFE_ALLOCATE(intwfnvq%ng, (kpq%nrk))
    SAFE_ALLOCATE(intwfnvq%isort, (kpq%ngkmax,kpq%nrk))
    SAFE_ALLOCATE(intwfnvq%cg, (kpq%ngkmax,kpq%nrk*peinf%nvownt,kpq%nspin))
    SAFE_ALLOCATE(intwfnvq%el, (itval,kpq%nspin,kpq%nrk))
    SAFE_ALLOCATE(intwfnvq%qk, (3,kpq%nrk))
  endif
  
  do ik=1,kpq%nrk

    qk(1:3) = kpq%rk(1:3, ik)
    SAFE_ALLOCATE(gvec_kpt%k, (3, kpq%ngk(ik)))

    call read_binary_gvectors(26, kpq%ngk(ik), kpq%ngk(ik), gvec_kpt%k)

    SAFE_ALLOCATE(isort, (kpq%ngk(ik)))
    do i = 1, kpq%ngk(ik)
      call findvector(isort(i), gvec_kpt%k(1, i), gvec_kpt%k(2, i), gvec_kpt%k(3, i), gvec)
      if (isort(i) == 0)  call die('input_q: could not find gvec')
    enddo
    SAFE_DEALLOCATE_P(gvec_kpt%k)

! JRD: 0 proc write kpq%ngk(ik), isort(), and other stuff to itpv

    if (pol%iwriteint .eq. 0) then
      if (peinf%inode.eq.0)  then
        write(itpv) kpq%ngk(ik),(isort(j),j=1,kpq%ngk(ik)), &
          ((kpq%el(j,ik,k),j=1,(vwfn%nband+pol%ncrit)), & 
          k=1,kpq%nspin),(qk(i),i=1,3)
      endif
    else
      itval=vwfn%nband+pol%ncrit
      intwfnvq%ng(ik)=kpq%ngk(ik)
      intwfnvq%isort(1:kpq%ngk(ik),ik)=isort(1:kpq%ngk(ik))
      intwfnvq%el(1:itval,1:kpq%nspin,ik)=kpq%el(1:itval,ik,1:kpq%nspin)
      intwfnvq%qk(:,ik)=qk(:)
    endif
!
! SIB:  loop on max number of bands, and proc 0 reads the wave function
! from unit 26, checks normalization, and if the band is less than
! cwfn%nband (# of bands in total) **AND** is a valence band (so
! its index is <= vwfn%nband), then it is written to itpv.
!
    SAFE_ALLOCATE(zc, (kpq%ngk(ik), kpq%nspin))

    do i=1,kpq%mnband

      dont_read = i > cwfn%nband
      if(.not. dont_read) dont_read = cwfn%band_index(i) > vwfn%nband+pol%ncrit
      call read_binary_data(26, kpq%ngk(ik), kpq%ngk(ik), kpq%nspin, zc, dont_read = dont_read)

      if(.not. dont_read) then

        if (peinf%inode == 0) then
          do k = 1, kpq%nspin
            call checknorm('WFNq',i,ik,kpq%nspin,kpq%ngk(ik),zc(:,k))
          enddo
        endif

        if (pol%iwriteint .eq. 0) then
          if (peinf%inode .eq. 0) then
            write(itpv) ((zc(j,k),j=1,kpq%ngk(ik)),k=1,kpq%nspin)
          endif
        else
          itval=vwfn%nband+pol%ncrit
          if (peinf%doiownv(cwfn%band_index(i)) .eq. 1) then
            iiii=peinf%indexv(cwfn%band_index(i))+(ik-1)*peinf%nvownt
            intwfnvq%cg(1:kpq%ngk(ik),iiii,1:kpq%nspin)=zc(1:kpq%ngk(ik),1:kpq%nspin)
          endif
        endif
      endif
    enddo
    SAFE_DEALLOCATE(isort)
    SAFE_DEALLOCATE(zc)
  enddo                     ! end loop over k+q points

  if(peinf%inode.eq.0) then
    call close_file(26)
    if (pol%iwriteint .eq. 0) call close_file(itpv)
  endif
  
! Writes some info about xtal

  if (peinf%inode.eq.0)  then
    
    write(6,100)
    write(7,100)
100 format(/,1x,'Crystal k+q WFs read from WFNq')
    
  endif

  if(pol%iwriteint == 0) then
#ifdef MPI
    call MPI_Barrier(MPI_COMM_WORLD, mpierr)
#endif
  endif

  POP_SUB(input_q)
  
  return
end subroutine input_q
