!=================================================================================
!
! Routines:
!
! (1) epsinv()          Originally By (?)                Last Modified 5/1/2008 (JRD)
!
!     This routine:
!
!     1. Calculates epsilon based on chi.
!     2. Inverts epsilon.
!     3. Writes the result to unit=12 if q0="zero" and unit 13 otherwise.
!
!     q0="zero" is handled specially:
!
!     The head (G=G`=0) and wings (G=0,G`!=0) and (G!=0,G`=0) are
!     handled separately (analytic inversion).
!
!=================================================================================

#include "f_defs.h"

subroutine epsinv(gvec,pol,q0,q0norm,iflagq0,crys,scal,kp,omega_plasma)
  
  use global_m
  use inversion_m
  use misc_m
  use scalapack_m
  use vcoul_generator_m
  use write_matrix_m
  implicit none

  type (gspace), intent(in) :: gvec
  type (polarizability), intent(in) :: pol
  real(DP), intent(in) :: q0(3)
  real(DP), intent(in) :: q0norm
  integer, intent(in) :: iflagq0
  type (crystal), intent(in) :: crys
  type (scalapack), intent(in) :: scal
  type (kpoints), intent(in) :: kp
  real(DP), intent(in) :: omega_plasma

  integer :: qgrid(3)
  real(DP) :: q0vec(3)
  type (twork_scell) :: work_scell
  integer :: i,j,jj,is,js,itape
  integer :: irow, icol, icurr, irowm, icolm
  integer, allocatable :: isorti(:)
  integer :: iscreen, nfk, iparallel
  real(DP) :: vc, oneoverq, avgcut, tsec(2)
  real(DP) :: epssum1R, epssum2R, epssum1R_rel,epssum2R_rel
#ifdef CPLX
  real(DP) :: epssum1A, epssum2A, epssum1A_rel,epssum2A_rel
#endif
  SCALAR :: chitmp
  SCALAR, allocatable :: eps(:,:),ewng(:)
  character :: aflag*3
  real(DP), allocatable :: vcoul(:)
  complex(DPC), allocatable :: chiRDyntmp(:), chiADyntmp(:)
  complex(DPC), allocatable :: epsRDyn(:,:,:), epsADyn(:,:,:)
  ! Auxiliary matrix for inversion
  complex(DPC), allocatable :: eps1Aux(:,:)
  SCALAR :: epsheaddummy, wcoul0

  PUSH_SUB(epsinv)

  SAFE_ALLOCATE(vcoul, (pol%nmtx))
  
  if(pol%freq_dep .eq. 0) then
    SAFE_ALLOCATE(eps, (scal%npr,scal%npc))
    SAFE_ALLOCATE(ewng, (pol%nmtx))
  endif

  if(pol%freq_dep .eq. 2) then
    SAFE_ALLOCATE(chiRDyntmp, (pol%nfreq))
    SAFE_ALLOCATE(epsRDyn, (pol%nfreq,scal%npr,scal%npc))
#ifdef CPLX
    SAFE_ALLOCATE(chiADyntmp, (pol%nfreq))
    SAFE_ALLOCATE(epsADyn, (pol%nfreq,scal%npr,scal%npc))
#endif
    SAFE_ALLOCATE(eps1Aux, (scal%npr,scal%npc))
  endif

  
  SAFE_ALLOCATE(isorti, (gvec%ng))
      
!------------------------------
! Invert isrtx

!
! SIB: isorti is the inverse sort order for pol%isrtx.
! pol%isrtx has the sort indices for |q0+gvec%k|^2
!

  if(pol%freq_dep .eq. 0) then
    eps(:,:)=ZERO
  endif
  
  if(pol%freq_dep .eq. 2) then
    epsRDyn(:,:,:)=(0.d0,0.d0)
#ifdef CPLX
    epsADyn(:,:,:)=(0.d0,0.d0)
#endif
  endif
  
  
  vcoul(:)=0.0d0
  do i=1,gvec%ng
    isorti(pol%isrtx(i)) = i
  end do


!-------------- Construct Dielectric Matrix ---------------------------

!
! e(q+g,q+g`) = del(g,g`) - (8pi/(q+g)**2) chi(q+g,q+g`).  For spin-polarized
! calc., e(G+q,G`+q)=del(G,G`)- (8PI/(G+q)^2) SUM_spin chi(G+q,G`+q,ispin)
! Which is pol%chi(j,1) as compiled in epsilon_main.f90.  If q--> 0 , we have to treat
! the wings separately
!
! SIB:  using the Rydberg as our unit of energy
! if pol%icutv is on (coulomb cutoff) then we multiply the coulomb
! interaction by the appropriate factor (1-cos(vcut*|q0+g|))
!

!      if (peinf%inode .eq. 0) then
!        write(6,*) ' '
!        write(6,*) 'Calculating Coulomb Potential'
!      endif

  if (iflagq0 .eq. 1 .and. peinf%inode .eq. 0) then
    write(6,*) ' '
    write(6,*) ' Doing q0: ', q0, q0norm
    write(6,*) ' '
  end if
  
  icurr=0

! Generator Coulomb Interaction Array Vcoul

! For Epsilon, We want to treat all types of screening the same for vcoul.  Because
! we calculate it exactly

  avgcut=TOL_ZERO
  iscreen=0
  nfk=product(kp%kgrid(1:3))
  q0vec=0d0
  iparallel=1

  if(peinf%inode.eq.0) call timacc(18,1,tsec)
  
  qgrid(:)=1

  epsheaddummy=0.0d0
  wcoul0=0.0d0

  call vcoul_generator(pol%icutv,pol%truncval,gvec,crys%bdot, &
    nfk,pol%nmtx,pol%isrtx,iscreen,q0,q0vec,vcoul, &
    pol%iwritecoul,iparallel,avgcut,oneoverq,qgrid,epsheaddummy, &
    work_scell,.false.,wcoul0)

  if(peinf%inode.eq.0) call timacc(18,2,tsec)

!      write(6,*) 'Done VCoul'

  if(pol%freq_dep .eq. 0) then
    do i=1,pol%nmtx
      
      irow=MOD(INT(((i-1)/scal%nbl)+TOL_SMALL),scal%nprow)
      if(irow.ne.scal%myprow) cycle
      
      vc = vcoul(i)

!-------------------------
! Actually Construct eps

      do j=1,pol%nmtx
        icol=MOD(INT(((j-1)/scal%nbl)+TOL_SMALL),scal%npcol)
        if(icol .eq. scal%mypcol) then
          icurr=icurr+1
          irowm=INT((icurr-1)/scal%npc+TOL_SMALL)+1
          icolm=MOD((icurr-1),scal%npc)+1

          eps(irowm,icolm) = ZERO
          if (i.eq.j) eps(irowm,icolm) = ONE
          chitmp = pol%chi(irowm,icolm,1)
          eps(irowm,icolm) = eps(irowm,icolm) - vc*chitmp
        endif
      end do
    end do
  endif
  
  if(pol%freq_dep .eq. 2) then
    do i=1,pol%nmtx

!          if (peinf%inode .eq. 0) then
!            write(6,*) 'Starting loop', i
!          endif

      irow=MOD(INT(((i-1)/scal%nbl)+TOL_SMALL),scal%nprow)
      if(irow.ne.scal%myprow) cycle
      
      vc = vcoul(i)

!-------------------------
! Actually Construct eps

      do j=1,pol%nmtx

!            if (peinf%inode .eq. 0) then
!              write(6,*) 'Starting loop', i, j, pol%nmtx
!            endif

        icol=MOD(INT(((j-1)/scal%nbl)+TOL_SMALL),scal%npcol)
        if(icol .eq. scal%mypcol) then
          icurr=icurr+1
          irowm=INT((icurr-1)/scal%npc+TOL_SMALL)+1
          icolm=MOD((icurr-1),scal%npc)+1
          
          epsRDyn(:,irowm,icolm) = (0.0,0.0)
#ifdef CPLX
          epsADyn(:,irowm,icolm) = (0.0,0.0)
#endif
          
          if (i.eq.j) then
            epsRDyn(:,irowm,icolm) = (1.0,0.0)
#ifdef CPLX
            epsADyn(:,irowm,icolm) = (1.0,0.0)
#endif
          endif
          
          chiRDyntmp(:) = pol%chiRDyn(:,irowm,icolm,1)
#ifdef CPLX
          chiADyntmp(:) = pol%chiADyn(:,irowm,icolm,1)
#endif

!              if (iflagq0 .eq. 0 .or. pol%icutv .ne. 0) then
          epsRDyn(:,irowm,icolm) = epsRDyn(:,irowm,icolm)- &
            vc*chiRDyntmp(:)
#ifdef CPLX
          epsADyn(:,irowm,icolm) = epsADyn(:,irowm,icolm)- &
            vc*chiADyntmp(:)
#endif
!              else
!                if (i .eq. 1 .and. j .eq. 1) then
!                  epsRDyn(:,irowm,icolm) = epsRDyn(:,irowm,icolm)- &
!                   vc*chiRDyntmp(:)*q0norm*q0norm
!#ifdef CPLX
!                  epsADyn(:,irowm,icolm) = epsADyn(:,irowm,icolm)- &
!                   vc*chiADyntmp(:)*q0norm*q0norm
!#endif
!                else if (i .eq. 1 .or. j .eq. 1) then
!                  epsRDyn(:,irowm,icolm) = epsRDyn(:,irowm,icolm)- &
!                   vc*chiRDyntmp(:)*q0norm
!#ifdef CPLX
!                  epsADyn(:,irowm,icolm) = epsADyn(:,irowm,icolm)- &
!                   vc*chiADyntmp(:)*q0norm
!#endif
!                else
!                  epsRDyn(:,irowm,icolm) = epsRDyn(:,irowm,icolm)- &
!                   vc*chiRDyntmp(:)
!#ifdef CPLX
!                  epsADyn(:,irowm,icolm) = epsADyn(:,irowm,icolm)- &
!                   vc*chiADyntmp(:)
!#endif
!                end if
!              endif
        endif
      end do
    end do
  endif

!      write(6,*) 'Created Eps'


!------------- Take Care of the Wings for q--> 0 -------------------------
!
! JRD: This section was removed and deleted (rev 184)
! because we now invert the matrix completely (i.e. wings included)
!
! End treatment of wings for q--> 0
!----------------------------------------------------------------------------


  if (peinf%inode .eq. 0 .and. pol%freq_dep .eq. 0) then
    write(6,*) ' '
    write(6,*) 'Head Before Inversion = ', eps(1,1)
  end if
  if (peinf%inode .eq. 0 .and. pol%freq_dep .eq. 2) then
    write(6,*) ' '
    write(6,*) 'Retarded Head Before Inversion = ', &
      epsRDyn(1,1,1)
#ifdef CPLX
    write(6,*) 'Advanced Head Before Inversion = ', &
      epsADyn(1,1,1)
#endif
    write(6,*) 'Retarded Eps(2,2) Before Inversion = ', &
      epsRDyn(1,2,2)
#ifdef CPLX
    write(6,*) 'Advanced Eps(2,2) Before Inversion = ', &
      epsADyn(1,2,2)
#endif
  end if

!-------------------------------------------------------------
! Print head versus frequency 

  if (peinf%inode.eq.0.and.pol%freq_dep .eq. 2) then
    write(52,'("# q= ",3f12.5," nmtx=",i6)') q0(:),pol%nmtx
    write(52,*)
#ifdef CPLX
    do jj=1,pol%nFreq
      write(52,'(5f12.6)') pol%dFreqGrid(jj), &
        dble(epsRDyn(jj,1,1)),IMAG(epsRDyn(jj,1,1)), &
        dble(epsADyn(jj,1,1)),IMAG(epsADyn(jj,1,1))
    enddo
#else
    do jj=1,pol%nFreq
      write(52,'(3f12.6)') pol%dFreqGrid(jj), &
        dble(epsRDyn(jj,1,1)),IMAG(epsRDyn(jj,1,1))
    enddo
#endif
  endif


!------------ Here we invert the epsilon matrix -----------------------------
!
! JRD: May 2008.  Now we actually invert the whole matrix with wings included.

#if defined USESCALAPACK

  if(pol%freq_dep .eq. 0) then
    call X(invert_with_scalapack)(pol%nmtx, scal, eps)
  endif
  
  if(pol%freq_dep .eq. 2) then
    do jj=1,pol%nFreq
      eps1Aux(:,:) = epsRDyn(jj,:,:)
      call zinvert_with_scalapack(pol%nmtx, scal, eps1Aux)
      epsRDyn(jj,:,:) = eps1Aux(:,:)
#ifdef CPLX
      eps1Aux(:,:) = epsADyn(jj,:,:)
      call zinvert_with_scalapack(pol%nmtx, scal, eps1Aux)
      epsADyn(jj,:,:) = eps1Aux(:,:)
#endif
    enddo
  endif

#else

! Serial Version

  if(pol%freq_dep .eq. 0) then
    call X(invert_serial)(pol%nmtx,eps)
  endif
  
  if(pol%freq_dep .eq. 2) then
    do jj=1,pol%nFreq
      eps1Aux(:,:) = epsRDyn(jj,:,:)
      call zinvert_serial(pol%nmtx,eps1Aux)
      epsRDyn(jj,:,:) = eps1Aux(:,:)
#ifdef CPLX
      eps1Aux(:,:) = epsADyn(jj,:,:)
      call zinvert_serial(pol%nmtx,eps1Aux)
      epsADyn(jj,:,:) = eps1Aux(:,:)
#endif
    enddo
  endif

#endif

! Done inverting
!-----------------------------------------------------------------------------


  if (peinf%inode .eq. 0 .and. pol%freq_dep .eq. 0) then
    write(6,*) ' '
    write(6,*) 'Head After Inversion = ', eps(1,1)
  end if
  if (peinf%inode .eq. 0 .and. pol%freq_dep .eq. 2) then
    write(6,*) ' '
    write(6,*) 'Retarded Head After Inversion = ', &
      epsRDyn(1,1,1)
#ifdef CPLX
    write(6,*) 'Advanced Head After Inversion = ', &
      epsADyn(1,1,1)
#endif
    write(6,*) 'Retarded Eps(2,2) After Inversion = ', &
      epsRDyn(1,2,2)
#ifdef CPLX
    write(6,*) 'Advanced Eps(2,2) After Inversion = ', &
      epsADyn(1,2,2)
#endif
  end if


!--------  put in the effects of the wings  for  q--> 0 ----------------------
!
! JRD: We don`t do this anymore because we now invert entire matrix (wings included)
!
!--------end treatment of the wings  for  q--> 0 -----------------------------


!----------- Print out independent matrix elements ---------------------------

  if (peinf%inode.eq.0.and.pol%freq_dep .eq. 2) then
    write(51,'("# q= ",3f12.5," nmtx=",i6)') q0(:),pol%nmtx
    write(51,*)
    do jj=1,pol%nFreq
#ifdef CPLX
      write(51,'(5f12.6)') pol%dFreqGrid(jj), &
        dble(epsRDyn(jj,1,1)),IMAG(epsRDyn(jj,1,1)), &
        dble(epsADyn(jj,1,1)),IMAG(epsADyn(jj,1,1))
#else
      write(51,'(3f12.6)') pol%dFreqGrid(jj), &
        dble(epsRDyn(jj,1,1)),IMAG(epsRDyn(jj,1,1))
#endif
    enddo
  endif

!      if (pol%freq_dep .eq. 0) then
  if (peinf%inode.eq.0 .and. pol%freq_dep .eq. 0) then
    aflag='q= '

! JRD Warn User about possible lack of symmetry

    write(7,*) 'For q0 points, you should check the symmetry (eps(G,G'') = eps*(-G,-G'')) by'
    write(7,*) 'using the eps0sym code. Wavefunction convergence, as well as a finite q shift'
    write(7,*) 'may cause this property of eps(G,G'') to be broken.'

    write(6,*) 'For q0 points, you should check the symmetry (eps(G,G'') = eps*(-G,-G'')) by'
    write(6,*) 'using the eps0sym code. Wavefunction convergence, as well as a finite q shift'
    write(6,*) 'may cause this property of eps(G,G'') to be broken.'
    
    if (iflagq0.eq.1) aflag='q0='
    write(7,4000) kp%nspin
    do i=1,scal%npr
      is=scal%isrtxrow(i)
      do j=1,scal%npc
        js=scal%isrtxcol(j)
        if (i .eq. j .or. i .eq. j+1) then
          write(7,4200) gvec%k(1:3,is), gvec%k(1:3,js), eps(i,j)
        endif
      end do
    end do
  end if

!      if (pol%freq_dep .eq. 2) then
  if (peinf%inode.eq.0 .and. pol%freq_dep .eq. 2) then
    aflag='q= '
    if (iflagq0.eq.1) aflag='q0='
    write(7,4001) kp%nspin
    do i=1,scal%npr
      is=scal%isrtxrow(i)
      do j=1,scal%npc
        js=scal%isrtxcol(j)
        if (i .eq. j .or. i .eq. j+1) then
          write(7,4300) gvec%k(1:3,is), gvec%k(1:3,js), epsRDyn(1,i,j &
#ifdef CPLX
            ),epsADyn(1,i,j)
#else
          )
#endif
        endif
      end do
    end do
  end if

4000 format(/ /,13x,'g',19x,'gp',9x, &
       'inverse epsilon           nspin= ',1i1)
4001 format(/ /,13x,'g',19x,'gp',9x, &
#ifdef CPLX
       'inverse epsilon RDyn/ADyn nspin= ',1i1)
#else
  'inverse epsilon RDyn      nspin= ',1i1)
#endif

#ifdef CPLX
4200 format(5x,3i5,5x,3i5,5x,2f13.8)
4300 format(5x,3i5,5x,3i5,5x,4f13.8)
#else
4200 format(5x,3i5,5x,3i5,5x,f13.8)
4300 format(5x,3i5,5x,3i5,5x,2f13.8)
#endif
  

!---------- Full-Frequency Sum-Rule -----------------------------------------

  epssum1R=0D0
  epssum2R=0D0

#ifdef CPLX
  epssum1A=0D0
  epssum2A=0D0
#endif
  
  if (peinf%inode.eq.0 .and. pol%freq_dep .eq. 2) then
    do jj=2,pol%nFreq
      
      epssum1R=epssum1R+(1D0*Ryd/pol%dFreqGrid(jj))* &
        IMAG(epsRDyn(jj,1,1))*(pol%dFreqGrid(jj)-pol%dFreqGrid(jj-1))/Ryd
#ifdef CPLX
      epssum1A=epssum1A+(1D0*Ryd/pol%dFreqGrid(jj))* &
        IMAG(epsADyn(jj,1,1))*(pol%dFreqGrid(jj)-pol%dFreqGrid(jj-1))/Ryd
#endif
      
      epssum2R=epssum2R+(pol%dFreqGrid(jj)/Ryd)* &
        IMAG(epsRDyn(jj,1,1))*(pol%dFreqGrid(jj)-pol%dFreqGrid(jj-1))/Ryd
#ifdef CPLX
      epssum2A=epssum2A+(pol%dFreqGrid(jj)/Ryd)* &
        IMAG(epsADyn(jj,1,1))*(pol%dFreqGrid(jj)-pol%dFreqGrid(jj-1))/Ryd
#endif
    enddo
    
    epssum1R=(2D0*epssum1R/Pi_D)+1D0
    epssum1R_rel=(epssum1R)/dble(epsRDyn(1,1,1))
    
#ifdef CPLX
    epssum1A=(-2D0*epssum1A/Pi_D)+1D0
    epssum1A_rel=(epssum1A)/dble(epsADyn(1,1,1))
#endif

    epssum2R_rel=(-1D0*epssum2R)/((Pi_D/2D0)*omega_plasma**2)
#ifdef CPLX
    epssum2A_rel=(epssum2A)/((Pi_D/2D0)*omega_plasma**2)
#endif
    
! Ref: Hybertsen & Louie PRB 34, 5390 (1986), eq. 29 and Appendix A
    write(6,*) ' '
    write(6,*) 'Full Frequency: Sum rules for head:'
    write(6,*) 'Retarded Int((1/w)*Im(eps^-1(w))) =', epssum1R_rel*100D0, ' % of exact'
#ifdef CPLX
    write(6,*) 'Advanced Int((1/w)*Im(eps^-1(w))) =', epssum1A_rel*100D0, ' % of exact'
#endif
    write(6,*) 'Retarded Int((w)*Im(eps^-1(w))) =', epssum2R_rel*100D0, ' % of exact'
#ifdef CPLX
    write(6,*) 'Advanced Int((w)*Im(eps^-1(w))) =', epssum2A_rel*100D0, ' % of exact'
#endif
    write(6,*) ' '
    
  endif


!---------- Place inverse dielectric matrices on tape -----------------------
  
  itape=13
  if (iflagq0.eq.1) itape=12
  if (peinf%inode .eq. 0) then
    write(itape) gvec%ng,pol%nmtx, &
      (pol%isrtx(i),isorti(i),i=1,gvec%ng)
    write(itape) (gvec%ekin(i),i=1,gvec%ng)
    write(itape) (q0(i),i=1,3)
  endif
    
  if (pol%freq_dep .eq. 0) then
    call write_matrix_d(scal,eps,pol%nmtx,itape)
  endif
  
  if(pol%freq_dep .eq. 2) then
#ifdef CPLX
    call write_matrix_f(scal,pol%nFreq,epsRDyn,epsADyn,pol%nmtx,itape)
#else
    call write_matrix_f(scal,pol%nFreq,epsRDyn,pol%nmtx,itape)
#endif
  endif

! Finished writing eps
!------------------------------------------------------------------------


  SAFE_DEALLOCATE(vcoul)
  SAFE_DEALLOCATE(isorti)
  
  if(pol%freq_dep .eq. 0) then
    SAFE_DEALLOCATE(eps)
    SAFE_DEALLOCATE(ewng)
  endif
  
  if(pol%freq_dep .eq. 2) then
    SAFE_DEALLOCATE(chiRDyntmp)
    SAFE_DEALLOCATE(epsRDyn)
#ifdef CPLX
    SAFE_DEALLOCATE(chiADyntmp)
    SAFE_DEALLOCATE(epsADyn)
#endif
    SAFE_DEALLOCATE(eps1Aux)
  endif
  
  POP_SUB(epsinv)
  
  return
end subroutine epsinv
