!=========================================================================
!
! Routines:
!
! (1) write_program_header  Originally by DAS       Last Modified 10/15/2010 (DAS)
!
!     Write a header for the beginning of each program.
!
!=========================================================================

#include "f_defs.h"

subroutine write_program_header(aname, write_to_7)
  use global_m
  use svninfo_m
  implicit none

  character(len=*), intent(in) :: aname
  logical, intent(in) :: write_to_7

  character :: asvninfo*256, aversion*15, adate*11, atime*14

  PUSH_SUB(write_program_header)

  aversion = MYFLAVOR // ' version'
  call getsvninfo(asvninfo)
  call date_time(adate,atime)
  if (peinf%inode .eq. 0) then
    write(6,10) trim(asvninfo)
    if (write_to_7) write(7,10) trim(asvninfo)
 10 format(/,1x,a,/)
    write(6,20) trim(aname),trim(aversion), &
     trim(ondate),trim(adate),trim(attime),trim(atime)
    if (write_to_7) write(7,20) trim(aname),trim(aversion), &
     trim(ondate),trim(adate),trim(attime),trim(atime)
 20 format(1x,a,2x,a,2x,a,2x,a,2x,a,2x,a,/)
    write(6,50)
    write(6,51)
    write(6,50)
    write(6,52)
 50 format('--------------------------------------------------------------------------------')
 51 format(1x,'Please cite the following papers when using results from BerkeleyGW:',/,/, &
           1x,'Jack Deslippe, Georgy Samsonidze, David A. Strubbe, Manish Jain, Marvin L.',/, &
           1x,'Cohen, and Steven G. Louie, "BerkeleyGW: A Massively Parallel Computer Package',/, &
           1x,'for the Calculation of the Quasiparticle and Optical Properties of Materials',/, &
           1x,'and Nanostructures," Comput. Phys. Commun. 183, 1269 (2012)',/,/, &
           1x,'Mark S. Hybertsen and Steven G. Louie, "Electron correlation in semiconductors',/, &
           1x,'and insulators: Band gaps and quasiparticle energies," Phys. Rev. B 34, 5390',/, &
           1x,'(1986)',/,/, &
           1x,'Michael Rohlfing and Steven G. Louie, "Electron-hole excitations and optical',/, &
           1x,'spectra from first principles," Phys. Rev. B 62, 4927 (2000)')
 52 format('')
    write(6,30)
    if (write_to_7) write(7,30)
#ifdef MPI
 30 format(1x,'Running MPI version (parallel)',/)
    write(6,40) peinf%npes
    if (write_to_7) write(7,40) peinf%npes
 40 format(1x,'Running on ',i4,' processor(s)',/)
#else
 30 format(1x,'Running serial version (no MPI)',/)
#endif
  endif

  POP_SUB(write_program_header)
  return

end subroutine write_program_header
