/*------------------------------------------------------------------------------

Header for routines common to Visual/surface.cpp and MeanField/ICM/icm.cpp
  which are in wfn_utils.cpp

------------------------------------------------------------------------------*/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <limits.h>

#define MAX(a,b) ((a) > (b) ? (a) : (b))
#define MAXCHAR 256

typedef struct {
   double x;
   double y;
   double z;
} CARTESIAN;

typedef struct {
   int number;
   char symbol[4];
   char name[14];
   int nvelec;
   int valence;
   int period;
   int group;
   double rcov;
   double rvdw;
   double mass;
   double color[3];
} ELEMENT;

extern const double EPS9;
extern const double INF9;
extern const double BOHR;

/* AAH! global variables! --DAS */
extern int *as;
extern CARTESIAN *ap;
extern double ***scalar;

extern const int vertex[8][3];
extern const ELEMENT periodic_table[119];

void lowercase(char *s);
void erasechar(char *s, char c);
void parse(char *s1, char *s2, char *s3);
int cub_read(char *ifn, int *na, int *ni, int *nj, int *nk, CARTESIAN *sfo, CARTESIAN *sfv, CARTESIAN *sfs);
int xsf_read(char *ifn, int *na, int *ni, int *nj, int *nk, CARTESIAN *sfo, CARTESIAN *sfv, CARTESIAN *sfs);
void cell_set(CARTESIAN sfo, CARTESIAN *sfv, bool uc, CARTESIAN *uco, CARTESIAN *ucv, int ucf, bool sc, CARTESIAN *sco, CARTESIAN *scv, int scf);
void normal_make(CARTESIAN *vector, CARTESIAN *normal, double *weight);
bool box_check(int i, int j, int k, CARTESIAN *gso, CARTESIAN *sfs, CARTESIAN *sco, CARTESIAN *normal, int *n);
int scalar_clone(int *ni, int *nj, int *nk, CARTESIAN *sfo, CARTESIAN *sfs, CARTESIAN uco, CARTESIAN *ucv, CARTESIAN sco, CARTESIAN *scv);
double inversion(int n, double *x, double *y, double z);
double isovalue_scale(int ni, int nj, int nk, int power, double isovalue);
int double_to_int(double dd);
