
!===============================================================================
!
! Routines:
!
! 1. read_cube()        Originally By gsm       Last Modified 9/3/2010 (gsm)
!
!    Reads Gaussian Cube file fnam on unit unum. The result is placed
!    into real (if ip = 1) or imaginary (if ip = 2) part of array boxr
!    on node 0 (if fparafft = .true.) or array boxr_d distributed over
!    nodes (if fparafft = .false.). Gaussian Cube file is tested using
!    lattice vectors a and lattice constant al (in Bohr), kmax is FFT
!    grid size, Nplane is number of FFT xy-planes per node, ierr is
!    return error code (0 means success).
!
!===============================================================================

#include "f_defs.h"

subroutine read_cube(fparafft,unum,fnam,a,al,ip,Nplane,kmax,boxr,boxr_d,ierr)

  use global_m
  implicit none

  logical, intent(in) :: fparafft
  integer, intent(in) :: unum
  character(len=256), intent(in) :: fnam
  real(DP), intent(in) :: al
  real(DP), intent(in) :: a(3,3)
  integer, intent(in) :: ip
  integer, intent(in) :: Nplane
  integer, intent(in) :: kmax(3)
  complex(DPC), intent(inout) :: boxr(kmax(1),kmax(2),kmax(3))
  complex(DPC), intent(inout) :: boxr_d(kmax(1),kmax(2),Nplane)
  integer, intent(out) :: ierr

  real(DP), parameter :: eps4 = 1.0d-4
  
  integer :: i,j,k,k0,k1,k2,jerr,knum,na,ngrid(3)
  real(DP) :: dr,origin(3),step(3,3)
  real(DP), allocatable :: buffer(:)
  character(len=256) :: tmpstr
  
  PUSH_SUB(read_cube)
  
  if (peinf%inode.eq.0) then
    na=0
    ngrid(:)=0
    origin(:)=0.0d0
    step(:,:)=0.0d0
    call open_file(unit=unum,file=fnam,status='old',form='formatted')
    read(unum,*,iostat=jerr)
    if (jerr.eq.0) read(unum,*,iostat=jerr)
    if (jerr.eq.0) read(unum,*,iostat=jerr)na,(origin(j),j=1,3)
    do i=1,3
      if (jerr.eq.0) read(unum,*,iostat=jerr)ngrid(i),(step(j,i),j=1,3)
    enddo
    if (jerr.eq.0) call close_file(unit=unum)
  endif
  
#ifdef MPI
  call MPI_Bcast(jerr,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  call MPI_Bcast(na,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  call MPI_Bcast(ngrid,3,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
  call MPI_Bcast(origin,3,MPI_REAL_DP,0,MPI_COMM_WORLD,mpierr)
  call MPI_Bcast(step,9,MPI_REAL_DP,0,MPI_COMM_WORLD,mpierr)
#endif
  
  if (ngrid(1).ne.kmax(1).or.ngrid(2).ne.kmax(2).or. &
    ngrid(3).ne.kmax(3)) jerr=1
  dr=0.0d0
  do j=1,3
    dr=dr+abs(origin(j))
  enddo
  dr=dr/dble(3)
  if (dr.gt.eps4) jerr=1
  dr=0.0d0
  do i=1,3
    do j=1,3
      dr=dr+abs(dble(ngrid(i))*step(j,i)-al*a(j,i))
    enddo
  enddo
  dr=dr/dble(9)
  if (dr.gt.eps4) jerr=1
  
  if (jerr.eq.0) then
    SAFE_ALLOCATE(buffer, (kmax(3)))
    if (peinf%inode.eq.0) then
      if (mod(kmax(3),6).eq.0) then
        knum=kmax(3)/6
      else
        knum=kmax(3)/6+1
      endif
      call open_file(unit=unum,file=fnam,status='old',form='formatted')
      do i=1,6+na
        read(unum,*)
      enddo
    endif
    do i=1,kmax(1)
      do j=1,kmax(2)
        if (peinf%inode.eq.0) then
          do k=1,knum
            read(unum,103)tmpstr
            k1=6*(k-1)+1
            k2=6*(k-1)+6
            if (k2.gt.kmax(3)) k2=kmax(3)
            read(tmpstr,*)(buffer(k0),k0=k1,k2)
          enddo
        endif
        if (fparafft) then
#ifdef MPI
          call MPI_Bcast(buffer,kmax(3),MPI_REAL_DP,0,MPI_COMM_WORLD,mpierr)
#endif
          if (ip.eq.1) then
            do k=1,kmax(3)
              if (k.ge.Nplane*peinf%inode+1.and.k.le.Nplane*(peinf%inode+1)) &
                boxr_d(i,j,k-Nplane*peinf%inode)=CMPLX(buffer(k),IMAG(boxr_d(i,j,k-Nplane*peinf%inode)))
            enddo
          elseif (ip.eq.2) then
            do k=1,kmax(3)
              if (k.ge.Nplane*peinf%inode+1.and.k.le.Nplane*(peinf%inode+1)) &
                boxr_d(i,j,k-Nplane*peinf%inode)=CMPLX(dble(boxr_d(i,j,k-Nplane*peinf%inode)),buffer(k))
            enddo
          endif
        else
          if (ip.eq.1) then
            do k=1,kmax(3)
              boxr(i,j,k)=CMPLX(buffer(k),IMAG(boxr(i,j,k)))
            enddo
          elseif (ip.eq.2) then
            do k=1,kmax(3)
              boxr(i,j,k)=CMPLX(dble(boxr(i,j,k)),buffer(k))
            enddo
          endif
        endif
      enddo
    enddo
    if (peinf%inode.eq.0) then
      call close_file(unit=unum)
    endif
    SAFE_DEALLOCATE(buffer)
  endif
  
  ierr=jerr
  
  POP_SUB(read_cube)
  
  return
  
103 format(a)
  
end subroutine read_cube

