!============================================================================
!
! Routines:
!
! (1) gmap          Originally by ?          Last Modified: 1/24/2011 (gsm)
!
!============================================================================

#include "f_defs.h"

module gmap_m

  use global_m
  use misc_m
  implicit none

  public :: gmap

contains

subroutine gmap(gvec, syms, nkpt2, itran, kgq, isortc, isorti, ind, phase, die_outside_sphere)
  type (gspace), intent(in) :: gvec         !< uses gvec%k(:,isrtc(1:nkpt2))
  type (symmetry), intent(in) :: syms       !< uses syms%mtrx(:,:,itran) & syms%tnp(:,itran)
  integer, intent(in) :: nkpt2              !< number of g-vector entries in a wavefunction
  integer, intent(in) :: itran              !< index of transformation
  integer, intent(in) :: kgq(3)             !< an umklapp vector (i.e. integer 3-vector)
  integer, intent(in) :: isortc(:)          !< index array for R(q) (gvec%ng)
  integer, intent(in) :: isorti(:)          !< inverse index array for q (gvec%ng)
  integer, intent(out) :: ind(:)            !< indices for the vectors inv(symm(itran))*(g+kgq) (nkpt2)
  SCALAR, intent(out) :: phase(:)           !< exp(-i*(g+kgq).dot.syms%tnp(itran)) (nkpt2)
  logical, intent(in) :: die_outside_sphere !< specifies whether to die if G-vectors are falling outside of the sphere

  integer :: ig, kd(3), kadd, kgrad, kgrad1
  integer :: kg(3), kgr(3), mtrxi(3,3), nout
  real(DP) :: fi
  
  PUSH_SUB(gmap)

! Invert rotation matrix that gives rq

  call invert_matrix_int(syms%mtrx(1:3, 1:3, itran), mtrxi(1:3, 1:3))

! JRD: Temporary Debugging

!      write(6,*) peinf%inode,'itran: ',itran
!      write(6,*) peinf%inode,'mtrxi: '
!      do i = 1, 3
!        write(6,*) peinf%inode,(mtrxi(i,j),j=1,3)
!      enddo
!      write(6,*) peinf%inode,'kgq',kgq

! Loop over g-vectors in function of r(q)

  nout = 0  ! number of waves outside sphere
  do ig = 1, nkpt2

! kg = g(ig) + kgq

    kg(1:3) = gvec%k(1:3, isortc(ig)) + kgq(1:3)

! kgr = (r**-1) kg

    kgr(1:3) = MATMUL(mtrxi(1:3, 1:3), kg(1:3))
    
! Compute address of kgr -> kgrad

    kd(1:3) = kgr(1:3) + gvec%kmax(1:3) / 2 + 1
    if (any(kd(1:3) .lt. 1 .or. kd(1:3) .gt. gvec%kmax(1:3))) then
      call die('gmap: kd out of bounds')
    endif
    kadd = ((kd(1) - 1) * gvec%kmax(2) + kd(2) - 1) * gvec%kmax(3) + kd(3)
    kgrad1 = gvec%indv(kadd) ! indv relate cube and sphere
    if (kgrad1 .lt. 1 .or. kgrad1 .gt. gvec%ng) then
      write(0,*) 'itran = ', itran, 'ig = ', ig, ', kadd = ', kadd, ', kgrad1 = ', kgrad1
      call die('gmap: kgrad1 out of bounds')
    endif
    kgrad = isorti(kgrad1)

! SIB: if kgr is outside the sphere, then increment out counter,
! set its phase to zero, and its ind() entry to the maximum.
    if (kgrad .gt. nkpt2) then ! outside sphere
      nout = nout + 1
      ind(ig) = nkpt2
      phase(ig) = ZERO
    else
! SIB:  Otherwise, record the index of kgr (kgrad) into ind(ig)
! and compute the phase = exp(-i*kg.dot.syms%tnp(:,itran))
      ind(ig) = kgrad
      fi = dot_product(dble(kg(:)), syms%tnp(:,itran))
#ifdef CPLX
      phase(ig) = CMPLX(cos(fi), -sin(fi))
#else
! DAS: The imaginary part can be thrown away because it is always zero
! if we have inversion and time-reversal symmetries, and so can use the real version.
! phase = +/- 1. Otherwise the wavefunction would not be normalized.
! c(G) -> c(G) e^iGt with fractional translation.
! c(G) e^iGt = c(-G)* e^-iGt by time-reversal symmetry
!  = c(G)* e^-iGt by inversion symmetry. c(G) = c(G)* since real.
! Therefore e^iGt = e^-iGt. e^iGt is real, and hence 1 or -1.
! Note there is also a global phase e^ikt, but it is just a convention
! and can be safely ignored here.
      phase(ig) = cos(fi)
      if(abs(abs(phase(ig)) - 1) .gt. TOL_Small) then
        write(0,'(a,i8,a,f12.8,a)') 'phase(', ig, ') = ', phase(ig), ' != +/- 1'
        call die("Illegal phase in gmap, error in fractional translation.")
      endif
#endif
    endif
  enddo !end loop over g-vectors (ig)

  if (die_outside_sphere .and. nout .gt. 0) then
    call die('G-vectors are falling outside of the sphere in gmap')
  endif

  POP_SUB(gmap)

  return
end subroutine gmap

end module gmap_m
