!===============================================================================
!
! Routines:
!
! 1. createpools()        Originally By gsm        Last Modified 8/13/2010 (jrd)
!
!    Create pools of valence bands for Epsilon & Sigma. By default, number of pools
!    is chosen to minimize memory in calculation.
!
!===============================================================================

#include "f_defs.h"

subroutine createpools(nv,nc,npes,npoolsout,nvownout,ncownout)

  use global_m
  implicit none

  integer, intent(in) :: nv,nc,npes 
  integer, intent(out) :: npoolsout,nvownout,ncownout

  integer :: nmemmin,npools,ncown,nvown,nmem,ntime

  PUSH_SUB(createpools)

  nmemmin = nv + nc + 1
  npoolsout = 0
  nvownout = 0
  ncownout = 0

  do npools = 1, min(nv,npes)
    
    if (mod(nv,npools) .eq. 0) then
      nvown = nv / npools
    else
      nvown = (nv / npools) + 1                        
    endif
    
    if (mod(nc,(npes/npools)) .eq. 0) then
      ncown = nc / (npes / npools)
    else
      ncown = nc / (npes / npools) + 1
    endif
    
    nmem = nvown + ncown
    ntime = nvown * ncown
    
    if (nmem .lt. nmemmin) then
      nmemmin = nmem
      npoolsout = npools
      nvownout = nvown
      ncownout = ncown
    endif
    
  enddo
  
  POP_SUB(createpools)
  
  return

end subroutine createpools
