$(if $(wildcard $(PREFIX)/arch.mk),,$(error Error: Please create arch.mk from config/ directory for machine-dependent configuration))
include $(PREFIX)/arch.mk

ifneq ($(wildcard $(PREFIX)/flavor.mk),)
  include $(PREFIX)/flavor.mk
endif
# it is ok not to be present for some targets such as 'clean' and 'all-flavors'
# if it is needed, it will cause an error according to the flavor.mk target below.

ifeq ($(TYPEFLAG),-DCPLX)
  FLAVOR  = .cplx
else
  FLAVOR  = .real
endif

ifeq ($(findstring USESCALAPACK,$(MATHFLAG)),)
  SCALAPACKLIB =
endif

# Fortran preprocessing
CPPOPT  = $(TYPEFLAG) $(COMPFLAG) $(PARAFLAG) $(MATHFLAG) $(DEBUGFLAG)

# C++
CC_CPPOPT = $(TYPEFLAG) $(COMPFLAG) $(C_PARAFLAG) $(DEBUGFLAG)

# C
C_CPPOPT  = $(TYPEFLAG) $(COMPFLAG) $(C_PARAFLAG) $(C_DEBUGFLAG)

COMMON = $(PREFIX)/Common
SPGLIB = $(PREFIX)/MeanField/spglib-1.0.9
# this one is for C, C++, and cpp step for Fortran
INCLUDE = -I$(COMMON)
# this one is for Fortran compilation
FTNINC = $(INCFLAG) $(COMMON) $(INCFLAG) $(FFTWINCLUDE)

MAKE_CLEAN = -$(REMOVE) *.o *.p.f *~ core *__genmod.f90 *.a
# ifort -warn all creates __genmod.f90 files as pseudo-modules
INSTALL_CMD = ln -sf $(PWD)/$@ $(PREFIX)/bin
F90_CMD = $(F90free) $(FTNINC) -c $(FOPTS) $(basename $<).p.f -o $(basename $<).o $(MOD_OPT)$(dir $<)
F90_CMD_NOOPT = $(F90free) $(FTNINC) -c $(FNOOPTS) $(basename $<).p.f -o $(basename $<).o $(MOD_OPT)$(dir $<)
# $(MOD_OPT) directs where to put the resulting *.mod file
f90_CPP = $(FCPP) $(INCLUDE) $(CPPOPT) $< > $(basename $<).p.f
F90_CPP = $(FCPP) -P $(INCLUDE) $(CPPOPT) $< > $(basename $<).p.f
ifneq (,$(filter $(COMPFLAG),-DOPEN64 -DPATH -DABSOFT -DCRAY))
# these compilers name all modules uppercase
MODLINK = @NAME=$(dir $*)`echo $(notdir $*) | tr '[:lower:]' '[:upper:]'`_M.mod; test ! -e $$NAME || ln -sf $(PWD)/$$NAME $(PWD)/$(basename $<)_m.mod
endif

default_goal: default
# GNU make 3.80 and earlier don't have .DEFAULT_GOAL

ALL_COMOBJ = bessel.o fullbz.o subgrp.o gmap.o \
      scalapack.o inversion.o mtxel_m.o mtxel_v.o \
      write_matrix.o read_matrix.o minibzaverage.o vcoul_generator.o \
      trunc_cell_wire.o trunc_cell_box.o \
      trunc_cell_box_d.o trunc_scell_box_d.o fixwings.o checkconsistency.o \
      checkgriduniformity.o checkbz.o eqpcor.o createpools.o \
      read_cube.o fft_parallel.o norm.o genwf.o irrbz.o \
      check_inversion.o write_program_header.o svninfo.o wfn_rho_vxc_io.o \
      random.o sort.o blas.o scalapack.o lapack.o fftw.o misc.o essl.o input_utils.o \
      splines.o groupk.o symmetries.o \
      wfn_utils.o  # this last one is C++
ALL_COMMON_OBJ = $(addprefix $(COMMON)/,$(ALL_COMOBJ))

# these are involved in the modules which all routines must use
GLOBOBJ = global.o typedefs.o nrtype.o push_pop.o message.o peinfo.o timing.o system.o
GLOBALOBJS = $(addprefix $(COMMON)/,$(GLOBOBJ))
GLOBALMODS = $(GLOBALOBJS:.o=_m.mod)


$(PREFIX)/flavor.mk :
	@if [ ! -f $(PREFIX)/flavor.mk ]; then echo "Error: Please create flavor.mk from flavor_real.mk or flavor_cplx.mk."; false ; fi

$(COMMON)/f_defs.h : $(PREFIX)/flavor.mk
$(ALL_COMMON_OBJ) : $(GLOBALMODS) $(COMMON)/f_defs.h $(COMMON)/compiler.h $(PREFIX)/flavor.mk
$(COMMON)/svninfo.o $(COMMON)/svninfo_m.mod : $(GLOBALMODS) $(COMMON)/f_defs.h $(PREFIX)/flavor.mk
$(COMMON)/global.o $(COMMON)/global_m.mod: $(COMMON)/nrtype_m.mod $(COMMON)/timing_m.mod $(COMMON)/typedefs_m.mod $(COMMON)/peinfo_m.mod $(COMMON)/push_pop_m.mod $(COMMON)/message_m.mod $(COMMON)/f_defs.h $(COMMON)/compiler.h $(PREFIX)/flavor.mk
$(COMMON)/vcoul_generator.o $(COMMON)/vcoul_generator_m.mod: $(COMMON)/random_m.mod
$(COMMON)/trunc_scell_box_d.o $(COMMON)/trunc_cell_box.o $(COMMON)/trunc_cell_box_d.o $(COMMON)/trunc_cell_wire.o: \
$(COMMON)/fft_parallel.o $(COMMON)/misc_m.mod $(COMMON)/fftw_m.mod $(COMMON)/fft_parallel_m.mod
$(COMMON)/trunc_cell_wire.o $(COMMON)/trunc_cyl.o : $(COMMON)/bessel_m.mod
$(COMMON)/subgrp.o $(COMMON)/checkbz.o $(COMMON)/irrbz.o : $(COMMON)/misc_m.mod
$(COMMON)/norm.o : $(COMMON)/blas_m.mod
$(COMMON)/misc.o $(COMMON)/misc_m.mod : $(COMMON)/blas_m.mod $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/irrbz.o $(COMMON)/irrbz_m.mod : $(COMMON)/misc_m.mod $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/peinfo.o $(COMMON)/peinfo_m.mod : $(COMMON)/nrtype_m.mod $(COMMON)/f_defs.h
$(COMMON)/timing.o $(COMMON)/timing_m.mod : $(COMMON)/push_pop_m.mod $(COMMON)/nrtype_m.mod $(COMMON)/f_defs.h $(COMMON)/system_m.mod
$(COMMON)/random.o $(COMMON)/random_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/input_utils.o $(COMMON)/input_utils_m.mod : $(COMMON)/global_m.mod $(COMMON)/splines_m.mod $(COMMON)/f_defs.h
$(COMMON)/fixwings.o $(COMMON)/fixwings_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/genwf.o $(COMMON)/genwf_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h $(COMMON)/sort_m.mod $(COMMON)/blas_m.mod $(COMMON)/gmap_m.mod
$(COMMON)/bessel.o $(COMMON)/bessel_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/blas.o $(COMMON)/blas_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/system.o $(COMMON)/system_m.mod : $(COMMON)/f_defs.h $(COMMON)/compiler.h
$(COMMON)/essl.o $(COMMON)/essl_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/lapack.o $(COMMON)/lapack_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/scalapack.o $(COMMON)/scalapack_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/fftw.o $(COMMON)/fftw_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/inversion.o $(COMMON)/inversion_m.mod: $(COMMON)/lapack_m.mod $(COMMON)/scalapack_m.mod $(COMMON)/undef.h $(COMMON)/essl_m.mod
$(COMMON)/sort.o $(COMMON)/sort_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/typedefs.o $(COMMON)/typedefs_m.mod : $(COMMON)/nrtype_m.mod $(COMMON)/f_defs.h
$(COMMON)/nrtype.o $(COMMON)/nrtype_m.mod : $(COMMON)/f_defs.h
$(COMMON)/push_pop.o $(COMMON)/push_pop_m.mod : $(COMMON)/peinfo_m.mod $(COMMON)/message_m.mod $(COMMON)/f_defs.h
$(COMMON)/message.o $(COMMON)/message_m.mod : $(COMMON)/peinfo_m.mod $(COMMON)/nrtype_m.mod $(COMMON)/system_m.mod $(COMMON)/f_defs.h
# the dependency on svninfo_m.mod is "order-only" to avoid unnecessary recompilation
$(COMMON)/write_program_header.o : | $(COMMON)/svninfo_m.mod
$(COMMON)/wfn_rho_vxc_io.o $(COMMON)/wfn_rho_vxc_io_m.mod : $(COMMON)/check_inversion_m.mod $(COMMON)/sort_m.mod $(COMMON)/global_m.mod
$(COMMON)/check_inversion.o $(COMMON)/check_inversion_m.mod : $(COMMON)/global_m.mod
$(COMMON)/read_matrix.o $(COMMON)/write_matrix.o : $(COMMON)/scalapack_m.mod
$(COMMON)/minibzaverage.o : $(COMMON)/misc_m.mod $(COMMON)/bessel_m.mod
$(COMMON)/fft_parallel.o $(COMMON)/fft_parallel_m.mod : $(COMMON)/global_m.mod $(COMMON)/f_defs.h
$(COMMON)/fullbz.o $(COMMON)/fullbz_m.mod : $(COMMON)/global_m.mod $(COMMON)/misc_m.mod $(COMMON)/f_defs.h
$(COMMON)/write_matrix.o $(COMMON)/write_matrix_m.mod : $(COMMON)/global_m.mod $(COMMON)/scalapack_m.mod $(COMMON)/f_defs.h
$(COMMON)/read_matrix.o $(COMMON)/read_matrix_m.mod : $(COMMON)/global_m.mod $(COMMON)/scalapack_m.mod $(COMMON)/f_defs.h
$(COMMON)/splines.o $(COMMON)/splines_m.mod : $(COMMON)/global_m.mod
$(COMMON)/eqpcor.o $(COMMON)/eqpcor_m.mod : $(COMMON)/global_m.mod
$(COMMON)/gmap.o $(COMMON)/gmap_m.mod : $(COMMON)/global_m.mod $(COMMON)/misc_m.mod
$(COMMON)/symmetries.o $(COMMON)/symmetries_m.mod : $(COMMON)/global_m.mod $(COMMON)/misc_m.mod $(COMMON)/sort_m.mod

ifeq ($(COMPFLAG),-DOPEN64)
# other compilers provide this module, so only Open64 needs its own here
# To use it, copy in the file http://www.open64.net/doc/db/d6b/omp__lib_8f-source.html to this directory
# and uncomment the dependencies below,  needed to deal with the fact that the module name doesn't end on _m.
# $(COMMON)/system_m.mod : $(COMMON)/OMP_LIB.mod 
# $(COMMON)/OMP_LIB.mod : $(COMMON)/omp_lib.o 
endif

$(COMMON)/wfn_utils.o : $(COMMON)/wfn_utils.h

common: $(ALL_COMMON_OBJ) $(GLOBALOBJS)


spglib: $(SPGLIB)/libsymspg.a

SPGLIB_SRC = $(addprefix $(SPGLIB)/, cell.c debug.c hall_symbol.c kpoint.c lattice.c mathfunc.c pointgroup.c primitive.c \
refinement.c site_symmetry.c sitesym_database.c spacegroup.c spg_database.c \
spglib.c symmetry.c spglib_f.c)
SPGLIB_OBJ = $(SPGLIB_SRC:.c=.o)

SPGLIB_HEADERS = $(addprefix $(SPGLIB)/, cell.h debug.h hall_symbol.h kpoint.h lattice.h mathfunc.h \
pointgroup.h primitive.h refinement.h site_symmetry.h sitesym_database.h \
spacegroup.h spg_database.h spglib.h symmetry.h)

SPGLIB_OBJ : SPGLIB_HEADERS

$(SPGLIB)/libsymspg.a : $(SPGLIB_OBJ)
	/usr/bin/ar ru $@ $^

#Rules

.SUFFIXES:
# remove all implicit suffix rules

#GNU and gfortran don't update mod files unless interfaces have changed, frustrating make's dependency-checking
ifneq ($(findstring -DG,$(COMPFLAG)),)
RM_MOD_CMD = @$(REMOVE) $(basename $<)_m.mod
endif
ifeq ($(findstring -P,$(FCPP)),)
# if not running with cpp -P, keep .p.f
RM_P_F_CMD = @$(REMOVE) $(basename $<).p.f
endif
# both files are made at once by this rule
%.o %_m.mod : %.f90
	$(RM_MOD_CMD)
	$(f90_CPP)
	$(F90_CMD)
	$(RM_P_F_CMD)
	$(MODLINK)

# Files including _inc.f90 by cpp have their own rules to suppress the many cpp warnings about macro redefinition, 
# keep .p.f, and not insert line markers, so you can tell which of the various preprocessed versions
# caused any runtime error.
%.o %_m.mod : %.F90 %_inc.f90
	$(RM_MOD_CMD)
	$(F90_CPP)
	$(F90_CMD)
	$(MODLINK)

# rules to make .p.f by hand for debugging purposes
%.p.f : %.f90
	$(f90_CPP)
%.p.f : %.F90 %_inc.f90
	$(F90_CPP)

%.o : %.cpp
	$(CC_COMP) $(INCLUDE) $(CC_CPPOPT) -c $(C_OPTS) $< -o $@

# Alas, it seems that if you compile a .c with gcc or .cpp with g++ you get a leading underscore in the symbol
# table, but it you compile a .c with g++ you do not. Therefore we must make a distinction between C and C++ (for spglib).
%.o : %.c
	$(C_COMP) $(INCLUDE) $(C_CPPOPT) -c $(C_OPTS) $< -o $@

clean:
	$(MAKE_CLEAN) *.mod

clean-keepmod:
	$(MAKE_CLEAN)

cleanall:
	$(MAKE_CLEAN) *.mod *.x

clean-wfn_utils:
	-$(REMOVE) $(COMMON)/wfn_utils.o

donkey:
	@$(PREFIX)/LOGO/donkeyfy.sh && sleep 1

# all targets which are not the name of file should be listed here
.PHONY: donkey list default all tools core-tools other-tools common \
epsilon epsilon-all epsilon-tools sigma sigma-all sigma-tools bse bse-all bse-tools \
plotxct nonlinearoptics kernel absorption library spglib \
meanfield symmetry sapo cumexp epm epm2bgw siesta2bgw bgw2para kgrid icm surface \
test openmp scalapack check check-save \
clean clean-common clean-epsilon clean-sigma clean-bse \
clean-plotxct clean-nonlinearoptics clean-library \
clean-meanfield clean-symmetry clean-sapo clean-cumexp clean-epm \
clean-siesta2bgw clean-bgw2para clean-kgrid clean-icm clean-surface \
clean-test clean-openmp clean-scalapack clean-spglib \
cleanall cleanall-bin cleanall-common \
cleanall-epsilon cleanall-sigma cleanall-bse \
cleanall-plotxct cleanall-nonlinearoptics \
cleanall-meanfield cleanall-symmetry cleanall-sapo cleanall-cumexp cleanall-epm \
cleanall-siesta2bgw cleanall-bgw2para cleanall-kgrid \
cleanall-icm cleanall-surface cleanall-cpp \
cleanall-test cleanall-openmp cleanall-scalapack \
utilities clean-utilities cleanall-utilities cleanall-spglib \
clean-keepmod clean-keepmod-common \
clean-keepmod-epsilon clean-keepmod-sigma clean-keepmod-bse \
clean-keepmod-plotxct clean-keepmod-nonlinearoptics \
clean-keepmod-meanfield clean-keepmod-symmetry clean-keepmod-sapo clean-keepmod-epm \
clean-keepmod-siesta2bgw clean-keepmod-bgw2para clean-keepmod-kgrid \
clean-keepmod-icm clean-keepmod-surface clean-keepmod-cumexp \
clean-keepmod-test clean-keepmod-openmp clean-keepmod-scalapack \
clean-keepmod-utilities clean-cpp clean-wfnutils clean-keepmod-spglib

# correct compiler flags for OpenMP
# first, default that is the most common one
OMPOPTS = -openmp
ifeq ($(COMPFLAG),-DPGI)
  OMPOPTS = -mp=nonuma
endif
ifeq ($(COMPFLAG),-DGNU)
  OMPOPTS = -fopenmp
endif
ifeq ($(COMPFLAG),-DXLF)
  OMPOPTS = -qsmp=omp
endif
# Cray uses OpenMP by default with no flags; to turn off use -h noomp
ifeq ($(COMPFLAG),-DCRAY)
  OMPOPTS =
endif
# g95 and NAG do not support OpenMP
