!================================================================================
!
! Routines:
!
! (1) dynamic_screening()       Originally By SIB       Last Modified 7/3/2008 (JRD)
!
! This routine calculates dynamic corrections for certain states if
! eigenvectors is found and dynamic_screening is .true.
!
!=================================================================================

#include "f_defs.h"

subroutine dynamic_screening(xct,nblock,neig,hmtrx)

  use global_m
  implicit none

  type(xctinfo), intent(in) :: xct
  integer, intent(in) :: nblock, neig
  SCALAR, intent(in) :: hmtrx(xct%nkpt*xct%ncband*xct%nvband*xct%nspin, &
    peinf%nblocks*peinf%nblockd)

  logical :: io
  SCALAR, allocatable :: A(:)
  integer :: i,ii,ns,nv,nc,nk,nmat,ic,iv,is,ik
  integer :: icp,ivp,isp,ikp,ikt,ikcvs,ikcvst,ikcvsp
  real(DP) :: e, norm
  SCALAR :: edyn,tmpe

! Who can do io?

  PUSH_SUB(dynamic_screening)

  if (peinf%inode.eq.0) then
    io = .true.
  else
    io = .false.
  endif
  if (io) then
    write(6,'(a)')
    write(6,'(a,i6,a)') 'Calculating dynamic corrections for first ', neig,' states.'
    write(6,'(a)')
  endif

! Try to open the eigenvectors file

  if (io) then
    call open_file(16,file='eigenvectors',form='unformatted',status='old',iostat=ii)
    if (ii.ne.0) then
      write(0,'(a)') 'WARNING: Dynamic screening on but eigenvectors file cannot be opened. Skipping dynamic corrections.'
    endif
  endif

#ifdef MPI
  call MPI_BCAST(ii,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
#endif

  if (ii .ne. 0) then
    POP_SUB(dynamic_screening)
    return
  endif

! Read header info and make sure sizes are right

  if (io) then
    read(16) ns           ! spin
    read(16) nv           ! nv
    read(16) nc           ! nc
    read(16) nk           ! nk
    read(16)              ! kpts
    ii = 0
    if (ns.ne.xct%nspin  .or. nk.ne.xct%nkpt .or. nc.ne.xct%ncband .or. nv.ne.xct%nvband) then
      ii = 1
      write(0,'(a)') 'WARNING: Sizes in eigenvectors do not match those in memory.'
      write(0,'(a)') 'eigenvectors has ns=',ns,' nv=',nv,' nc=',nc,'nk=',nk
      write(0,'(a)') 'Skipping dynamic corrections.'
      call close_file(16)
    endif
  endif

#ifdef MPI
  call MPI_BCAST(ii,1,MPI_INTEGER,0,MPI_COMM_WORLD,mpierr)
#endif
  
  if (ii .ne. 0) then
    POP_SUB(dynamic_screening)
    return
  endif

! Open file to output results to

  if (io) then
    call open_file(17,file='dyn_eigenvalues',form='formatted',status='unknown')
!       rewind(17)
  endif

! Get space for the A coeffs

  nmat = xct%nkpt*nblock
  SAFE_ALLOCATE(A, (nmat))

! Loop over eigenstates and caluculate dynamic corrections

  do i=1,neig
    call logitint('Working on eigenvector ',i)

! Read (original) eigenvalue and eigenvector and broadcast

    if (io) then
      read(16) e
      read(16) (A(ii),ii=1,nmat)
! Do we need this??
      do ii=1,nmat
        A(ii) = MYCONJG(A(ii))
      enddo
    endif

#ifdef MPI
    call MPI_BCAST(A,nmat,MPI_SCALAR,0,MPI_COMM_WORLD,mpierr)
#endif
 
! Calculate dynamic correction

    norm = 0d0
    edyn = (0.0d0,0.0d0)
    do ik=1,xct%nkpt
      do ikt=1,peinf%ikt(peinf%inode+1)
        ikp = peinf%ik(peinf%inode+1,ikt)
        do ic=1,xct%ncband
          do iv=1,xct%nvband
            do is=1,xct%nspin
              ikcvs=is+(iv-1+(ic-1+(ik-1)*xct%ncband)*xct%nvband)*xct%nspin
              if (ikt .eq. 1) then
                norm = norm + dble(MYCONJG(A(ikcvs))*A(ikcvs))
              endif
              
#ifdef VERBOSE
              write(10000 + peinf%inode, *) ikcvs, A(ikcvs)
#endif
              
              do icp=1,xct%ncband
                do ivp=1,xct%nvband
                  do isp=1,xct%nspin
                    
                    ikcvst=isp+(ivp-1+(icp-1+(ikt-1)*xct%ncband)*xct%nvband)*xct%nspin
                    ikcvsp=isp+(ivp-1+(icp-1+(ikp-1)*xct%ncband)*xct%nvband)*xct%nspin
                    
#ifdef VERBOSE
                    write(20000 + peinf%inode, *) ikcvs, ikcvst, hmtrx(ikcvs, ikcvst)
#endif
                    
                    if (ikcvs .eq. ikcvsp) then
                      edyn = edyn + &
                        0.5D0*(MYCONJG(A(ikcvs))*hmtrx(ikcvs,ikcvst)*A(ikcvsp) + & 
                        A(ikcvs)*MYCONJG(hmtrx(ikcvs,ikcvst)*A(ikcvsp)) )

! JRD Symmetrize H!

                    else if (ikcvs .lt. ikcvsp) then
                      edyn = edyn + &
                        A(ikcvs)*hmtrx(ikcvs,ikcvst)*MYCONJG(A(ikcvsp)) + &
                        MYCONJG(A(ikcvs))*MYCONJG(hmtrx(ikcvs,ikcvst))*A(ikcvsp) 
                    endif
                  enddo
                enddo
              enddo
            enddo
          enddo
        enddo
      enddo
    enddo
    
#ifdef MPI
    tmpe = edyn
    call MPI_ALLREDUCE(tmpe,edyn,1,MPI_SCALAR,MPI_SUM,MPI_COMM_WORLD,mpierr)
#endif
    if (io) then
      write(17,'(i5,4f20.10)') i,e,edyn*ryd,norm
    endif
    
  enddo  ! i over eigenvectors
  
!--------------------
! Cleanup

  if (io) then
    call close_file(16)
    call close_file(17)
  endif
  
  SAFE_DEALLOCATE(A)
  
  POP_SUB(dynamic_screening)
  return
  
end subroutine dynamic_screening
