!============================================================================
!
! included from bse_convert.F90
!
!============================================================================

! nmatrix = 3 for bsedmat, = 1 for bsexmat
! loops over head, body, wings for bsedmat
subroutine NAME(bsemat)(iunit, ounit, nmatrix)
  integer, intent(in) :: iunit, ounit, nmatrix

  integer :: nk, nc, nv, ns, ik, jk, ii, imatrix, jj, ic, iv
  real(DP) :: kk(3)
  SCALAR, allocatable :: bsemat(:,:,:,:,:)

  PUSH_SUB(NAME(bsemat))

  READWRITE(nk,nc,nv,ns)
  SAFE_ALLOCATE(bsemat, (nk,nc,nv,ns,ns))
  do ik=1,nk
    READWRITE(jk,kk(1:3))
  enddo
  do ii=1,nk
    do imatrix=1, nmatrix
      do jj=1, nc*nv
        READWRITE(ik,ic,iv,bsemat(:,:,:,:,:))
      enddo
    end do
  end do

  SAFE_DEALLOCATE(bsemat)
  POP_SUB(NAME(bsemat))
  return
end subroutine NAME(bsemat)

!============================================================================
! compare read and write in intwfn.f90
subroutine NAME(dtmat)(iunit, ounit)
  integer, intent(in) :: iunit, ounit

  integer :: nk, nc, nv, nkf, ncf, nvf, ns, nmat, &
    ik, ic, jk, jc, is, ii, iv, jv
  real(DP) :: kk(1:3)
  SCALAR :: dcc, dvv

  PUSH_SUB(NAME(dtmat))

  READWRITE(nk,nc,nv,nkf,ncf,nvf,ns)
  do ik=1, nk
    READWRITE(kk(1:3))
  enddo

  ! cc
  nmat=nkf*ncf*nc*ns
  do ii=1,nmat
    READWRITE(ik,ic,jk,jc,is,dcc)
  enddo

  ! vv
  nmat=nkf*nvf*nv*ns
  do ii=1,nmat
    READWRITE(ik,iv,jk,jv,is,dvv)
  enddo
  
  POP_SUB(NAME(dtmat))
  return
end subroutine NAME(dtmat)

!============================================================================
subroutine NAME(vmtxel)(iunit, ounit)
  integer, intent(in) :: iunit, ounit

  integer :: nkf, ncf, nvf, ns, ic, nmat, ii
  SCALAR, allocatable :: s1(:)

  PUSH_SUB(NAME(vmtxel))

  READWRITE(nkf,ncf,nvf,ns,ic)

  nmat=nkf*ncf*nvf*ns
  SAFE_ALLOCATE(s1, (nmat))
  
  READWRITE((s1(ii),ii=1,nmat))
  SAFE_DEALLOCATE(s1)

  PUSH_SUB(NAME(vmtxel))
  return
end subroutine NAME(vmtxel)

!============================================================================
subroutine NAME(eps2_moments)(iunit, ounit)
  integer, intent(in) :: iunit, ounit
  
  integer :: nn, nmat, ii
  real(DP) :: tmp(2)
  SCALAR, allocatable :: s1(:)
  real(DP), allocatable :: array(:)

  PUSH_SUB(NAME(eps2_moments))

  READWRITE(nn,tmp(1:2),nmat,ii)

  SAFE_ALLOCATE(array, (nn))
  ! an
  READWRITE((array(ii),ii=1,nn))
  ! bn
  READWRITE((array(ii),ii=1,nn))
  SAFE_DEALLOCATE(array)
  
  SAFE_ALLOCATE(s1, (nmat))
  READWRITE((s1(ii),ii=1,nmat))
  READWRITE((s1(ii),ii=1,nmat))
  SAFE_DEALLOCATE(s1)
  
  PUSH_SUB(NAME(eps2_moments))
  return
end subroutine NAME(eps2_moments)
  
!============================================================================
subroutine NAME(eigenvectors)(iunit, ounit)
  integer, intent(in) :: iunit, ounit

  integer :: ns, nv, nc, nk, nmat, ii, ik, isvck
  real(DP), allocatable :: kg(:,:)
  real(DP) :: tmp
  SCALAR, allocatable :: Asvck(:)
  
  PUSH_SUB(NAME(eigenvectors))

  READWRITE(ns)
  READWRITE(nv)
  READWRITE(nc)
  READWRITE(nk)

  SAFE_ALLOCATE(kg, (3,nk))
  READWRITE(((kg(ii,ik),ii=1,3),ik=1,nk))
  SAFE_DEALLOCATE(kg)

  nmat = ns*nv*nc*nk
  SAFE_ALLOCATE(Asvck, (nmat))

  do isvck = 1, ns*nv*nc*nk
    READWRITE(tmp)
    READWRITE((Asvck(ik),ik=1,nmat))
  enddo
    
  SAFE_DEALLOCATE(Asvck)
    
  POP_SUB(NAME(eigenvectors))
  return
end subroutine NAME(eigenvectors)

