Group: mf_header
Content: Information from the WFN file.
#===============================================================================


Group: eps_header
Content: Everything but the dielectric matrices.
#===============================================================================

	Dataset: versionnumber
	Type: integer
	Rank: 0
	Value: Version number of this particular file.

	Dataset: flavor
	Type: integer
	Rank: 0
	Value: 1 for Real, 2 for CPLX.


	Group: params
	Content: General parameters.
	#===============================================================================

		Dataset: matrix_type
		Type: integer
		Rank: 0
		Value: Controls what matrix we compute: 0=epsilon^{-1} (epsmat.h5), 
		1=epsilon (not implemented), 2=chi0 (chimat.h5).

		Dataset: has_advanced
		Type: integer/logical
		Rank: 0
		Value: Whether we store the advanced matrix. This is the default in
		BerkeleyGW 1.1.x, but only for FF calculations with CPLX flavor.

		Dataset: nmatrix
		Type: integer
		Rank: 0
		Value: Number of matrices we store. If we store dielectric matrices,
		this is (has_advanced+1). For polarizability calculations, this is
		(has_advanced+1)*nspin.

		Dataset: matrix_flavor
		Type: integer
		Rank: 0
		Value: Whether we represent the dielectric matrix with real or complex numbers.
		This will be 2 (i.e., we store complex numbers), unless we have a static
		calculation run with the real code.

		Dataset: icutv
		Type: integer
		Rank: 0
		Value: Truncation flag. See Epsilon/inread.f90 for the meaning of each icutv.

		Dataset: ecuts
		Type: double
		Rank: 0
		Value: Cutoff for screened Coulomb interaction.

		Dataset: nband
		Type: integer
		Rank: 0
		Value: Total number of bands included in the epsilon calculation.

		Dataset: efermi
		Type: double
		Rank: 0
		Value: Fermi level determined by the code, in ryd.



	Group: qpoints
	Content: Q-points-related datasets
	#===============================================================================

		Dataset: nq
		Type: integer
		Rank: 0
		Value: Number of q-points.

		Dataset: qpts
		Rank: 2
		Dims(1): 3 #(the three crystal coordinates)
		Dims(2): nq
		Value: Q-points.

		Dataset: qgrid
		Type: integer
		Rank: 1
		Dims(1): 3
		Value: Q-grid used in epsilon calculation.

		Dataset: qpt_done
		Type: integer/logical
		Rank: 1
		Dims(1): nq
		Value: 1 is the calculation for a particular q-point is done, 0 if not.


	Group: freqs
	Content: Frequency-related datasets
	#===============================================================================

		Dataset: freq_dep
		Type: integer
		Rank: 0
		Value: Frequency dependency (same as in epsilon.inp and sigma.inp).

		Dataset: nfreq
		Type: integer
		Rank: 0
		Value: Number of frequency points.

		Dataset: nfreq_imag
		Type: integer
		Rank: 0
		Value: Number of imaginary frequency points. Used for CD calculations.

		Dataset: freqs
		Type: double
		Rank: 2
		Dims(1): 2 #(Real/complex part)
		Dims(2): nfreq
		Value: Frequencies, including broadening.


	Group: gspace
	Content: G-vectors-related datasets
	#===============================================================================

		Dataset: nmtx
		Type: integer
		Rank: 1
		Dims(1): nq
		Value: Number of matrix elements we actually compute for each q-point.

		Dataset: nmtx_max
		Type: integer
		Rank: 0
		Value: Same as maxval(nmtx(1:nq)).

		Dataset: ekin
		Type: double
		Rank: 2
		Dims(1): ng
		Dims(2): nq
		Value: Kinetic energies |G+q|^2, in Rydberg. Note: the G-vectors are sorted
		wrt the RHO G-space |G|^2, and not wrt epsilon G-space |G+q|^2!

		Dataset: gind_eps2rho
		Type: integer
		Rank: 2
		Dims(1): ng
		Dims(2): nq
		Value: Given a row/column ig_eps from the epsilon matrix (in the epsilon G-space),
		map_eps2rho(ig_eps,iq) is the index of the corresponding G-vector in the RHO G-space.

		Dataset: gind_rho2eps
		Type: integer
		Rank: 2
		Dims(1): ng
		Dims(2): nq
		Value: Given a G-vector ig from the RHO G-space, map_rho2eps(ig,iq) is the corresponding
		row/column in the epsilon matrix (i.e., the index in the epsilon G-space).


Group: mats
Content: Matrix-elements-related datasets
#===============================================================================

	Dataset: matrix
	Type: double
	Rank: 6
	Dims(1): matrix_flavor
	Dims(2): nmtx_max #rows of the matrix
	Dims(3): nmtx_max #columns of the matrix
	Dims(4): nfreq
	Dims(5): nmatrix
	Dims(6): nq
	Value: Matrix elements (see matrix_type dataset). Rows/columns are sorted wrt epsilon(q) G-space,
	|q+G|^2. Note: for each q-point, we only really compute values up to nmtx(q).

	Dataset: matrix-diagonal
	Type: double
	Rank: 3
	Dims(1): matrix_flavor
	Dims(2): nmtx_max #diagonal elements of the matrix
	Dims(3): nq
	Value: Static diagonal elements from "matrix" dataset. Not used when matrix_type==2.
