!==============================================================================
!
! Utilities:
!
! (1) summarize_eigenvectors()       Originally By JRD,CHP   Last Modified: 6/5/2008 (JRD)
!
!     This program prints some useful information about the exciton wavefunction.
!
!==============================================================================

#include "f_defs.h"

program summarize_eigenvectors

  use global_m
  implicit none

  integer :: ns, nc, nv, nk, nmat, i, m, uul,uur, c, v, s, ik, ikmax
  integer :: ns_, nc_, nv_, nk_, nmat_
  integer :: ijk, up,nexc, ninfile
  logical :: tda
  real(DP) :: energy, energy_l, weight, this_weight, wmax, emax, emin
  real(DP), allocatable :: kk(:,:), kk_l(:,:), energies(:)
  SCALAR, allocatable :: Aread(:),A(:,:,:,:)
! For NTDA:
  SCALAR, allocatable :: A2read_r(:),A2read_l(:),A1read_r(:),A1read_l(:)
  SCALAR, allocatable :: A1_r(:,:,:,:),A1_l(:,:,:,:)
  SCALAR, allocatable :: A2_r(:,:,:,:),A2_l(:,:,:,:)
!
  character*20, allocatable :: filename(:)
  
  up = 10
  uur = 11
  uul = 12
  
  call open_file(unit=up,file='summarize_eigenvectors.inp',status='old')
  
  read(up,*) tda
  read(up,*) ninfile
  read(up,*) emin, emax
  read(up,*) nexc
  if (nexc .gt. 0) then
    SAFE_ALLOCATE(energies, (nexc))
    SAFE_ALLOCATE(filename, (nexc))
    do ijk =1, nexc
      read(up,*) energies(ijk)
    enddo
    do ijk =1, nexc
      write(filename(ijk),'(a8,i2.2)') 'exciton_',ijk
    enddo
  endif
  close (up) 

! Read eigenvectors file:
  if ( tda ) then 
    call open_file(unit=uur,file='eigenvectors',form='unformatted',status='old')
  else
    call open_file(unit=uul,file='eigenvectors_l',form='unformatted',status='old')
    call open_file(unit=uur,file='eigenvectors_r',form='unformatted',status='old')
  end if

! Calculate nmat:
    read(uur) ns
    read(uur) nv
    read(uur) nc
    read(uur) nk
    nmat = ns*nv*nc*nk
  if (.not. tda ) then
    read(uul) ns_
    read(uul) nv_
    read(uul) nc_
    read(uul) nk_
    nmat_ = ns_*nv_*nc_*nk_
    if( nmat .ne. nmat_) then
      write(*,*)' Error found: nmat should be equal for left and right eigenvalue matrices'
      call exit(1)
    end if
  end if
  
  if (ninfile .eq. 0) then
    ninfile = nmat
  endif
  
  write(6,'(a)')
  write(6,'(a)') 'Reading eigenvectors'
  write(6,'(a)')
  write(6,'(a,4i5)') ' ns, nv, nc, nk = ',ns,nv,nc,nk
  write(6,'(a,i8)') ' nmat = ',nmat
  SAFE_ALLOCATE(kk, (3,nk))
  read(uur) kk(:,:)
  if( .not. tda ) then
    SAFE_ALLOCATE(kk_l, (3,nk))
    read(uul) kk_l(:,:)
!   Check:
    do ik=1,nk
      if( abs(kk(1,ik)-kk_l(1,ik)) > 1.d06) then
        if( abs(kk(2,ik)-kk_l(2,ik)) > 1.d06) then
          if( abs(kk(3,ik)-kk_l(3,ik)) > 1.d06) then
            write(6,*)'Inconsistency in k-points found in left and right eigenvalues'
            call exit(1)
          end if
        end if
      end if 
    end do
    SAFE_DEALLOCATE(kk_l)
  end if
  write(6,'(a)')
  write(6,'(a)') 'kpoints follow:'
  do ik=1,nk
    write(6,'(i5,3f10.5)') ik, kk(:,ik)
  enddo
  write(6,'(a)')
  write(6,'(a)') 'exciton energies follow (eV)'
  write(6,'(a)') 'wtot = sum_k |A_vck|^2. wmax = max_k |A_vck|^2. |A_vc (ikmax)|^2 = wmax.'

  if ( tda ) then
    SAFE_ALLOCATE(Aread, (nmat))
    SAFE_ALLOCATE(A, (ns,nv,nc,nk))
  else
    SAFE_ALLOCATE(A2read_l, (nmat))
    SAFE_ALLOCATE(A2read_r, (nmat))
    SAFE_ALLOCATE(A1read_l, (nmat))
    SAFE_ALLOCATE(A1read_r, (nmat))
    SAFE_ALLOCATE(A2_l, (ns,nv,nc,nk))
    SAFE_ALLOCATE(A2_r, (ns,nv,nc,nk))
    SAFE_ALLOCATE(A1_l, (ns,nv,nc,nk))
    SAFE_ALLOCATE(A1_r, (ns,nv,nc,nk))
  end if
  do i=1,ninfile
    if ( tda ) then
       read(uur) energy
       read(uur) Aread(:)
    else
       read(uur) energy
       read(uur) A1read_r(:),A2read_r(:)
       read(uul) energy_l
       read(uul) A1read_l(:),A2read_l(:)
       if( abs(energy_l - energy)>1.d-12) then
          write(6,*)'Inconsistency in energies in left and right eigenfuncion files'
          call exit(1)
       end if
    end if
    if ((energy <= emax) .and. (energy >= emin))  then
      if ( tda ) then
        m = 0
        do ik=1,nk
          do c=1,nc
            do v=1,nv
              do s=1,ns
                m = m+1
                A(s,v,c,ik) = Aread(m)
              enddo
            enddo
          enddo
        enddo
      else
        m = 0
        do ik=1,nk
          do c=1,nc
            do v=1,nv
              do s=1,ns
                m = m+1
                A2_l(s,v,c,ik) = A2read_l(m)
                A2_r(s,v,c,ik) = A2read_r(m)
                A1_l(s,v,c,ik) = A1read_l(m)
                A1_r(s,v,c,ik) = A1read_r(m)
              enddo
            enddo
          enddo
        enddo
      end if !tda
      write(6,'(a)')
      write(6,'(a)')
      write(6,'(a,i5,f10.5)') ' Special analysis for state ',i,energy
      write(6,'(2a5,3a10)') 'c','v','wtot','wmax','ikmax'
      do c=1,nc
        do v=1,nv
          weight = 0.0d0
          wmax = 0.0d0
          do ik=1,nk
            do s=1,ns
              if ( tda ) then
                this_weight = abs(A(s,v,c,ik))**2
              else 
                this_weight = MYCONJG(A1_l(s,v,c,ik))*A1_r(s,v,c,ik) + &
                              MYCONJG(A2_l(s,v,c,ik))*A2_r(s,v,c,ik) 
              end if
              weight=weight+this_weight
              if (this_weight > wmax) then
                wmax = this_weight
                ikmax = ik
              endif
            enddo
          enddo
          write(6,'(2i5,2f10.5,i10)') c, v, weight, wmax, ikmax
        enddo
      enddo
      
      do ijk = 1, nexc
        if (abs(energy - energies(ijk)) .le. 1d-5) then
          write(6,'(a,i6,f12.6)') 'Calculating A(k) for :',ijk,energies(ijk)
          call open_file(unit=200+ijk,file=filename(ijk),status='replace')
          write(200+ijk, '(a,a9,2a10,a18)') '#', 'kx', 'ky', 'kz', 'sum |A(k)|^2'
          do ik=1,nk
            weight = 0.0d0
            do c=1,nc
              do v=1,nv
                do s=1,ns
                  if ( tda ) then
                    this_weight=abs(A(s,v,c,ik))**2
                  else 
                    this_weight = MYCONJG(A1_l(s,v,c,ik))*A1_r(s,v,c,ik) + &
                                  MYCONJG(A2_l(s,v,c,ik))*A2_r(s,v,c,ik)
                  end if 
                  weight = weight + this_weight 
                enddo
              enddo
            enddo
            write(200+ijk,'(3f10.5,f18.5)') kk(1:3,ik),weight
          enddo
          call close_file(200+ijk)
        endif
      enddo
      
    endif
  enddo
  write(6,'(a)')
  call close_file(uur)
  if ( .not. tda) call close_file(uul)
  
  SAFE_DEALLOCATE(kk)
  if ( tda ) then
    SAFE_DEALLOCATE(Aread)
    SAFE_DEALLOCATE(A)
  else
    SAFE_DEALLOCATE(A1read_l)
    SAFE_DEALLOCATE(A1read_r)
    SAFE_DEALLOCATE(A2read_l)
    SAFE_DEALLOCATE(A2read_r)
    SAFE_DEALLOCATE(A1_l)
    SAFE_DEALLOCATE(A1_r)
    SAFE_DEALLOCATE(A2_l)
    SAFE_DEALLOCATE(A2_r)
  end if
  
end program summarize_eigenvectors
