# Beekeeper Studio

Beekeeper Studio is a free and open source SQL editor and database manager. Beekeeper Studio is cross-platform, and available for Linux, Mac, and Windows.

## Features

- Autocomplete SQL query editor with syntax highlighting
- Tabbed interface, so you can multitask
- Sort and filter table data to find just what you need
- Sensible keyboard-shortcuts
- Save queries for later
- Query run-history, so you can find that one query you got working 3 days ago
- Default dark theme

One of our frustrations with other open-source SQL editors and database managers is that they take a 'kitchen sink' approach to features, adding so many features that the UI becomes cluttered and hard to navigate. We wanted a good looking, open source SQL workbench that powerful, but also easy to use. We couldn't find one, so we created it!

![SQL Editing Demo](https://raw.githubusercontent.com/beekeeper-studio/beekeeper-studio/master/screenshots/beekeeper-studio-demo.gif)

Beekeeper Studio supports connecting to the following databases:

- SQLite
- MySQL
- MariaDB
- Postgres
- SQL Server
- Amazon Redshift

## Installation

Download the latest release from the [releases page](https://github.com/beekeeper-studio/beekeeper-studio/releases), or from [our website](https://beekeeperstudio.io)

## Contributing

Please feel free to file issues, open pull requests, or comment on existing issues with feedback.

Building an inclusive and welcoming community is important to us, so please follow our code of conduct as you engage with the project.


## Big Thanks

Beekeeper Studio wouldn't exist without [Sqlectron-core](https://github.com/sqlectron/sqlectron-core), the core database libraries from the (now unmaintained) Sqlectron project. Beekeeper Studio started as an experimental fork of that repository. A big thanks to @maxcnunes and the rest of the Sqlectron community.
