/*******************************************************************
 *  Copyright (c) 2007-2008 Jetico, Inc., Finland
 *  All rights reserved.
 *
 *  File:          options.h
 *
 *  Description:   BestCrypt wipe utility
 *
 *  Author:        Alexander Pichuev
 *
 *  Created:       10-Sep-2007
 *
 *  Revision:      $Id: options.h 216 2008-08-28 07:02:34Z pav $ 
 *
 *
 *******************************************************************/

#ifndef _options_H_
#define _options_H_

#define TRUE        1
#define FALSE       0

#define VERSION     "1.7-7"
#define OPTSTRING   "Vhvln:rfwm:dbIiSspF"

extern int o_verbose;			/* = FALSE; -v,  */
extern int o_verbose_light;		/* = FALSE; -l,  */
extern int o_recurse;			/* = FALSE; -r, */
extern int o_force;			/* = FALSE; -f, */
extern int o_pas_num;			/* = DPASSES; */
extern int o_dont_delete;		/* = FALSE; -d, do not delete files after wiping */
extern int o_wipe_dev;			/* = FALSE; -b, wipe devices */
extern int o_interactive;		/* = TRUE;  -i, ask confirmation for wiping, -I disable interactive */
extern int o_use_DoD;			/* = FALSE; -m d and -n switch on using DoD standart */
extern int o_use_rand;			/* = FALSE; -s, use system random instead of SHA-1 */
extern int o_use_buff;			/* = FALSE; -p, use 64Kb random buffer instead of full random */
extern int o_dont_wipe_fn;		/* = FALSE; -D, do not wipe file names */
extern int o_wipe_slacks;		/* = FALSE; -S, wipe file slacks */
extern int o_wipe_free_space;	/* = FALSE; -F, wipe free space */
extern int o_nas_wiping;		/* = FALSE; n, NAS wiping */
extern int o_nas_delay;			/* = 0;     n, NAS wiping delay*/
extern char *o_user_file;		/* = NULL;  -u, user defined patterns (filename) */
extern int o_use_zero;			/* = FALSE; -m z */
extern int o_use_sector_number;	/* = FALSE; -m t */
extern int o_verify_last_pass;	/* = TRUE; */

extern int parseOptions( int *pArgc, char** pArgv[] );

#endif
