/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.SourceHeaderBoundClass;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.MethodSymbol;
import com.google.turbine.binder.sym.ParamSymbol;
import com.google.turbine.binder.sym.RecordComponentSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.model.TurbineVisibility;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineModifier;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import com.google.turbine.types.Deannotate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jspecify.nullness.Nullable;

public class TypeBinder {
    private final TurbineLog.TurbineLogWithSource log;
    private final Env<ClassSymbol, HeaderBoundClass> env;
    private final ClassSymbol owner;
    private final SourceHeaderBoundClass base;

    public static SourceTypeBoundClass bind(TurbineLog.TurbineLogWithSource log, Env<ClassSymbol, HeaderBoundClass> env, ClassSymbol sym, SourceHeaderBoundClass base) {
        return new TypeBinder(log, env, sym, base).bind();
    }

    private TypeBinder(TurbineLog.TurbineLogWithSource log, Env<ClassSymbol, HeaderBoundClass> env, ClassSymbol owner, SourceHeaderBoundClass base) {
        this.log = log;
        this.env = env;
        this.owner = owner;
        this.base = base;
    }

    private SourceTypeBoundClass bind() {
        Type superClassType;
        CompoundScope enclosingScope = this.base.scope().toScope(Resolve.resolveFunction(this.env, this.owner)).append(new SingletonScope(this.base.decl().name().value(), this.owner));
        if (this.base.owner() != null) {
            enclosingScope = enclosingScope.append(new ClassMemberScope(this.base.owner(), this.env));
        }
        ImmutableList<AnnoInfo> annotations = this.bindAnnotations(enclosingScope, this.base.decl().annos());
        CompoundScope bindingScope = enclosingScope;
        bindingScope = bindingScope.append(new MapScope(this.base.typeParameters()));
        ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes = this.bindTyParams(this.base.decl().typarams(), bindingScope, (Map<String, TyVarSymbol>)this.base.typeParameters());
        ImmutableList.Builder interfaceTypes = ImmutableList.builder();
        switch (this.base.kind()) {
            case ENUM: {
                superClassType = Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)ImmutableList.of((Object)Type.ClassTy.SimpleClassTy.create(ClassSymbol.ENUM, (ImmutableList<Type>)ImmutableList.of((Object)Type.ClassTy.asNonParametricClassTy(this.owner)), (ImmutableList<AnnoInfo>)ImmutableList.of())));
                break;
            }
            case ANNOTATION: {
                superClassType = Type.ClassTy.OBJECT;
                interfaceTypes.add((Object)Type.ClassTy.asNonParametricClassTy(ClassSymbol.ANNOTATION));
                break;
            }
            case CLASS: {
                if (this.base.decl().xtnds().isPresent()) {
                    superClassType = this.checkClassType(bindingScope, this.base.decl().xtnds().get(), false);
                    break;
                }
                if (this.owner.equals(ClassSymbol.OBJECT)) {
                    superClassType = null;
                    break;
                }
                superClassType = Type.ClassTy.OBJECT;
                break;
            }
            case INTERFACE: {
                if (this.base.decl().xtnds().isPresent()) {
                    throw new AssertionError();
                }
                superClassType = Type.ClassTy.OBJECT;
                break;
            }
            case RECORD: {
                superClassType = Type.ClassTy.asNonParametricClassTy(ClassSymbol.RECORD);
                break;
            }
            default: {
                throw new AssertionError((Object)this.base.decl().tykind());
            }
        }
        for (Tree.ClassTy i : this.base.decl().impls()) {
            interfaceTypes.add((Object)this.checkClassType(bindingScope, i, true));
        }
        ImmutableList.Builder permits = ImmutableList.builder();
        for (Tree.ClassTy i : this.base.decl().permits()) {
            Type type = this.bindClassTy(bindingScope, i);
            if (!type.tyKind().equals((Object)Type.TyKind.CLASS_TY)) {
                throw new AssertionError((Object)type.tyKind());
            }
            permits.add((Object)((Type.ClassTy)type).sym());
        }
        CompoundScope scope = this.base.scope().toScope(Resolve.resolveFunction(this.env, this.owner)).append(new SingletonScope(this.base.decl().name().value(), this.owner)).append(new ClassMemberScope(this.owner, this.env));
        SyntheticMethods syntheticMethods = new SyntheticMethods();
        ImmutableList<TypeBoundClass.RecordComponentInfo> components = this.bindComponents(scope, this.base.decl().components());
        List<TypeBoundClass.MethodInfo> boundMethods = this.bindMethods(scope, this.base.decl().members(), components);
        ImmutableList methods = this.base.kind().equals((Object)TurbineTyKind.RECORD) ? this.recordMethods(syntheticMethods, components, boundMethods) : ImmutableList.builder().addAll(this.syntheticMethods(syntheticMethods)).addAll(boundMethods).build();
        ImmutableList<TypeBoundClass.FieldInfo> fields = this.bindFields(scope, this.base.decl().members());
        return new SourceTypeBoundClass((ImmutableList<Type>)interfaceTypes.build(), (ImmutableList<ClassSymbol>)permits.build(), superClassType, typeParameterTypes, this.base.access(), components, (ImmutableList<TypeBoundClass.MethodInfo>)methods, fields, this.base.owner(), this.base.kind(), this.base.children(), this.base.typeParameters(), enclosingScope, scope, this.base.memberImports(), null, annotations, this.base.source(), this.base.decl());
    }

    private ImmutableList<TypeBoundClass.MethodInfo> recordMethods(SyntheticMethods syntheticMethods, ImmutableList<TypeBoundClass.RecordComponentInfo> components, List<TypeBoundClass.MethodInfo> boundMethods) {
        ArrayList<TypeBoundClass.MethodInfo> boundConstructors = new ArrayList<TypeBoundClass.MethodInfo>();
        ArrayList<TypeBoundClass.MethodInfo> boundNonConstructors = new ArrayList<TypeBoundClass.MethodInfo>();
        boolean hasToString = false;
        boolean hasEquals = false;
        boolean hasHashCode = false;
        boolean hasPrimaryConstructor = false;
        for (TypeBoundClass.MethodInfo m : boundMethods) {
            if (m.name().equals("<init>")) {
                if (this.isPrimaryConstructor(m, components)) {
                    hasPrimaryConstructor = true;
                }
                boundConstructors.add(m);
                continue;
            }
            switch (m.name()) {
                case "toString": {
                    hasToString = m.parameters().isEmpty();
                    break;
                }
                case "equals": {
                    hasEquals = m.parameters().size() == 1 && TypeBinder.hasSameErasure(((TypeBoundClass.ParamInfo)Iterables.getOnlyElement(m.parameters())).type(), Type.ClassTy.OBJECT);
                    break;
                }
                case "hashCode": {
                    hasHashCode = m.parameters().isEmpty();
                    break;
                }
            }
            boundNonConstructors.add(m);
        }
        ImmutableList.Builder methods = ImmutableList.builder();
        methods.addAll(boundConstructors);
        if (!hasPrimaryConstructor) {
            methods.add((Object)this.defaultRecordConstructor(syntheticMethods, components));
        }
        methods.addAll(boundNonConstructors);
        if (!hasToString) {
            MethodSymbol toStringMethod = syntheticMethods.create(this.owner, "toString");
            methods.add((Object)new TypeBoundClass.MethodInfo(toStringMethod, (ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of(), Type.ClassTy.STRING, (ImmutableList<TypeBoundClass.ParamInfo>)ImmutableList.of(), (ImmutableList<Type>)ImmutableList.of(), 17, null, null, (ImmutableList<AnnoInfo>)ImmutableList.of(), null));
        }
        if (!hasHashCode) {
            MethodSymbol hashCodeMethod = syntheticMethods.create(this.owner, "hashCode");
            methods.add((Object)new TypeBoundClass.MethodInfo(hashCodeMethod, (ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of(), Type.PrimTy.create(TurbineConstantTypeKind.INT, (ImmutableList<AnnoInfo>)ImmutableList.of()), (ImmutableList<TypeBoundClass.ParamInfo>)ImmutableList.of(), (ImmutableList<Type>)ImmutableList.of(), 17, null, null, (ImmutableList<AnnoInfo>)ImmutableList.of(), null));
        }
        if (!hasEquals) {
            MethodSymbol equalsMethod = syntheticMethods.create(this.owner, "equals");
            methods.add((Object)new TypeBoundClass.MethodInfo(equalsMethod, (ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of(), Type.PrimTy.create(TurbineConstantTypeKind.BOOLEAN, (ImmutableList<AnnoInfo>)ImmutableList.of()), (ImmutableList<TypeBoundClass.ParamInfo>)ImmutableList.of((Object)new TypeBoundClass.ParamInfo(new ParamSymbol(equalsMethod, "other"), Type.ClassTy.OBJECT, (ImmutableList<AnnoInfo>)ImmutableList.of(), 32768)), (ImmutableList<Type>)ImmutableList.of(), 17, null, null, (ImmutableList<AnnoInfo>)ImmutableList.of(), null));
        }
        for (TypeBoundClass.RecordComponentInfo c : components) {
            MethodSymbol componentMethod = syntheticMethods.create(this.owner, c.name());
            methods.add((Object)new TypeBoundClass.MethodInfo(componentMethod, (ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of(), c.type(), (ImmutableList<TypeBoundClass.ParamInfo>)ImmutableList.of(), (ImmutableList<Type>)ImmutableList.of(), 1, null, null, c.annotations(), null));
        }
        return methods.build();
    }

    private TypeBoundClass.MethodInfo defaultRecordConstructor(SyntheticMethods syntheticMethods, ImmutableList<TypeBoundClass.RecordComponentInfo> components) {
        MethodSymbol symbol = syntheticMethods.create(this.owner, "<init>");
        ImmutableList.Builder params = ImmutableList.builder();
        for (TypeBoundClass.RecordComponentInfo component : components) {
            params.add((Object)new TypeBoundClass.ParamInfo(new ParamSymbol(symbol, component.name()), component.type(), component.annotations(), component.access()));
        }
        return this.syntheticConstructor(symbol, (ImmutableList<TypeBoundClass.ParamInfo>)params.build(), TurbineVisibility.fromAccess(this.base.access()));
    }

    private boolean isPrimaryConstructor(TypeBoundClass.MethodInfo m, ImmutableList<TypeBoundClass.RecordComponentInfo> components) {
        if (m.parameters().size() != components.size()) {
            return false;
        }
        for (int i = 0; i < m.parameters().size(); ++i) {
            if (TypeBinder.hasSameErasure(((TypeBoundClass.ParamInfo)m.parameters().get(i)).type(), ((TypeBoundClass.RecordComponentInfo)components.get(i)).type())) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSameErasure(Type a, Type b) {
        switch (a.tyKind()) {
            case PRIM_TY: {
                return b.tyKind() == Type.TyKind.PRIM_TY && ((Type.PrimTy)a).primkind() == ((Type.PrimTy)b).primkind();
            }
            case CLASS_TY: {
                return b.tyKind() == Type.TyKind.CLASS_TY && ((Type.ClassTy)a).sym().equals(((Type.ClassTy)b).sym());
            }
            case ARRAY_TY: {
                return b.tyKind() == Type.TyKind.ARRAY_TY && TypeBinder.hasSameErasure(((Type.ArrayTy)a).elementType(), ((Type.ArrayTy)b).elementType());
            }
            case TY_VAR: {
                return b.tyKind() == Type.TyKind.TY_VAR && ((Type.TyVar)a).sym().equals(((Type.TyVar)b).sym());
            }
            case ERROR_TY: {
                return false;
            }
        }
        throw new AssertionError((Object)a.tyKind());
    }

    private Type checkClassType(CompoundScope scope, Tree.ClassTy tree, boolean expectInterface) {
        boolean isInterface;
        Type type = this.bindClassTy(scope, tree);
        if (type.tyKind().equals((Object)Type.TyKind.ERROR_TY)) {
            return type;
        }
        HeaderBoundClass info = this.env.getNonNull(((Type.ClassTy)type).sym());
        switch (info.kind()) {
            case ANNOTATION: 
            case INTERFACE: {
                isInterface = true;
                break;
            }
            default: {
                isInterface = false;
            }
        }
        if (expectInterface != isInterface) {
            this.log.error(tree.position(), expectInterface ? TurbineError.ErrorKind.EXPECTED_INTERFACE : TurbineError.ErrorKind.UNEXPECTED_INTERFACE, new Object[0]);
        }
        return type;
    }

    private ImmutableList<TypeBoundClass.RecordComponentInfo> bindComponents(CompoundScope scope, ImmutableList<Tree.VarDecl> components) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Tree.VarDecl p : components) {
            int access = 0;
            for (TurbineModifier m : p.mods()) {
                access |= m.flag();
            }
            TypeBoundClass.RecordComponentInfo param = new TypeBoundClass.RecordComponentInfo(new RecordComponentSymbol(this.owner, p.name().value()), this.bindTy(scope, p.ty()), this.bindAnnotations(scope, p.annos()), access);
            result.add((Object)param);
        }
        return result.build();
    }

    ImmutableList<TypeBoundClass.MethodInfo> syntheticMethods(SyntheticMethods syntheticMethods) {
        switch (this.base.kind()) {
            case CLASS: {
                return this.maybeDefaultConstructor(syntheticMethods);
            }
            case ENUM: {
                return this.syntheticEnumMethods(syntheticMethods);
            }
        }
        return ImmutableList.of();
    }

    private ImmutableList<TypeBoundClass.MethodInfo> maybeDefaultConstructor(SyntheticMethods syntheticMethods) {
        if (this.hasConstructor()) {
            return ImmutableList.of();
        }
        MethodSymbol symbol = syntheticMethods.create(this.owner, "<init>");
        ImmutableList formals = TypeBinder.hasEnclosingInstance(this.base) ? ImmutableList.of((Object)this.enclosingInstanceParameter(symbol)) : ImmutableList.of();
        return ImmutableList.of((Object)this.syntheticConstructor(symbol, (ImmutableList<TypeBoundClass.ParamInfo>)formals, TurbineVisibility.fromAccess(this.base.access())));
    }

    private TypeBoundClass.MethodInfo syntheticConstructor(MethodSymbol symbol, ImmutableList<TypeBoundClass.ParamInfo> formals, TurbineVisibility visibility) {
        int access = visibility.flag();
        access |= this.base.access() & 0x800;
        if (!formals.isEmpty() && (((TypeBoundClass.ParamInfo)Iterables.getLast(formals)).access() & 0x80) == 128) {
            access |= 0x80;
        }
        return new TypeBoundClass.MethodInfo(symbol, (ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of(), Type.VOID, formals, (ImmutableList<Type>)ImmutableList.of(), access | 0x40000, null, null, (ImmutableList<AnnoInfo>)ImmutableList.of(), null);
    }

    private TypeBoundClass.ParamInfo enclosingInstanceParameter(MethodSymbol owner) {
        HeaderBoundClass info;
        int access = 16;
        access = (this.base.access() & 2) == 2 ? (access |= 0x1000) : (access |= 0x8000);
        int enclosingInstances = 0;
        ClassSymbol sym = this.base.owner();
        while (sym != null && ((info = this.env.getNonNull(sym)).access() & 8) != 8 && info.owner() != null) {
            ++enclosingInstances;
            sym = info.owner();
        }
        return new TypeBoundClass.ParamInfo(new ParamSymbol(owner, "this$" + enclosingInstances), Type.ClassTy.asNonParametricClassTy(this.base.owner()), (ImmutableList<AnnoInfo>)ImmutableList.of(), access);
    }

    private static ImmutableList<TypeBoundClass.ParamInfo> enumCtorParams(MethodSymbol owner) {
        return ImmutableList.of((Object)new TypeBoundClass.ParamInfo(new ParamSymbol(owner, "$enum$name"), Type.ClassTy.STRING, (ImmutableList<AnnoInfo>)ImmutableList.of(), 4096), (Object)new TypeBoundClass.ParamInfo(new ParamSymbol(owner, "$enum$ordinal"), Type.PrimTy.create(TurbineConstantTypeKind.INT, (ImmutableList<AnnoInfo>)ImmutableList.of()), (ImmutableList<AnnoInfo>)ImmutableList.of(), 4096));
    }

    private ImmutableList<TypeBoundClass.MethodInfo> syntheticEnumMethods(SyntheticMethods syntheticMethods) {
        ImmutableList.Builder methods = ImmutableList.builder();
        int access = 0;
        access |= this.base.access() & 0x800;
        if (!this.hasConstructor()) {
            MethodSymbol symbol = syntheticMethods.create(this.owner, "<init>");
            methods.add((Object)this.syntheticConstructor(symbol, TypeBinder.enumCtorParams(symbol), TurbineVisibility.PRIVATE));
        }
        MethodSymbol valuesMethod = syntheticMethods.create(this.owner, "values");
        methods.add((Object)new TypeBoundClass.MethodInfo(valuesMethod, (ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of(), Type.ArrayTy.create(Type.ClassTy.asNonParametricClassTy(this.owner), (ImmutableList<AnnoInfo>)ImmutableList.of()), (ImmutableList<TypeBoundClass.ParamInfo>)ImmutableList.of(), (ImmutableList<Type>)ImmutableList.of(), access | 1 | 8, null, null, (ImmutableList<AnnoInfo>)ImmutableList.of(), null));
        MethodSymbol valueOfMethod = syntheticMethods.create(this.owner, "valueOf");
        methods.add((Object)new TypeBoundClass.MethodInfo(valueOfMethod, (ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo>)ImmutableMap.of(), Type.ClassTy.asNonParametricClassTy(this.owner), (ImmutableList<TypeBoundClass.ParamInfo>)ImmutableList.of((Object)new TypeBoundClass.ParamInfo(new ParamSymbol(valueOfMethod, "name"), Type.ClassTy.STRING, (ImmutableList<AnnoInfo>)ImmutableList.of(), 32768)), (ImmutableList<Type>)ImmutableList.of(), access | 1 | 8, null, null, (ImmutableList<AnnoInfo>)ImmutableList.of(), null));
        return methods.build();
    }

    private boolean hasConstructor() {
        for (Tree m : this.base.decl().members()) {
            if (m.kind() != Tree.Kind.METH_DECL || !((Tree.MethDecl)m).name().value().equals("<init>")) continue;
            return true;
        }
        return false;
    }

    private ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> bindTyParams(ImmutableList<Tree.TyParam> trees, CompoundScope scope, Map<String, TyVarSymbol> symbols) {
        LinkedHashMap<TyVarSymbol, TypeBoundClass.TyVarInfo> result = new LinkedHashMap<TyVarSymbol, TypeBoundClass.TyVarInfo>();
        for (Tree.TyParam tree : trees) {
            TyVarSymbol sym = Objects.requireNonNull(symbols.get(tree.name().value()));
            ImmutableList.Builder bounds = ImmutableList.builder();
            for (Tree bound : tree.bounds()) {
                bounds.add((Object)this.bindTy(scope, bound));
            }
            ImmutableList<AnnoInfo> annotations = this.bindAnnotations(scope, tree.annos());
            TypeBoundClass.TyVarInfo existing = result.putIfAbsent(sym, new TypeBoundClass.TyVarInfo(Type.IntersectionTy.create((ImmutableList<Type>)bounds.build()), null, annotations));
            if (existing == null) continue;
            this.log.error(tree.position(), TurbineError.ErrorKind.DUPLICATE_DECLARATION, tree.name());
        }
        return ImmutableMap.copyOf(result);
    }

    private List<TypeBoundClass.MethodInfo> bindMethods(CompoundScope scope, ImmutableList<Tree> members, ImmutableList<TypeBoundClass.RecordComponentInfo> components) {
        ArrayList<TypeBoundClass.MethodInfo> methods = new ArrayList<TypeBoundClass.MethodInfo>();
        int idx = 0;
        for (Tree member : members) {
            if (member.kind() != Tree.Kind.METH_DECL) continue;
            methods.add(this.bindMethod(idx++, scope, (Tree.MethDecl)member, components));
        }
        return methods;
    }

    private TypeBoundClass.MethodInfo bindMethod(int idx, CompoundScope scope, Tree.MethDecl t, ImmutableList<TypeBoundClass.RecordComponentInfo> components) {
        MethodSymbol sym = new MethodSymbol(idx, this.owner, t.name().value());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Tree.TyParam pt : t.typarams()) {
            builder.put((Object)pt.name().value(), (Object)new TyVarSymbol(sym, pt.name().value()));
        }
        ImmutableMap typeParameters = builder.buildKeepingLast();
        scope = scope.append(new MapScope((ImmutableMap<String, ? extends Symbol>)typeParameters));
        ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes = this.bindTyParams(t.typarams(), scope, (Map<String, TyVarSymbol>)typeParameters);
        Type returnType = t.ret().isPresent() ? this.bindTy(scope, t.ret().get()) : Type.VOID;
        ImmutableList.Builder parameters = ImmutableList.builder();
        String name = t.name().value();
        if (name.equals("<init>")) {
            if (TypeBinder.hasEnclosingInstance(this.base)) {
                parameters.add((Object)this.enclosingInstanceParameter(sym));
            } else {
                switch (this.base.kind()) {
                    case ENUM: {
                        parameters.addAll(TypeBinder.enumCtorParams(sym));
                        break;
                    }
                    case RECORD: {
                        if (!t.mods().contains((Object)TurbineModifier.COMPACT_CTOR)) break;
                        for (Object component : components) {
                            parameters.add((Object)new TypeBoundClass.ParamInfo(new ParamSymbol(sym, ((TypeBoundClass.RecordComponentInfo)component).name()), ((TypeBoundClass.RecordComponentInfo)component).type(), ((TypeBoundClass.RecordComponentInfo)component).annotations(), ((TypeBoundClass.RecordComponentInfo)component).access()));
                        }
                        break;
                    }
                }
            }
        }
        TypeBoundClass.ParamInfo receiver = null;
        for (Tree.VarDecl p : t.params()) {
            int access = 0;
            for (TurbineModifier m : p.mods()) {
                access |= m.flag();
            }
            TypeBoundClass.ParamInfo param = new TypeBoundClass.ParamInfo(new ParamSymbol(sym, p.name().value()), this.bindTy(scope, p.ty()), this.bindAnnotations(scope, p.annos()), access);
            if (p.name().value().equals("this")) {
                receiver = param;
                continue;
            }
            parameters.add((Object)param);
        }
        ImmutableList.Builder exceptions = ImmutableList.builder();
        for (Tree.ClassTy p : t.exntys()) {
            exceptions.add((Object)this.bindClassTy(scope, p));
        }
        int access = 0;
        for (TurbineModifier m : t.mods()) {
            access |= m.flag();
        }
        switch (this.base.kind()) {
            case ANNOTATION: 
            case INTERFACE: {
                if ((access & 7) == 0) {
                    access |= 1;
                }
                if ((access & 0x11008) == 0) {
                    access |= 0x400;
                }
                if ((access & 0x10) != 16) break;
                this.log.error(t.position(), TurbineError.ErrorKind.UNEXPECTED_MODIFIER, new Object[]{TurbineModifier.FINAL});
                break;
            }
            case ENUM: {
                if (!name.equals("<init>")) break;
                access |= 2;
                break;
            }
        }
        if ((this.base.access() & 0x800) == 2048 && (access & 0x400) == 0) {
            access |= 0x800;
        }
        ImmutableList<AnnoInfo> annotations = this.bindAnnotations(scope, t.annos());
        return new TypeBoundClass.MethodInfo(sym, typeParameterTypes, returnType, (ImmutableList<TypeBoundClass.ParamInfo>)parameters.build(), (ImmutableList<Type>)exceptions.build(), access, null, t, annotations, receiver);
    }

    private static boolean hasEnclosingInstance(HeaderBoundClass base) {
        return base.kind() == TurbineTyKind.CLASS && base.owner() != null && (base.access() & 8) == 0;
    }

    private ImmutableList<TypeBoundClass.FieldInfo> bindFields(CompoundScope scope, ImmutableList<Tree> members) {
        HashSet<FieldSymbol> seen = new HashSet<FieldSymbol>();
        ImmutableList.Builder fields = ImmutableList.builder();
        for (Tree member : members) {
            if (member.kind() != Tree.Kind.VAR_DECL) continue;
            TypeBoundClass.FieldInfo field = this.bindField(scope, (Tree.VarDecl)member);
            if (!seen.add(field.sym())) {
                this.log.error(member.position(), TurbineError.ErrorKind.DUPLICATE_DECLARATION, "field: " + field.name());
                continue;
            }
            fields.add((Object)field);
        }
        return fields.build();
    }

    private TypeBoundClass.FieldInfo bindField(CompoundScope scope, Tree.VarDecl decl) {
        FieldSymbol sym = new FieldSymbol(this.owner, decl.name().value());
        Type type = this.bindTy(scope, decl.ty());
        ImmutableList<AnnoInfo> annotations = this.bindAnnotations(scope, decl.annos());
        int access = 0;
        for (TurbineModifier m : decl.mods()) {
            access |= m.flag();
        }
        switch (this.base.kind()) {
            case ANNOTATION: 
            case INTERFACE: {
                access |= 0x19;
                break;
            }
        }
        return new TypeBoundClass.FieldInfo(sym, type, access, annotations, decl, null);
    }

    private ImmutableList<AnnoInfo> bindAnnotations(CompoundScope scope, ImmutableList<Tree.Anno> trees) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Tree.Anno tree : trees) {
            ImmutableList<Tree.Ident> name = tree.name();
            LookupResult lookupResult = scope.lookup(new LookupKey(name));
            ClassSymbol sym = this.resolveAnnoSymbol(tree, name, lookupResult);
            result.add((Object)new AnnoInfo(this.base.source(), sym, tree, (ImmutableMap<String, Const>)ImmutableMap.of()));
        }
        return result.build();
    }

    private @Nullable ClassSymbol resolveAnnoSymbol(Tree.Anno tree, ImmutableList<Tree.Ident> name, @Nullable LookupResult lookupResult) {
        if (lookupResult == null) {
            this.log.error(tree.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, Joiner.on((char)'.').join(name));
            return null;
        }
        ClassSymbol sym = (ClassSymbol)lookupResult.sym();
        for (Tree.Ident ident : lookupResult.remaining()) {
            if ((sym = this.resolveNext(sym, ident)) != null) continue;
            return null;
        }
        if (this.env.getNonNull(sym).kind() != TurbineTyKind.ANNOTATION) {
            this.log.error(tree.position(), TurbineError.ErrorKind.NOT_AN_ANNOTATION, sym);
        }
        return sym;
    }

    private @Nullable ClassSymbol resolveNext(ClassSymbol sym, Tree.Ident bit) {
        ClassSymbol next = Resolve.resolve(this.env, this.owner, sym, bit);
        if (next == null) {
            this.log.error(bit.position(), TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(sym.binaryName() + '$' + bit));
        }
        return next;
    }

    private ImmutableList<Type> bindTyArgs(CompoundScope scope, ImmutableList<Tree.Type> targs) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (Tree.Type ty : targs) {
            result.add((Object)this.bindTyArg(scope, ty));
        }
        return result.build();
    }

    private Type bindTyArg(CompoundScope scope, Tree.Type ty) {
        switch (ty.kind()) {
            case WILD_TY: {
                return this.bindWildTy(scope, (Tree.WildTy)ty);
            }
        }
        Type result = this.bindTy(scope, ty);
        if (result.tyKind().equals((Object)Type.TyKind.PRIM_TY)) {
            this.log.error(ty.position(), TurbineError.ErrorKind.UNEXPECTED_TYPE, Deannotate.deannotate(result));
        }
        return result;
    }

    private Type bindTy(CompoundScope scope, Tree t) {
        switch (t.kind()) {
            case CLASS_TY: {
                return this.bindClassTy(scope, (Tree.ClassTy)t);
            }
            case PRIM_TY: {
                return this.bindPrimTy(scope, (Tree.PrimTy)t);
            }
            case ARR_TY: {
                return this.bindArrTy(scope, (Tree.ArrTy)t);
            }
            case VOID_TY: {
                return Type.VOID;
            }
        }
        throw new AssertionError((Object)t.kind());
    }

    private Type bindClassTy(CompoundScope scope, Tree.ClassTy t) {
        ArrayDeque<Tree.ClassTy> builder = new ArrayDeque<Tree.ClassTy>();
        Object curr = t;
        while (curr != null) {
            builder.addFirst((Tree.ClassTy)curr);
            curr = ((Tree.ClassTy)curr).base().orElse(null);
        }
        ArrayList<Tree.ClassTy> flat = new ArrayList<Tree.ClassTy>(builder);
        ImmutableList.Builder nameBuilder = ImmutableList.builder();
        for (Tree.ClassTy curr2 : flat) {
            nameBuilder.add((Object)curr2.name());
        }
        ImmutableList names = nameBuilder.build();
        LookupResult result = scope.lookup(new LookupKey((ImmutableList<Tree.Ident>)names));
        if (result == null || result.sym() == null) {
            this.log.error(((Tree.Ident)names.get(0)).position(), TurbineError.ErrorKind.CANNOT_RESOLVE, Joiner.on((char)'.').join((Iterable)names));
            return Type.ErrorTy.create((Iterable<Tree.Ident>)names);
        }
        Symbol sym = result.sym();
        int annoIdx = flat.size() - result.remaining().size() - 1;
        ImmutableList<AnnoInfo> annos = this.bindAnnotations(scope, ((Tree.ClassTy)flat.get(annoIdx)).annos());
        switch (sym.symKind()) {
            case CLASS: {
                return this.bindClassTyRest(scope, flat, (ImmutableList<Tree.Ident>)names, result, (ClassSymbol)sym, annos);
            }
            case TY_PARAM: {
                if (!result.remaining().isEmpty()) {
                    this.log.error(t.position(), TurbineError.ErrorKind.TYPE_PARAMETER_QUALIFIER, new Object[0]);
                    return Type.ErrorTy.create((Iterable<Tree.Ident>)names);
                }
                return Type.TyVar.create((TyVarSymbol)sym, annos);
            }
        }
        throw new AssertionError((Object)sym.symKind());
    }

    private Type bindClassTyRest(CompoundScope scope, ArrayList<Tree.ClassTy> flat, ImmutableList<Tree.Ident> bits, LookupResult result, ClassSymbol sym, ImmutableList<AnnoInfo> annotations) {
        int idx = bits.size() - result.remaining().size() - 1;
        ImmutableList.Builder classes = ImmutableList.builder();
        classes.add((Object)Type.ClassTy.SimpleClassTy.create(sym, this.bindTyArgs(scope, flat.get(idx++).tyargs()), annotations));
        while (idx < flat.size()) {
            Tree.ClassTy curr = flat.get(idx);
            ClassSymbol next = this.resolveNext(sym, curr.name());
            if (next == null) {
                return Type.ErrorTy.create(bits);
            }
            sym = next;
            annotations = this.bindAnnotations(scope, curr.annos());
            classes.add((Object)Type.ClassTy.SimpleClassTy.create(sym, this.bindTyArgs(scope, curr.tyargs()), annotations));
            ++idx;
        }
        return Type.ClassTy.create((Iterable<Type.ClassTy.SimpleClassTy>)classes.build());
    }

    private Type.PrimTy bindPrimTy(CompoundScope scope, Tree.PrimTy t) {
        return Type.PrimTy.create(t.tykind(), this.bindAnnotations(scope, t.annos()));
    }

    private Type bindArrTy(CompoundScope scope, Tree.ArrTy t) {
        return Type.ArrayTy.create(this.bindTy(scope, t.elem()), this.bindAnnotations(scope, t.annos()));
    }

    private Type bindWildTy(CompoundScope scope, Tree.WildTy t) {
        ImmutableList<AnnoInfo> annotations = this.bindAnnotations(scope, t.annos());
        if (t.lower().isPresent()) {
            return Type.WildLowerBoundedTy.create(this.bindTy(scope, t.lower().get()), annotations);
        }
        if (t.upper().isPresent()) {
            return Type.WildUpperBoundedTy.create(this.bindTy(scope, t.upper().get()), annotations);
        }
        return Type.WildUnboundedTy.create(annotations);
    }

    private static class SyntheticMethods {
        private int idx = -1;

        private SyntheticMethods() {
        }

        MethodSymbol create(ClassSymbol owner, String name) {
            return new MethodSymbol(this.idx--, owner, name);
        }
    }

    private static class ClassMemberScope
    implements Scope {
        private final ClassSymbol sym;
        private final Env<ClassSymbol, HeaderBoundClass> env;

        public ClassMemberScope(ClassSymbol sym, Env<ClassSymbol, HeaderBoundClass> env) {
            this.sym = sym;
            this.env = env;
        }

        @Override
        public @Nullable LookupResult lookup(LookupKey lookup) {
            ClassSymbol curr = this.sym;
            while (curr != null) {
                Symbol result = Resolve.resolve(this.env, this.sym, curr, lookup.first());
                if (result != null) {
                    return new LookupResult(result, lookup);
                }
                HeaderBoundClass info = this.env.getNonNull(curr);
                result = (Symbol)info.typeParameters().get((Object)lookup.first().value());
                if (result != null) {
                    return new LookupResult(result, lookup);
                }
                curr = info.owner();
            }
            return null;
        }
    }

    private static class MapScope
    implements Scope {
        private final ImmutableMap<String, ? extends Symbol> tps;

        public MapScope(ImmutableMap<String, ? extends Symbol> tps) {
            this.tps = tps;
        }

        @Override
        public @Nullable LookupResult lookup(LookupKey lookupKey) {
            Symbol sym = (Symbol)this.tps.get((Object)lookupKey.first().value());
            return sym != null ? new LookupResult(sym, lookupKey) : null;
        }
    }

    private static class SingletonScope
    implements Scope {
        private final String name;
        private final Symbol sym;

        public SingletonScope(String name, Symbol sym) {
            this.name = name;
            this.sym = sym;
        }

        @Override
        public @Nullable LookupResult lookup(LookupKey lookup) {
            if (this.name.equals(lookup.first().value())) {
                return new LookupResult(this.sym, lookup);
            }
            return null;
        }
    }
}

