/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject.guice;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;

@BugPattern(summary="This method is not annotated with @Inject, but it overrides a method that is annotated with @com.google.inject.Inject. Guice will inject this method, and it is recommended to annotate it explicitly.", severity=BugPattern.SeverityLevel.WARNING)
public class OverridesGuiceInjectableMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (!InjectMatchers.hasInjectAnnotation().matches((Tree)methodTree, state)) {
            Symbol.MethodSymbol method = ASTHelpers.getSymbol((MethodTree)methodTree);
            for (Symbol.MethodSymbol superMethod : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)method, (Types)state.getTypes())) {
                if (!ASTHelpers.hasAnnotation((Symbol)superMethod, (String)"com.google.inject.Inject", (VisitorState)state)) continue;
                return this.buildDescription(methodTree).addFix((Fix)SuggestedFix.builder().addImport("javax.inject.Inject").prefixWith((Tree)methodTree, "@Inject\n").build()).setMessage(String.format("This method is not annotated with @Inject, but overrides the method in %s that is annotated with @com.google.inject.Inject. Guice will inject this method, and it is recommended to annotate it explicitly.", ASTHelpers.enclosingClass((Symbol)superMethod).getQualifiedName())).build();
            }
        }
        return Description.NO_MATCH;
    }
}

