/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.AnnotationInfo;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByUtils;
import com.google.errorprone.bugpatterns.threadsafety.ThreadSafety;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownMutability;
import com.google.errorprone.bugpatterns.threadsafety.WellKnownThreadSafety;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;

public class ThreadSafeAnalysis {
    private final BugChecker bugChecker;
    private final VisitorState state;
    private final WellKnownThreadSafety wellKnownThreadSafety;
    private final ThreadSafety threadSafety;

    public ThreadSafeAnalysis(BugChecker bugChecker, VisitorState state, WellKnownThreadSafety wellKnownThreadSafety) {
        this.bugChecker = bugChecker;
        this.state = state;
        this.wellKnownThreadSafety = wellKnownThreadSafety;
        this.threadSafety = ThreadSafety.threadSafeBuilder(wellKnownThreadSafety).build(state);
    }

    boolean hasThreadSafeTypeParameterAnnotation(Symbol.TypeVariableSymbol sym) {
        return this.threadSafety.hasThreadSafeTypeParameterAnnotation(sym);
    }

    boolean hasThreadSafeElementAnnotation(Symbol.TypeVariableSymbol sym) {
        return this.threadSafety.hasThreadSafeElementAnnotation(sym);
    }

    ThreadSafety.Violation checkInstantiation(Collection<Symbol.TypeVariableSymbol> classTypeParameters, Collection<Type> typeArguments) {
        return this.threadSafety.checkInstantiation(classTypeParameters, typeArguments);
    }

    public ThreadSafety.Violation checkInvocation(Type methodType, Symbol symbol) {
        return this.threadSafety.checkInvocation(methodType, symbol);
    }

    public ThreadSafety.Violation checkForThreadSafety(Optional<ClassTree> tree, ImmutableSet<String> threadSafeTypeParams, Type.ClassType type) {
        ThreadSafety.Violation info = this.areFieldsThreadSafe(tree, threadSafeTypeParams, type);
        if (info.isPresent()) {
            return info;
        }
        for (Type interfaceType : this.state.getTypes().interfaces(type)) {
            ThreadSafety.Violation interfaceInfo;
            AnnotationInfo interfaceAnnotation = this.threadSafety.getMarkerOrAcceptedAnnotation(interfaceType.tsym, this.state);
            if (interfaceAnnotation == null || !(interfaceInfo = this.threadSafety.checkSuperInstantiation((Set<String>)threadSafeTypeParams, interfaceAnnotation, interfaceType)).isPresent()) continue;
            return interfaceInfo.plus(String.format("'%s' extends '%s'", this.threadSafety.getPrettyName(type.tsym), this.threadSafety.getPrettyName(interfaceType.tsym)));
        }
        ThreadSafety.Violation superInfo = this.checkSuper(threadSafeTypeParams, type);
        if (superInfo.isPresent()) {
            return superInfo;
        }
        Type mutableEnclosing = this.threadSafety.mutableEnclosingInstance(tree, type);
        if (mutableEnclosing != null) {
            return ThreadSafety.Violation.of(String.format("'%s' has non-thread-safe enclosing instance '%s'", this.threadSafety.getPrettyName(type.tsym), mutableEnclosing));
        }
        return ThreadSafety.Violation.absent();
    }

    private ThreadSafety.Violation checkSuper(ImmutableSet<String> threadSafeTypeParams, Type.ClassType type) {
        Type.ClassType superType = (Type.ClassType)this.state.getTypes().supertype(type);
        if (superType.getKind() == TypeKind.NONE || this.state.getTypes().isSameType(this.state.getSymtab().objectType, superType)) {
            return ThreadSafety.Violation.absent();
        }
        if (WellKnownMutability.isAnnotation(this.state, type)) {
            return ThreadSafety.Violation.absent();
        }
        AnnotationInfo superannotation = this.threadSafety.getMarkerOrAcceptedAnnotation(superType.tsym, this.state);
        if (superannotation != null) {
            ThreadSafety.Violation info = this.threadSafety.checkSuperInstantiation((Set<String>)threadSafeTypeParams, superannotation, superType);
            if (!info.isPresent()) {
                return ThreadSafety.Violation.absent();
            }
            return info.plus(String.format("'%s' extends '%s'", this.threadSafety.getPrettyName(type.tsym), this.threadSafety.getPrettyName(superType.tsym)));
        }
        ThreadSafety.Violation info = this.checkForThreadSafety(Optional.empty(), threadSafeTypeParams, superType);
        if (!info.isPresent()) {
            return ThreadSafety.Violation.absent();
        }
        return info.plus(String.format("'%s' extends '%s'", this.threadSafety.getPrettyName(type.tsym), this.threadSafety.getPrettyName(superType.tsym)));
    }

    ThreadSafety.Violation areFieldsThreadSafe(Optional<ClassTree> tree, ImmutableSet<String> threadSafeTypeParams, Type.ClassType classType) {
        Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)classType.tsym;
        if (classSym.members() == null) {
            return ThreadSafety.Violation.absent();
        }
        Predicate<Symbol> instanceFieldFilter = symbol -> symbol.getKind() == ElementKind.FIELD;
        HashMap<Symbol, Tree> declarations = new HashMap<Symbol, Tree>();
        if (tree.isPresent()) {
            for (Tree tree2 : tree.get().getMembers()) {
                Symbol sym = ASTHelpers.getSymbol((Tree)tree2);
                if (sym == null) continue;
                declarations.put(sym, tree2);
            }
        }
        ImmutableList members = ImmutableList.copyOf((Iterable)ASTHelpers.scope((Scope)classSym.members()).getSymbols(instanceFieldFilter)).reverse();
        for (Symbol member : members) {
            Optional<Tree> memberTree = Optional.ofNullable((Tree)declarations.get(member));
            ThreadSafety.Violation info = this.isFieldThreadSafe(memberTree, (Set<String>)threadSafeTypeParams, classSym, classType, (Symbol.VarSymbol)member);
            if (!info.isPresent()) continue;
            return info;
        }
        return ThreadSafety.Violation.absent();
    }

    private ThreadSafety.Violation isFieldThreadSafe(Optional<Tree> tree, Set<String> threadSafeTypeParams, Symbol.ClassSymbol classSym, Type.ClassType classType, Symbol.VarSymbol var) {
        if (this.bugChecker.isSuppressed((Symbol)var) || this.bugChecker.customSuppressionAnnotations().stream().map(a -> ASTHelpers.hasAnnotation((Symbol)var, (Class)a, (VisitorState)this.state)).anyMatch(v -> v)) {
            return ThreadSafety.Violation.absent();
        }
        if (var.getModifiers().contains((Object)Modifier.STATIC)) {
            return ThreadSafety.Violation.absent();
        }
        if (!GuardedByUtils.getGuardValues(var).isEmpty()) {
            return ThreadSafety.Violation.absent();
        }
        if (!var.getModifiers().contains((Object)Modifier.FINAL) && !ASTHelpers.hasAnnotation((Symbol)var, LazyInit.class, (VisitorState)this.state)) {
            return this.processModifier(tree, classSym, var, Modifier.FINAL, "'%s' has non-final field '%s'");
        }
        Type varType = this.state.getTypes().memberType(classType, var);
        ThreadSafety.Violation info = this.threadSafety.isThreadSafeType(true, threadSafeTypeParams, varType);
        if (info.isPresent()) {
            if (tree.isPresent()) {
                this.state.reportMatch(this.bugChecker.buildDescription(tree.get()).setMessage(info.plus("@ThreadSafe class has non-thread-safe field").message()).build());
                return ThreadSafety.Violation.absent();
            }
            return info.plus(String.format("'%s' has field '%s' of type '%s'", this.threadSafety.getPrettyName(classSym), var.getSimpleName(), varType));
        }
        return ThreadSafety.Violation.absent();
    }

    private ThreadSafety.Violation processModifier(Optional<Tree> tree, Symbol.ClassSymbol classSym, Symbol.VarSymbol var, Modifier modifier, String message) {
        if (tree.isPresent()) {
            this.state.reportMatch(this.bugChecker.buildDescription(tree.get()).setMessage("@ThreadSafe class fields should be final or annotated with @GuardedBy. See https://errorprone.info/bugpattern/ThreadSafe for details.").addFix(SuggestedFixes.addModifiers((Tree)tree.get(), (VisitorState)this.state, (Modifier[])new Modifier[]{modifier})).build());
            return ThreadSafety.Violation.absent();
        }
        return ThreadSafety.Violation.of(String.format(message, this.threadSafety.getPrettyName(classSym), var.getSimpleName()));
    }

    AnnotationInfo getThreadSafeAnnotation(Tree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol((Tree)tree);
        return this.getThreadSafeAnnotation(sym, state);
    }

    AnnotationInfo getThreadSafeAnnotation(Symbol sym, VisitorState state) {
        String nameStr = sym.flatName().toString();
        AnnotationInfo known = (AnnotationInfo)this.wellKnownThreadSafety.getKnownThreadSafeClasses().get((Object)nameStr);
        if (known != null) {
            return known;
        }
        return this.threadSafety.getInheritedAnnotation(sym, state);
    }

    public ImmutableSet<String> threadSafeTypeParametersInScope(Symbol sym) {
        return ImmutableSet.copyOf(this.threadSafety.threadSafeTypeParametersInScope(sym));
    }
}

