/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import com.google.turbine.options.AutoValue_LanguageVersion;
import java.util.OptionalInt;
import javax.lang.model.SourceVersion;

@AutoValue
public abstract class LanguageVersion {
    private static final int DEFAULT = 8;

    public abstract int source();

    public abstract int target();

    public abstract OptionalInt release();

    public int majorVersion() {
        return this.target() + 44;
    }

    public SourceVersion sourceVersion() {
        try {
            return SourceVersion.valueOf("RELEASE_" + this.source());
        }
        catch (IllegalArgumentException unused) {
            return SourceVersion.latestSupported();
        }
    }

    private static LanguageVersion create(int source, int target, OptionalInt release) {
        return new AutoValue_LanguageVersion(source, target, release);
    }

    public static LanguageVersion createDefault() {
        return LanguageVersion.create(8, 8, OptionalInt.empty());
    }

    public static LanguageVersion fromJavacopts(ImmutableList<String> javacopts) {
        int sourceVersion = 8;
        int targetVersion = 8;
        OptionalInt release = OptionalInt.empty();
        UnmodifiableIterator it = javacopts.iterator();
        while (it.hasNext()) {
            String option;
            switch (option = (String)it.next()) {
                case "-source": 
                case "--source": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(option + " requires an argument");
                    }
                    sourceVersion = LanguageVersion.parseVersion((String)it.next());
                    release = OptionalInt.empty();
                    break;
                }
                case "-target": 
                case "--target": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(option + " requires an argument");
                    }
                    targetVersion = LanguageVersion.parseVersion((String)it.next());
                    release = OptionalInt.empty();
                    break;
                }
                case "--release": {
                    if (!it.hasNext()) {
                        throw new IllegalArgumentException(option + " requires an argument");
                    }
                    String value = (String)it.next();
                    Integer n = Ints.tryParse((String)value);
                    if (n == null) {
                        throw new IllegalArgumentException("invalid --release version: " + value);
                    }
                    release = OptionalInt.of(n);
                    sourceVersion = n;
                    targetVersion = n;
                    break;
                }
            }
        }
        return LanguageVersion.create(sourceVersion, targetVersion, release);
    }

    private static int parseVersion(String value) {
        boolean hasPrefix = value.startsWith("1.");
        Integer version = Ints.tryParse((String)(hasPrefix ? value.substring("1.".length()) : value));
        if (version == null || !LanguageVersion.isValidVersion(version, hasPrefix)) {
            throw new IllegalArgumentException("invalid -source version: " + value);
        }
        return version;
    }

    private static boolean isValidVersion(int version, boolean hasPrefix) {
        if (version < 5) {
            return false;
        }
        return !hasPrefix || version <= 10;
    }
}

