/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@BugPattern(name="ProtectedMembersInFinalClass", summary="Protected members in final classes can be package-private", severity=BugPattern.SeverityLevel.WARNING)
public class ProtectedMembersInFinalClass
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> HAS_FINAL = Matchers.hasModifier((Modifier)Modifier.FINAL);
    private static final Matcher<Tree> HAS_PROTECTED = Matchers.hasModifier((Modifier)Modifier.PROTECTED);

    private static boolean methodHasNoParentMethod(MethodTree methodTree, VisitorState state) {
        return ASTHelpers.findSuperMethods((Symbol.MethodSymbol)ASTHelpers.getSymbol((MethodTree)methodTree), (Types)state.getTypes()).isEmpty();
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (!HAS_FINAL.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ImmutableList relevantMembers = (ImmutableList)tree.getMembers().stream().filter(m -> m instanceof MethodTree || m instanceof VariableTree).filter(m -> HAS_PROTECTED.matches(m, state)).filter(m -> !(m instanceof MethodTree) || ProtectedMembersInFinalClass.methodHasNoParentMethod((MethodTree)m, state)).filter(m -> !this.isSuppressed((Tree)m)).collect(ImmutableList.toImmutableList());
        if (relevantMembers.isEmpty()) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        relevantMembers.forEach(m -> SuggestedFixes.removeModifiers((Tree)m, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PROTECTED}).ifPresent(arg_0 -> ((SuggestedFix.Builder)fix).merge(arg_0)));
        if (fix.isEmpty()) {
            return Description.NO_MATCH;
        }
        String message = String.format("Make members of final classes package-private: %s", relevantMembers.stream().map(m -> {
            Symbol symbol = ASTHelpers.getSymbol((Tree)m);
            return symbol.isConstructor() ? symbol.owner.name.toString() : symbol.name.toString();
        }).collect(Collectors.joining(", ")));
        return this.buildDescription((Tree)relevantMembers.get(0)).setMessage(message).addFix((Fix)fix.build()).build();
    }
}

