/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Streams;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class MoreAnnotations {
    public static Stream<Attribute.Compound> getDeclarationAndTypeAttributes(Symbol sym) {
        Symbol typeAnnotationOwner;
        switch (sym.getKind()) {
            case PARAMETER: {
                typeAnnotationOwner = sym.owner;
                break;
            }
            default: {
                typeAnnotationOwner = sym;
            }
        }
        return Streams.concat((Stream[])new Stream[]{sym.getRawAttributes().stream(), typeAnnotationOwner.getRawTypeAttributes().stream().filter(anno -> MoreAnnotations.isAnnotationOnType(sym, anno.position))}).collect(Collectors.groupingBy(c -> c.type.asElement().getQualifiedName(), LinkedHashMap::new, Collectors.toList())).values().stream().map(c -> (Attribute.Compound)c.get(0));
    }

    private static boolean isAnnotationOnType(Symbol sym, TypeAnnotationPosition position) {
        if (!position.location.isEmpty()) {
            return false;
        }
        switch (sym.getKind()) {
            case LOCAL_VARIABLE: {
                return position.type == TargetType.LOCAL_VARIABLE;
            }
            case FIELD: {
                return position.type == TargetType.FIELD;
            }
            case CONSTRUCTOR: 
            case METHOD: {
                return position.type == TargetType.METHOD_RETURN;
            }
            case PARAMETER: {
                switch (position.type) {
                    case METHOD_FORMAL_PARAMETER: {
                        return ((List)((Symbol.MethodSymbol)sym.owner).getParameters()).indexOf(sym) == position.parameter_index;
                    }
                }
                return false;
            }
            case CLASS: {
                return false;
            }
        }
        throw new AssertionError((Object)("unsupported element kind in MoreAnnotation#isAnnotationOnType: " + sym.getKind()));
    }

    public static Optional<Attribute> getValue(Attribute.Compound attribute, String name) {
        return attribute.getElementValues().entrySet().stream().filter(e -> ((Name)((Symbol.MethodSymbol)e.getKey()).getSimpleName()).contentEquals(name)).map(Map.Entry::getValue).findFirst();
    }

    public static Optional<AnnotationValue> getAnnotationValue(Attribute.Compound attribute, String name) {
        return MoreAnnotations.getValue(attribute, name).map(a -> a);
    }

    public static Optional<Integer> asIntegerValue(AnnotationValue a) {
        class Visitor
        extends SimpleAnnotationValueVisitor8<Integer, Void> {
            Visitor() {
            }

            @Override
            public Integer visitInt(int i, Void unused) {
                return i;
            }
        }
        return Optional.ofNullable(a.accept(new Visitor(), null));
    }

    public static Optional<String> asStringValue(AnnotationValue a) {
        class Visitor
        extends SimpleAnnotationValueVisitor8<String, Void> {
            Visitor() {
            }

            @Override
            public String visitString(String s, Void unused) {
                return s;
            }
        }
        return Optional.ofNullable(a.accept(new Visitor(), null));
    }

    public static <T extends Enum<T>> Optional<T> asEnumValue(Class<T> clazz, AnnotationValue a) {
        class Visitor
        extends SimpleAnnotationValueVisitor8<T, Void> {
            final /* synthetic */ Class val$clazz;

            Visitor(Class clazz) {
                this.val$clazz = clazz;
            }

            @Override
            public T visitEnumConstant(VariableElement c, Void unused) {
                return Enum.valueOf(this.val$clazz, c.getSimpleName().toString());
            }
        }
        return Optional.ofNullable((Enum)a.accept(new Visitor(clazz), null));
    }

    public static Optional<TypeMirror> asTypeValue(AnnotationValue a) {
        class Visitor
        extends SimpleAnnotationValueVisitor8<TypeMirror, Void> {
            Visitor() {
            }

            @Override
            public TypeMirror visitType(TypeMirror t, Void unused) {
                return t;
            }
        }
        return Optional.ofNullable(a.accept(new Visitor(), null));
    }

    public static Stream<String> asStrings(AnnotationValue v) {
        return (Stream)MoreObjects.firstNonNull(v.accept(new SimpleAnnotationValueVisitor8<Stream<String>, Void>(){

            @Override
            public Stream<String> visitString(String s, Void unused) {
                return Stream.of(s);
            }

            @Override
            public Stream<String> visitArray(java.util.List<? extends AnnotationValue> list, Void unused) {
                return list.stream().flatMap(a -> a.accept(this, null)).filter(x -> x != null);
            }
        }, null), Stream.empty());
    }

    public static Stream<TypeMirror> asTypes(AnnotationValue v) {
        return MoreAnnotations.asArray(v, MoreAnnotations::asTypeValue);
    }

    private static <T> Stream<T> asArray(AnnotationValue v, Function<AnnotationValue, Optional<T>> mapper) {
        class Visitor
        extends SimpleAnnotationValueVisitor8<Stream<T>, Void> {
            final /* synthetic */ Function val$mapper;

            Visitor(Function function) {
                this.val$mapper = function;
            }

            @Override
            public Stream<T> visitArray(java.util.List<? extends AnnotationValue> vals, Void unused) {
                return vals.stream().map(this.val$mapper).flatMap(Streams::stream);
            }
        }
        return (Stream)MoreObjects.firstNonNull((Object)((Stream)v.accept(new Visitor(mapper), null)), Stream.of(new Object[0]));
    }

    private MoreAnnotations() {
    }
}

