/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Type;
import java.util.List;
import java.util.Objects;

@BugPattern(name="ThreadJoinLoop", summary="Thread.join needs to be surrounded by a loop until it succeeds, as in Uninterruptibles.joinUninterruptibly.", explanation="Thread.join() can be interrupted, and so requires users to catch InterruptedException. Most users should be looping until the join() actually succeeds.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class ThreadJoinLoop
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final MethodMatchers.MethodNameMatcher MATCH_THREAD_JOIN = Matchers.instanceMethod().onDescendantOf("java.lang.Thread").named("join");

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState visitorState) {
        String threadString = methodInvocationTree.getMethodSelect() instanceof MemberSelectTree ? ((MemberSelectTree)methodInvocationTree.getMethodSelect()).getExpression().toString() : "this";
        if (!methodInvocationTree.getArguments().isEmpty()) {
            return Description.NO_MATCH;
        }
        if (MATCH_THREAD_JOIN.matches((Tree)methodInvocationTree, visitorState)) {
            StatementTree statements;
            TreePath treePath = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)visitorState.getPath(), TryTree.class);
            if (treePath == null) {
                return Description.NO_MATCH;
            }
            TreePath pathToLoop = ASTHelpers.findPathFromEnclosingNodeToTopLevel((TreePath)treePath, WhileLoopTree.class);
            boolean hasWhileLoopOneStatement = false;
            if (pathToLoop != null && (statements = ((WhileLoopTree)pathToLoop.getLeaf()).getStatement()) instanceof BlockTree && ((BlockTree)statements).getStatements().size() == 1) {
                hasWhileLoopOneStatement = true;
            }
            Type interruptedType = visitorState.getSymtab().interruptedExceptionType;
            Type exceptionType = visitorState.getSymtab().exceptionType;
            TryTree tryTree = (TryTree)treePath.getLeaf();
            TreeScannerMethodInvocations treeScanner = new TreeScannerMethodInvocations();
            treeScanner.scan(tryTree.getBlock(), methodInvocationTree.toString());
            if (treeScanner.count > 0) {
                return Description.NO_MATCH;
            }
            if (tryTree.getFinallyBlock() != null) {
                return Description.NO_MATCH;
            }
            List<? extends CatchTree> catches = tryTree.getCatches();
            for (CatchTree catchTree : catches) {
                List<? extends StatementTree> statementTrees;
                Type typeSym = ASTHelpers.getType((Tree)catchTree.getParameter().getType());
                if (!Objects.equals(interruptedType, typeSym) && !Objects.equals(exceptionType, typeSym) || !(statementTrees = catchTree.getBlock().getStatements()).isEmpty() && (statementTrees.size() != 1 || !statementTrees.get(0).toString().equals(";"))) continue;
                SuggestedFix.Builder builder = SuggestedFix.builder();
                builder.replace(hasWhileLoopOneStatement ? pathToLoop.getLeaf() : tryTree, "Uninterruptibles.joinUninterruptibly(" + threadString + ");");
                builder.addImport("com.google.common.util.concurrent.Uninterruptibles");
                return this.describeMatch(methodInvocationTree, (Fix)builder.build());
            }
        }
        return Description.NO_MATCH;
    }

    private static class TreeScannerMethodInvocations
    extends TreeScanner<Void, String> {
        private int count = 0;

        private TreeScannerMethodInvocations() {
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree tree, String methodString) {
            if (!tree.toString().contains(methodString)) {
                ++this.count;
            }
            return null;
        }

        @Override
        public Void visitAssignment(AssignmentTree tree, String methodString) {
            if (ASTHelpers.getType((Tree)tree.getVariable()).toString().equals("java.lang.Thread")) {
                ++this.count;
            }
            return null;
        }
    }
}

