/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.common;

import com.google.auto.common.MoreElements;
import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.lang.model.util.SimpleTypeVisitor6;
import javax.lang.model.util.Types;

public final class MoreTypes {
    private static final Equivalence<TypeMirror> TYPE_EQUIVALENCE = new Equivalence<TypeMirror>(){

        protected boolean doEquivalent(TypeMirror a, TypeMirror b) {
            return MoreTypes.equal(a, b, (Set)ImmutableSet.of());
        }

        protected int doHash(TypeMirror t) {
            return MoreTypes.hash(t, (Set)ImmutableSet.of());
        }
    };
    private static final TypeVisitor<Boolean, EqualVisitorParam> EQUAL_VISITOR = new SimpleTypeVisitor6<Boolean, EqualVisitorParam>(){

        @Override
        protected Boolean defaultAction(TypeMirror a, EqualVisitorParam p) {
            return a.getKind().equals((Object)p.type.getKind());
        }

        @Override
        public Boolean visitArray(ArrayType a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.ARRAY)) {
                ArrayType b = (ArrayType)p.type;
                return MoreTypes.equal(a.getComponentType(), b.getComponentType(), p.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitDeclared(DeclaredType a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.DECLARED)) {
                Element bElement;
                DeclaredType b = (DeclaredType)p.type;
                Element aElement = a.asElement();
                ComparedElements comparedElements = new ComparedElements(aElement, bElement = b.asElement());
                if (p.visiting.contains(comparedElements)) {
                    return true;
                }
                HashSet<ComparedElements> newVisiting = new HashSet<ComparedElements>(p.visiting);
                newVisiting.add(comparedElements);
                return aElement.equals(bElement) && MoreTypes.equal(a.getEnclosingType(), a.getEnclosingType(), newVisiting) && MoreTypes.equalLists(a.getTypeArguments(), b.getTypeArguments(), newVisiting);
            }
            return false;
        }

        @Override
        public Boolean visitError(ErrorType a, EqualVisitorParam p) {
            return a.equals(p.type);
        }

        @Override
        public Boolean visitExecutable(ExecutableType a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.EXECUTABLE)) {
                ExecutableType b = (ExecutableType)p.type;
                return MoreTypes.equalLists(a.getParameterTypes(), b.getParameterTypes(), p.visiting) && MoreTypes.equal(a.getReturnType(), b.getReturnType(), p.visiting) && MoreTypes.equalLists(a.getThrownTypes(), b.getThrownTypes(), p.visiting) && MoreTypes.equalLists(a.getTypeVariables(), b.getTypeVariables(), p.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitTypeVariable(TypeVariable a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.TYPEVAR)) {
                TypeVariable b = (TypeVariable)p.type;
                return MoreTypes.equal(a.getUpperBound(), b.getUpperBound(), p.visiting) && MoreTypes.equal(a.getLowerBound(), b.getLowerBound(), p.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitWildcard(WildcardType a, EqualVisitorParam p) {
            if (p.type.getKind().equals((Object)TypeKind.WILDCARD)) {
                WildcardType b = (WildcardType)p.type;
                return MoreTypes.equal(a.getExtendsBound(), b.getExtendsBound(), p.visiting) && MoreTypes.equal(a.getSuperBound(), b.getSuperBound(), p.visiting);
            }
            return false;
        }

        @Override
        public Boolean visitUnknown(TypeMirror a, EqualVisitorParam p) {
            throw new UnsupportedOperationException();
        }
    };
    private static final int HASH_SEED = 17;
    private static final int HASH_MULTIPLIER = 31;
    private static final TypeVisitor<Integer, Set<Element>> HASH_VISITOR = new SimpleTypeVisitor6<Integer, Set<Element>>(){

        int hashKind(int seed, TypeMirror t) {
            int result = seed * 31;
            return result += t.getKind().hashCode();
        }

        @Override
        protected Integer defaultAction(TypeMirror e, Set<Element> visiting) {
            return this.hashKind(17, e);
        }

        @Override
        public Integer visitArray(ArrayType t, Set<Element> visiting) {
            int result = this.hashKind(17, t);
            result *= 31;
            return result += t.getComponentType().accept(this, visiting).intValue();
        }

        @Override
        public Integer visitDeclared(DeclaredType t, Set<Element> visiting) {
            Element element = t.asElement();
            if (visiting.contains(element)) {
                return 0;
            }
            HashSet<Element> newVisiting = new HashSet<Element>(visiting);
            newVisiting.add(element);
            int result = this.hashKind(17, t);
            result *= 31;
            result += t.asElement().hashCode();
            result *= 31;
            result += t.getEnclosingType().accept(this, newVisiting).intValue();
            result *= 31;
            return result += MoreTypes.hashList(t.getTypeArguments(), newVisiting);
        }

        @Override
        public Integer visitExecutable(ExecutableType t, Set<Element> visiting) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += MoreTypes.hashList(t.getParameterTypes(), visiting);
            result *= 31;
            result += t.getReturnType().accept(this, visiting).intValue();
            result *= 31;
            result += MoreTypes.hashList(t.getThrownTypes(), visiting);
            result *= 31;
            return result += MoreTypes.hashList(t.getTypeVariables(), visiting);
        }

        @Override
        public Integer visitTypeVariable(TypeVariable t, Set<Element> visiting) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += t.getLowerBound().accept(this, visiting).intValue();
            TypeParameterElement element = (TypeParameterElement)t.asElement();
            for (TypeMirror typeMirror : element.getBounds()) {
                result *= 31;
                result += typeMirror.accept(this, visiting).intValue();
            }
            return result;
        }

        @Override
        public Integer visitWildcard(WildcardType t, Set<Element> visiting) {
            int result = this.hashKind(17, t);
            result *= 31;
            result += t.getExtendsBound() == null ? 0 : t.getExtendsBound().accept(this, visiting);
            result *= 31;
            return result += t.getSuperBound() == null ? 0 : t.getSuperBound().accept(this, visiting);
        }

        @Override
        public Integer visitUnknown(TypeMirror t, Set<Element> visiting) {
            throw new UnsupportedOperationException();
        }
    };

    public static Equivalence<TypeMirror> equivalence() {
        return TYPE_EQUIVALENCE;
    }

    private static boolean equal(TypeMirror a, TypeMirror b, Set<ComparedElements> visiting) {
        if (Objects.equal((Object)a, (Object)b) && !(a instanceof ExecutableType)) {
            return true;
        }
        EqualVisitorParam p = new EqualVisitorParam();
        p.type = b;
        p.visiting = visiting;
        return a == b || a != null && b != null && a.accept(EQUAL_VISITOR, p) != false;
    }

    private static boolean equalLists(List<? extends TypeMirror> a, List<? extends TypeMirror> b, Set<ComparedElements> visiting) {
        int size = a.size();
        if (size != b.size()) {
            return false;
        }
        Iterator<? extends TypeMirror> aIterator = a.iterator();
        Iterator<? extends TypeMirror> bIterator = b.iterator();
        while (aIterator.hasNext()) {
            TypeMirror nextMirrorB;
            if (!bIterator.hasNext()) {
                return false;
            }
            TypeMirror nextMirrorA = aIterator.next();
            if (MoreTypes.equal(nextMirrorA, nextMirrorB = bIterator.next(), visiting)) continue;
            return false;
        }
        return !aIterator.hasNext();
    }

    private static int hashList(List<? extends TypeMirror> mirrors, Set<Element> visiting) {
        int result = 17;
        for (TypeMirror typeMirror : mirrors) {
            result *= 31;
            result += MoreTypes.hash(typeMirror, visiting);
        }
        return result;
    }

    private static int hash(TypeMirror mirror, Set<Element> visiting) {
        return mirror == null ? 0 : mirror.accept(HASH_VISITOR, visiting);
    }

    public static ImmutableSet<TypeElement> referencedTypes(TypeMirror type) {
        Preconditions.checkNotNull((Object)type);
        ImmutableSet.Builder elements = ImmutableSet.builder();
        type.accept(new SimpleTypeVisitor6<Void, ImmutableSet.Builder<TypeElement>>(){

            @Override
            public Void visitArray(ArrayType t, ImmutableSet.Builder<TypeElement> p) {
                t.getComponentType().accept(this, p);
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType t, ImmutableSet.Builder<TypeElement> p) {
                p.add((Object)MoreElements.asType(t.asElement()));
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    typeMirror.accept(this, p);
                }
                return null;
            }

            @Override
            public Void visitTypeVariable(TypeVariable t, ImmutableSet.Builder<TypeElement> p) {
                t.getLowerBound().accept(this, p);
                t.getUpperBound().accept(this, p);
                return null;
            }

            @Override
            public Void visitWildcard(WildcardType t, ImmutableSet.Builder<TypeElement> p) {
                TypeMirror superBound;
                TypeMirror extendsBound = t.getExtendsBound();
                if (extendsBound != null) {
                    extendsBound.accept(this, p);
                }
                if ((superBound = t.getSuperBound()) != null) {
                    superBound.accept(this, p);
                }
                return null;
            }
        }, elements);
        return elements.build();
    }

    public static TypeElement asTypeElement(Types types, TypeMirror mirror) {
        Preconditions.checkNotNull((Object)types);
        Preconditions.checkNotNull((Object)mirror);
        Element element = types.asElement(mirror);
        Preconditions.checkArgument((element != null ? 1 : 0) != 0);
        return element.accept(new SimpleElementVisitor6<TypeElement, Void>(){

            @Override
            protected TypeElement defaultAction(Element e, Void p) {
                throw new IllegalArgumentException();
            }

            @Override
            public TypeElement visitType(TypeElement e, Void p) {
                return e;
            }
        }, null);
    }

    public static ImmutableSet<TypeElement> asTypeElements(Types types, Iterable<? extends TypeMirror> mirrors) {
        Preconditions.checkNotNull((Object)types);
        Preconditions.checkNotNull(mirrors);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (TypeMirror typeMirror : mirrors) {
            builder.add((Object)MoreTypes.asTypeElement(types, typeMirror));
        }
        return builder.build();
    }

    public static ArrayType asArray(TypeMirror maybeArrayType) {
        return maybeArrayType.accept(new CastingTypeVisitor<ArrayType>(){

            @Override
            public ArrayType visitArray(ArrayType type, String ignore) {
                return type;
            }
        }, "primitive array");
    }

    public static DeclaredType asDeclared(TypeMirror maybeDeclaredType) {
        return maybeDeclaredType.accept(new CastingTypeVisitor<DeclaredType>(){

            @Override
            public DeclaredType visitDeclared(DeclaredType type, String ignored) {
                return type;
            }
        }, "declared type");
    }

    public static ErrorType asError(TypeMirror maybeErrorType) {
        return maybeErrorType.accept(new CastingTypeVisitor<ErrorType>(){

            @Override
            public ErrorType visitError(ErrorType type, String p) {
                return type;
            }
        }, "error type");
    }

    public static ExecutableType asExecutable(TypeMirror maybeExecutableType) {
        return maybeExecutableType.accept(new CastingTypeVisitor<ExecutableType>(){

            @Override
            public ExecutableType visitExecutable(ExecutableType type, String p) {
                return type;
            }
        }, "executable type");
    }

    public static NoType asNoType(TypeMirror maybeNoType) {
        return maybeNoType.accept(new CastingTypeVisitor<NoType>(){

            @Override
            public NoType visitNoType(NoType noType, String p) {
                return noType;
            }
        }, "non-type");
    }

    public static NullType asNullType(TypeMirror maybeNullType) {
        return maybeNullType.accept(new CastingTypeVisitor<NullType>(){

            @Override
            public NullType visitNull(NullType nullType, String p) {
                return nullType;
            }
        }, "null");
    }

    public static PrimitiveType asPrimitiveType(TypeMirror maybePrimitiveType) {
        return maybePrimitiveType.accept(new CastingTypeVisitor<PrimitiveType>(){

            @Override
            public PrimitiveType visitPrimitive(PrimitiveType type, String p) {
                return type;
            }
        }, "primitive type");
    }

    public static TypeVariable asTypeVariable(TypeMirror maybeTypeVariable) {
        return maybeTypeVariable.accept(new CastingTypeVisitor<TypeVariable>(){

            @Override
            public TypeVariable visitTypeVariable(TypeVariable type, String p) {
                return type;
            }
        }, "type variable");
    }

    public static WildcardType asWildcard(WildcardType maybeWildcardType) {
        return maybeWildcardType.accept(new CastingTypeVisitor<WildcardType>(){

            @Override
            public WildcardType visitWildcard(WildcardType type, String p) {
                return type;
            }
        }, "wildcard type");
    }

    public static boolean isTypeOf(final Class<?> clazz, TypeMirror type) {
        Preconditions.checkNotNull(clazz);
        return type.accept(new SimpleTypeVisitor6<Boolean, Void>(){

            @Override
            protected Boolean defaultAction(TypeMirror type, Void ignored) {
                throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
            }

            @Override
            public Boolean visitNoType(NoType noType, Void p) {
                if (noType.getKind().equals((Object)TypeKind.VOID)) {
                    return clazz.equals(Void.TYPE);
                }
                throw new IllegalArgumentException(noType + " cannot be represented as a Class<?>.");
            }

            @Override
            public Boolean visitPrimitive(PrimitiveType type, Void p) {
                switch (type.getKind()) {
                    case BOOLEAN: {
                        return clazz.equals(Boolean.TYPE);
                    }
                    case BYTE: {
                        return clazz.equals(Byte.TYPE);
                    }
                    case CHAR: {
                        return clazz.equals(Character.TYPE);
                    }
                    case DOUBLE: {
                        return clazz.equals(Double.TYPE);
                    }
                    case FLOAT: {
                        return clazz.equals(Float.TYPE);
                    }
                    case INT: {
                        return clazz.equals(Integer.TYPE);
                    }
                    case LONG: {
                        return clazz.equals(Long.TYPE);
                    }
                    case SHORT: {
                        return clazz.equals(Short.TYPE);
                    }
                }
                throw new IllegalArgumentException(type + " cannot be represented as a Class<?>.");
            }

            @Override
            public Boolean visitArray(ArrayType array, Void p) {
                return clazz.isArray() && MoreTypes.isTypeOf(clazz.getComponentType(), array.getComponentType());
            }

            @Override
            public Boolean visitDeclared(DeclaredType type, Void ignored) {
                TypeElement typeElement;
                try {
                    typeElement = MoreElements.asType(type.asElement());
                }
                catch (IllegalArgumentException iae) {
                    throw new IllegalArgumentException(type + " does not represent a class or interface.");
                }
                return typeElement.getQualifiedName().contentEquals(clazz.getCanonicalName());
            }
        }, null);
    }

    private MoreTypes() {
    }

    private static class CastingTypeVisitor<T>
    extends SimpleTypeVisitor6<T, String> {
        private CastingTypeVisitor() {
        }

        @Override
        protected T defaultAction(TypeMirror e, String label) {
            throw new IllegalArgumentException(e + " does not represent a " + label);
        }
    }

    private static class ComparedElements {
        final Element a;
        final Element b;

        ComparedElements(Element a, Element b) {
            this.a = a;
            this.b = b;
        }

        public boolean equals(Object o) {
            if (o instanceof ComparedElements) {
                ComparedElements that = (ComparedElements)o;
                return this.a.equals(that.a) && this.b.equals(that.b);
            }
            return false;
        }

        public int hashCode() {
            return this.a.hashCode() * 31 + this.b.hashCode();
        }
    }

    private static final class EqualVisitorParam {
        TypeMirror type;
        Set<ComparedElements> visiting;

        private EqualVisitorParam() {
        }
    }
}

