/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.sjavac.options;

import com.sun.tools.sjavac.CopyFile;
import com.sun.tools.sjavac.Transformer;
import com.sun.tools.sjavac.options.ArgumentIterator;
import com.sun.tools.sjavac.options.OptionHelper;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Option {
    SRC("-src", "Location of source files to be compiled"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            List<Path> paths = this.getFileListArg(iter, helper);
            if (paths != null) {
                helper.sourceRoots(paths);
            }
        }
    }
    ,
    SOURCEPATH("-sourcepath", "Specify search path for sources."){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            List<Path> paths = this.getFileListArg(iter, helper);
            if (paths != null) {
                helper.sourcepath(paths);
            }
        }
    }
    ,
    MODULEPATH("-modulepath", "Specify search path for modules."){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            List<Path> paths = this.getFileListArg(iter, helper);
            if (paths != null) {
                helper.modulepath(paths);
            }
        }
    }
    ,
    CLASSPATH("-classpath", "Specify search path for classes."){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            List<Path> paths = this.getFileListArg(iter, helper);
            if (paths != null) {
                helper.classpath(paths);
            }
        }
    }
    ,
    CP("-cp", "An alias for -classpath"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            CLASSPATH.processMatching(iter, helper);
        }
    }
    ,
    X("-x", "Exclude directory from the subsequent source directory"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            String pattern = this.getFilePatternArg(iter, helper);
            if (pattern != null) {
                helper.exclude(pattern);
            }
        }
    }
    ,
    I("-i", "Include only the given directory from the subsequent source directory"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            String pattern = this.getFilePatternArg(iter, helper);
            if (pattern != null) {
                helper.include(pattern);
            }
        }
    }
    ,
    XF("-xf", "Exclude a given file"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            String pattern = this.getFilePatternArg(iter, helper);
            if (pattern != null) {
                helper.excludeFile(pattern);
            }
        }
    }
    ,
    IF("-if", "Include only the given file"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            String pattern = this.getFilePatternArg(iter, helper);
            if (pattern != null) {
                helper.includeFile(pattern);
            }
        }
    }
    ,
    TR("-tr", "Translate resources"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            if (!iter.hasNext()) {
                helper.reportError(this.arg + " must be followed by a translation rule");
                return;
            }
            String trArg = iter.next();
            String ident = "[a-zA-Z_][a-zA-Z0-9_]*";
            Pattern p = Pattern.compile("(?<suffix>\\." + ident + ")=" + "(?<class>" + ident + "(\\." + ident + ")*)" + "(?<extra>,.*)?");
            Matcher m = p.matcher(trArg);
            if (!m.matches()) {
                helper.reportError("The string \"" + trArg + "\" is not a " + "valid translate pattern");
                return;
            }
            String suffix = m.group("suffix");
            String classname = m.group("class");
            String extra = m.group("extra");
            if (suffix.matches("\\.(class|java)")) {
                helper.reportError("You cannot have a translator for " + suffix + " files!");
                return;
            }
            try {
                Class<?> trCls = Class.forName(classname);
                Transformer transformer = (Transformer)trCls.newInstance();
                transformer.setExtra(extra);
                helper.addTransformer(suffix, transformer);
            }
            catch (Exception e) {
                helper.reportError("Cannot use " + classname + " as a translator: " + e.getMessage());
            }
        }
    }
    ,
    COPY("-copy", "Copy resources"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            if (!iter.hasNext()) {
                helper.reportError(this.arg + " must be followed by a resource type");
                return;
            }
            String copyArg = iter.next();
            if (!copyArg.matches("\\.[a-zA-Z_][a-zA-Z0-9_]*")) {
                helper.reportError("The string \"" + copyArg + "\" is not a " + "valid resource type.");
                return;
            }
            helper.addTransformer(copyArg, new CopyFile());
        }
    }
    ,
    J("-j", "Number of cores"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            if (!iter.hasNext() || !iter.peek().matches("\\d+")) {
                helper.reportError(this.arg + " must be followed by an integer");
                return;
            }
            helper.numCores(Integer.parseInt(iter.next()));
        }
    }
    ,
    SERVER("--server:", "Specify server configuration file of running server"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            helper.serverConf(iter.current().substring(this.arg.length()));
        }
    }
    ,
    STARTSERVER("--startserver:", "Start server and use the given configuration file"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            helper.startServerConf(iter.current().substring(this.arg.length()));
        }
    }
    ,
    IMPLICIT("-implicit:", "Specify how to treat implicitly referenced source code"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            helper.implicit(iter.current().substring(this.arg.length()));
        }
    }
    ,
    LOG("--log=", "Specify logging level"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            helper.logLevel(iter.current().substring(this.arg.length()));
        }
    }
    ,
    VERBOSE("-verbose", "Set verbosity level to \"info\""){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            helper.logLevel("info");
        }
    }
    ,
    PERMIT_ARTIFACT("--permit-artifact=", "Allow this artifact in destination directory"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            String a = iter.current().substring(this.arg.length());
            helper.permitArtifact(Paths.get(a, new String[0]).toFile().getAbsolutePath());
        }
    }
    ,
    PERMIT_UNIDENTIFIED_ARTIFACTS("--permit-unidentified-artifacts", "Allow unidentified artifacts in destination directory"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            helper.permitUnidentifiedArtifacts();
        }
    }
    ,
    PERMIT_SOURCES_WITHOUT_PACKAGE("--permit-sources-without-package", "Permit sources in the default package"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            helper.permitDefaultPackage();
        }
    }
    ,
    COMPARE_FOUND_SOURCES("--compare-found-sources", "Compare found sources with given sources"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            Path referenceSourceList = this.getFileArg(iter, helper, true, false);
            if (referenceSourceList != null) {
                helper.compareFoundSources(referenceSourceList);
            }
        }
    }
    ,
    D("-d", "Output destination directory"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            Path dir = this.getFileArg(iter, helper, false, true);
            if (dir != null) {
                helper.destDir(dir);
            }
        }
    }
    ,
    S("-s", "Directory for generated sources"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            Path dir = this.getFileArg(iter, helper, false, true);
            if (dir != null) {
                helper.generatedSourcesDir(dir);
            }
        }
    }
    ,
    H("-h", "Directory for header files"){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            Path dir = this.getFileArg(iter, helper, false, true);
            if (dir != null) {
                helper.headerDir(dir);
            }
        }
    }
    ,
    STATE_DIR("--state-dir=", "Directory used to store sjavac state and log files."){

        @Override
        protected void processMatching(ArgumentIterator iter, OptionHelper helper) {
            String p = iter.current().substring(this.arg.length());
            helper.stateDir(Paths.get(p, new String[0]));
        }
    };

    public final String arg;
    final String description;

    private Option(String arg, String description) {
        this.arg = arg;
        this.description = description;
    }

    List<Path> getFileListArg(ArgumentIterator iter, OptionHelper helper) {
        if (!iter.hasNext()) {
            helper.reportError(this.arg + " must be followed by a list of files " + "separated by " + File.pathSeparator);
            return null;
        }
        ArrayList<Path> result = new ArrayList<Path>();
        for (String pathStr : iter.next().split(File.pathSeparator)) {
            result.add(Paths.get(pathStr, new String[0]));
        }
        return result;
    }

    Path getFileArg(ArgumentIterator iter, OptionHelper helper, boolean fileAcceptable, boolean dirAcceptable) {
        if (!iter.hasNext()) {
            String errmsg = this.arg + " must be followed by ";
            if (fileAcceptable && dirAcceptable) {
                errmsg = errmsg + "a file or directory.";
            } else if (fileAcceptable) {
                errmsg = errmsg + "a file.";
            } else if (dirAcceptable) {
                errmsg = errmsg + "a directory.";
            } else {
                throw new IllegalArgumentException("File or directory must be acceptable.");
            }
            helper.reportError(errmsg);
            return null;
        }
        return Paths.get(iter.next(), new String[0]);
    }

    String getFilePatternArg(ArgumentIterator iter, OptionHelper helper) {
        if (!iter.hasNext()) {
            helper.reportError(this.arg + " must be followed by a file or directory pattern.");
            return null;
        }
        return iter.next();
    }

    public boolean hasOption() {
        return this.arg.endsWith(":") || this.arg.endsWith("=");
    }

    public final boolean processCurrent(ArgumentIterator argIter, OptionHelper helper) {
        String fullArg = argIter.current();
        if (this.hasOption() ? fullArg.startsWith(this.arg) : fullArg.equals(this.arg)) {
            this.processMatching(argIter, helper);
            return true;
        }
        return false;
    }

    protected abstract void processMatching(ArgumentIterator var1, OptionHelper var2);
}

