/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.util.ASTHelpers;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Pair;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Generated;

public class SuppressionHelper {
    private final Set<Class<? extends Annotation>> customSuppressionAnnotations;

    public SuppressionHelper(Set<Class<? extends Annotation>> customSuppressionAnnotations, VisitorState state) {
        if (customSuppressionAnnotations == null) {
            throw new IllegalArgumentException("customSuppressionAnnotations must be non-null");
        }
        this.customSuppressionAnnotations = customSuppressionAnnotations;
    }

    public SuppressionInfo extendSuppressionSets(Symbol sym, Type suppressWarningsType, Set<String> suppressionsOnCurrentPath, Set<Class<? extends Annotation>> customSuppressionsOnCurrentPath, boolean inGeneratedCode, VisitorState state) {
        boolean newInGeneratedCode = inGeneratedCode || ASTHelpers.hasAnnotation(sym, Generated.class, state);
        HashSet<Class<? extends Annotation>> newCustomSuppressions = null;
        for (Class<? extends Annotation> annotationType : this.customSuppressionAnnotations) {
            if (!ASTHelpers.hasAnnotation(sym, annotationType, state)) continue;
            if (newCustomSuppressions == null) {
                newCustomSuppressions = new HashSet<Class<? extends Annotation>>(customSuppressionsOnCurrentPath);
            }
            newCustomSuppressions.add(annotationType);
        }
        HashSet<String> newSuppressions = null;
        for (Attribute.Compound attr : sym.getAnnotationMirrors()) {
            if (attr.type.tsym != suppressWarningsType.tsym && !attr.type.tsym.getQualifiedName().contentEquals("android.annotation.SuppressLint")) continue;
            List<Pair<Symbol.MethodSymbol, Attribute>> v = attr.values;
            while (v.nonEmpty()) {
                Pair value = (Pair)v.head;
                if (((Symbol.MethodSymbol)value.fst).name.contentEquals("value")) {
                    if (value.snd instanceof Attribute.Array) {
                        for (Attribute suppress : ((Attribute.Array)value.snd).values) {
                            if (newSuppressions == null) {
                                newSuppressions = new HashSet<String>(suppressionsOnCurrentPath);
                            }
                            newSuppressions.add((String)suppress.getValue());
                        }
                    } else {
                        throw new RuntimeException("Expected SuppressWarnings/SuppressLint annotation to take array type");
                    }
                }
                v = v.tail;
            }
        }
        return new SuppressionInfo(newSuppressions, (Set<Class<? extends Annotation>>)newCustomSuppressions, newInGeneratedCode);
    }

    public static boolean isSuppressed(Suppressible suppressible, Set<String> suppressionsOnCurrentPath, Set<Class<? extends Annotation>> customSuppressionsOnCurrentPath, BugPattern.SeverityLevel severityLevel, boolean inGeneratedCode, boolean disableWarningsInGeneratedCode) {
        if (suppressible.suppressibility() == BugPattern.Suppressibility.UNSUPPRESSIBLE) {
            return false;
        }
        if (inGeneratedCode && disableWarningsInGeneratedCode && severityLevel != BugPattern.SeverityLevel.ERROR) {
            return true;
        }
        switch (suppressible.suppressibility()) {
            case CUSTOM_ANNOTATION: {
                return !Collections.disjoint(suppressible.customSuppressionAnnotations(), customSuppressionsOnCurrentPath);
            }
            case SUPPRESS_WARNINGS: {
                return !Collections.disjoint(suppressible.allNames(), suppressionsOnCurrentPath);
            }
        }
        throw new IllegalStateException("No case for: " + suppressible.suppressibility());
    }

    public static class SuppressionInfo {
        public Set<String> suppressWarningsStrings;
        public Set<Class<? extends Annotation>> customSuppressions;
        public boolean inGeneratedCode;

        public SuppressionInfo(Set<String> suppressWarningsStrings, Set<Class<? extends Annotation>> customSuppressions, boolean inGeneratedCode) {
            this.suppressWarningsStrings = suppressWarningsStrings;
            this.customSuppressions = customSuppressions;
            this.inGeneratedCode = inGeneratedCode;
        }
    }
}

