/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.MustBeClosed;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;

public abstract class AbstractMustBeClosedChecker
extends BugChecker {
    protected static final Matcher<Tree> HAS_MUST_BE_CLOSED_ANNOTATION = Matchers.hasAnnotation((String)MustBeClosed.class.getCanonicalName());
    private static final Matcher<ExpressionTree> CLOSE_METHOD = Matchers.instanceMethod().onDescendantOf("java.lang.AutoCloseable").named("close");
    private static final Matcher<Tree> MOCKITO_MATCHER = Matchers.toType(MethodInvocationTree.class, (Matcher)MethodMatchers.staticMethod().onClass("org.mockito.Mockito").named("when"));

    protected Description matchNewClassOrMethodInvocation(Tree tree, VisitorState state) {
        Description description = this.checkClosed(tree, state);
        if (description == Description.NO_MATCH) {
            return Description.NO_MATCH;
        }
        if (AbstractReturnValueIgnored.expectedExceptionTest(tree, state) || MOCKITO_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        return description;
    }

    private Description checkClosed(Tree tree, VisitorState state) {
        MethodTree callerMethodTree = AbstractMustBeClosedChecker.enclosingMethod(state);
        if (state.getPath().getParentPath().getLeaf().getKind() == Tree.Kind.RETURN && callerMethodTree != null) {
            if (HAS_MUST_BE_CLOSED_ANNOTATION.matches((Tree)callerMethodTree, state)) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(tree).addFix((Fix)SuggestedFix.builder().prefixWith((Tree)callerMethodTree, "@MustBeClosed\n").addImport(MustBeClosed.class.getCanonicalName()).build()).build();
        }
        if (!this.inTWR(state)) {
            Description.Builder description = this.buildDescription(tree);
            this.addFix(description, tree, state);
            return description.build();
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private static MethodTree enclosingMethod(VisitorState state) {
        for (Tree node : state.getPath().getParentPath()) {
            switch (node.getKind()) {
                case LAMBDA_EXPRESSION: 
                case NEW_CLASS: {
                    return null;
                }
                case METHOD: {
                    return (MethodTree)node;
                }
            }
        }
        return null;
    }

    private boolean inTWR(VisitorState state) {
        TreePath path = state.getPath().getParentPath();
        while (path.getLeaf().getKind() == Tree.Kind.CONDITIONAL_EXPRESSION) {
            path = path.getParentPath();
        }
        Symbol sym = ASTHelpers.getSymbol((Tree)path.getLeaf());
        if (!(sym instanceof Symbol.VarSymbol)) {
            return false;
        }
        Symbol.VarSymbol var = (Symbol.VarSymbol)sym;
        return var.getKind() == ElementKind.RESOURCE_VARIABLE || this.tryFinallyClose(var, path, state);
    }

    private boolean tryFinallyClose(final Symbol.VarSymbol var, TreePath path, final VisitorState state) {
        if ((var.flags() & 0x20000000010L) == 0L) {
            return false;
        }
        Tree parent = path.getParentPath().getLeaf();
        if (parent.getKind() != Tree.Kind.BLOCK) {
            return false;
        }
        BlockTree block = (BlockTree)parent;
        int idx = block.getStatements().indexOf(path.getLeaf());
        if (idx == -1 || idx == block.getStatements().size() - 1) {
            return false;
        }
        StatementTree next = block.getStatements().get(idx + 1);
        if (!(next instanceof TryTree)) {
            return false;
        }
        TryTree tryTree = (TryTree)next;
        if (tryTree.getFinallyBlock() == null) {
            return false;
        }
        final boolean[] closed = new boolean[]{false};
        tryTree.getFinallyBlock().accept(new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void unused) {
                if (CLOSE_METHOD.matches((Tree)tree, state) && Objects.equals(ASTHelpers.getSymbol((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), var)) {
                    closed[0] = true;
                }
                return null;
            }
        }, null);
        return closed[0];
    }

    protected void addFix(Description.Builder description, Tree tree, VisitorState state) {
    }
}

