/*
 * Decompiled with CFR 0.152.
 */
package dagger.producers.monitoring;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import dagger.producers.monitoring.ProducerTimingRecorder;
import dagger.producers.monitoring.ProducerToken;
import dagger.producers.monitoring.ProductionComponentTimingRecorder;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class TimingRecorders {
    private static final Logger logger = Logger.getLogger(TimingRecorders.class.getName());
    private static final ProductionComponentTimingRecorder.Factory NO_OP_PRODUCTION_COMPONENT_TIMING_RECORDER_FACTORY = new ProductionComponentTimingRecorder.Factory(){

        @Override
        public ProductionComponentTimingRecorder create(Object component) {
            return TimingRecorders.noOpProductionComponentTimingRecorder();
        }
    };
    private static final ProductionComponentTimingRecorder NO_OP_PRODUCTION_COMPONENT_TIMING_RECORDER = new ProductionComponentTimingRecorder(){

        @Override
        public ProducerTimingRecorder producerTimingRecorderFor(ProducerToken token) {
            return ProducerTimingRecorder.noOp();
        }
    };

    public static ProductionComponentTimingRecorder.Factory delegatingProductionComponentTimingRecorderFactory(Collection<ProductionComponentTimingRecorder.Factory> factories) {
        switch (factories.size()) {
            case 0: {
                return TimingRecorders.noOpProductionComponentTimingRecorderFactory();
            }
            case 1: {
                return new NonThrowingProductionComponentTimingRecorder.Factory((ProductionComponentTimingRecorder.Factory)Iterables.getOnlyElement(factories));
            }
        }
        return new DelegatingProductionComponentTimingRecorder.Factory(factories);
    }

    public static ProductionComponentTimingRecorder.Factory noOpProductionComponentTimingRecorderFactory() {
        return NO_OP_PRODUCTION_COMPONENT_TIMING_RECORDER_FACTORY;
    }

    public static ProductionComponentTimingRecorder noOpProductionComponentTimingRecorder() {
        return NO_OP_PRODUCTION_COMPONENT_TIMING_RECORDER;
    }

    private static void logCreateException(RuntimeException e, ProductionComponentTimingRecorder.Factory factory, Object component) {
        String string = String.valueOf("RuntimeException while calling ProductionComponentTimingRecorder.Factory.create on factory ");
        String string2 = String.valueOf(factory);
        String string3 = String.valueOf(component);
        logger.log(Level.SEVERE, new StringBuilder(16 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(" with component ").append(string3).toString(), e);
    }

    private static void logProducerTimingRecorderForException(RuntimeException e, ProductionComponentTimingRecorder recorder, ProducerToken token) {
        String string = String.valueOf("RuntimeException while calling ProductionComponentTimingRecorder.producerTimingRecorderForon recorder ");
        String string2 = String.valueOf(recorder);
        String string3 = String.valueOf(token);
        logger.log(Level.SEVERE, new StringBuilder(12 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append(" with token ").append(string3).toString(), e);
    }

    private static void logProducerTimingRecorderMethodException(RuntimeException e, ProducerTimingRecorder recorder, String method) {
        String string = String.valueOf(recorder);
        logger.log(Level.SEVERE, new StringBuilder(67 + String.valueOf(method).length() + String.valueOf(string).length()).append("RuntimeException while calling ProducerTimingRecorder.").append(method).append(" on recorder ").append(string).toString(), e);
    }

    private TimingRecorders() {
    }

    private static final class DelegatingProducerTimingRecorder
    extends ProducerTimingRecorder {
        private final ImmutableList<ProducerTimingRecorder> delegates;

        DelegatingProducerTimingRecorder(ImmutableList<ProducerTimingRecorder> delegates) {
            this.delegates = delegates;
        }

        @Override
        public void recordMethod(long startedNanos, long durationNanos) {
            for (ProducerTimingRecorder delegate : this.delegates) {
                try {
                    delegate.recordMethod(startedNanos, durationNanos);
                }
                catch (RuntimeException e) {
                    TimingRecorders.logProducerTimingRecorderMethodException(e, delegate, "recordMethod");
                }
            }
        }

        @Override
        public void recordSuccess(long latencyNanos) {
            for (ProducerTimingRecorder delegate : this.delegates) {
                try {
                    delegate.recordSuccess(latencyNanos);
                }
                catch (RuntimeException e) {
                    TimingRecorders.logProducerTimingRecorderMethodException(e, delegate, "recordSuccess");
                }
            }
        }

        @Override
        public void recordFailure(Throwable exception, long latencyNanos) {
            for (ProducerTimingRecorder delegate : this.delegates) {
                try {
                    delegate.recordFailure(exception, latencyNanos);
                }
                catch (RuntimeException e) {
                    TimingRecorders.logProducerTimingRecorderMethodException(e, delegate, "recordFailure");
                }
            }
        }

        @Override
        public void recordSkip(Throwable exception) {
            for (ProducerTimingRecorder delegate : this.delegates) {
                try {
                    delegate.recordSkip(exception);
                }
                catch (RuntimeException e) {
                    TimingRecorders.logProducerTimingRecorderMethodException(e, delegate, "recordSkip");
                }
            }
        }
    }

    private static final class DelegatingProductionComponentTimingRecorder
    implements ProductionComponentTimingRecorder {
        private final ImmutableList<ProductionComponentTimingRecorder> delegates;

        DelegatingProductionComponentTimingRecorder(ImmutableList<ProductionComponentTimingRecorder> delegates) {
            this.delegates = delegates;
        }

        @Override
        public ProducerTimingRecorder producerTimingRecorderFor(ProducerToken token) {
            ImmutableList.Builder recordersBuilder = ImmutableList.builder();
            for (ProductionComponentTimingRecorder delegate : this.delegates) {
                try {
                    ProducerTimingRecorder recorder = delegate.producerTimingRecorderFor(token);
                    if (recorder == null) continue;
                    recordersBuilder.add((Object)recorder);
                }
                catch (RuntimeException e) {
                    TimingRecorders.logProducerTimingRecorderForException(e, delegate, token);
                }
            }
            ImmutableList recorders = recordersBuilder.build();
            switch (recorders.size()) {
                case 0: {
                    return ProducerTimingRecorder.noOp();
                }
                case 1: {
                    return new NonThrowingProducerTimingRecorder((ProducerTimingRecorder)Iterables.getOnlyElement((Iterable)recorders));
                }
            }
            return new DelegatingProducerTimingRecorder((ImmutableList<ProducerTimingRecorder>)recorders);
        }

        static final class Factory
        implements ProductionComponentTimingRecorder.Factory {
            private final ImmutableList<? extends ProductionComponentTimingRecorder.Factory> delegates;

            Factory(Iterable<? extends ProductionComponentTimingRecorder.Factory> delegates) {
                this.delegates = ImmutableList.copyOf(delegates);
            }

            @Override
            public ProductionComponentTimingRecorder create(Object component) {
                ImmutableList.Builder recordersBuilder = ImmutableList.builder();
                for (ProductionComponentTimingRecorder.Factory delegate : this.delegates) {
                    try {
                        ProductionComponentTimingRecorder recorder = delegate.create(component);
                        if (recorder == null) continue;
                        recordersBuilder.add((Object)recorder);
                    }
                    catch (RuntimeException e) {
                        TimingRecorders.logCreateException(e, delegate, component);
                    }
                }
                ImmutableList recorders = recordersBuilder.build();
                switch (recorders.size()) {
                    case 0: {
                        return TimingRecorders.noOpProductionComponentTimingRecorder();
                    }
                    case 1: {
                        return new NonThrowingProductionComponentTimingRecorder((ProductionComponentTimingRecorder)Iterables.getOnlyElement((Iterable)recorders));
                    }
                }
                return new DelegatingProductionComponentTimingRecorder((ImmutableList<ProductionComponentTimingRecorder>)recorders);
            }
        }
    }

    private static final class NonThrowingProducerTimingRecorder
    extends ProducerTimingRecorder {
        private final ProducerTimingRecorder delegate;

        NonThrowingProducerTimingRecorder(ProducerTimingRecorder delegate) {
            this.delegate = delegate;
        }

        @Override
        public void recordMethod(long startedNanos, long durationNanos) {
            try {
                this.delegate.recordMethod(startedNanos, durationNanos);
            }
            catch (RuntimeException e) {
                TimingRecorders.logProducerTimingRecorderMethodException(e, this.delegate, "recordMethod");
            }
        }

        @Override
        public void recordSuccess(long latencyNanos) {
            try {
                this.delegate.recordSuccess(latencyNanos);
            }
            catch (RuntimeException e) {
                TimingRecorders.logProducerTimingRecorderMethodException(e, this.delegate, "recordSuccess");
            }
        }

        @Override
        public void recordFailure(Throwable exception, long latencyNanos) {
            try {
                this.delegate.recordFailure(exception, latencyNanos);
            }
            catch (RuntimeException e) {
                TimingRecorders.logProducerTimingRecorderMethodException(e, this.delegate, "recordFailure");
            }
        }

        @Override
        public void recordSkip(Throwable exception) {
            try {
                this.delegate.recordSkip(exception);
            }
            catch (RuntimeException e) {
                TimingRecorders.logProducerTimingRecorderMethodException(e, this.delegate, "recordSkip");
            }
        }
    }

    private static final class NonThrowingProductionComponentTimingRecorder
    implements ProductionComponentTimingRecorder {
        private final ProductionComponentTimingRecorder delegate;

        NonThrowingProductionComponentTimingRecorder(ProductionComponentTimingRecorder delegate) {
            this.delegate = delegate;
        }

        @Override
        public ProducerTimingRecorder producerTimingRecorderFor(ProducerToken token) {
            try {
                ProducerTimingRecorder recorder = this.delegate.producerTimingRecorderFor(token);
                return recorder == null ? ProducerTimingRecorder.noOp() : new NonThrowingProducerTimingRecorder(recorder);
            }
            catch (RuntimeException e) {
                TimingRecorders.logProducerTimingRecorderForException(e, this.delegate, token);
                return ProducerTimingRecorder.noOp();
            }
        }

        static final class Factory
        implements ProductionComponentTimingRecorder.Factory {
            private final ProductionComponentTimingRecorder.Factory delegate;

            Factory(ProductionComponentTimingRecorder.Factory delegate) {
                this.delegate = delegate;
            }

            @Override
            public ProductionComponentTimingRecorder create(Object component) {
                try {
                    ProductionComponentTimingRecorder recorder = this.delegate.create(component);
                    return recorder == null ? TimingRecorders.noOpProductionComponentTimingRecorder() : new NonThrowingProductionComponentTimingRecorder(recorder);
                }
                catch (RuntimeException e) {
                    TimingRecorders.logCreateException(e, this.delegate, component);
                    return TimingRecorders.noOpProductionComponentTimingRecorder();
                }
            }
        }
    }
}

