/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.Subject;
import com.google.common.util.concurrent.AtomicLongMap;
import javax.annotation.Nullable;

public final class AtomicLongMapSubject
extends Subject<AtomicLongMapSubject, AtomicLongMap<?>> {
    AtomicLongMapSubject(FailureStrategy failureStrategy, @Nullable AtomicLongMap<?> map) {
        super(failureStrategy, map);
    }

    @Override
    @Deprecated
    public void isEqualTo(@Nullable Object other) {
        super.isEqualTo(other);
    }

    @Override
    @Deprecated
    public void isNotEqualTo(@Nullable Object other) {
        super.isNotEqualTo(other);
    }

    public void isEmpty() {
        if (!((AtomicLongMap)this.actual()).isEmpty()) {
            this.fail("is empty");
        }
    }

    public void isNotEmpty() {
        if (((AtomicLongMap)this.actual()).isEmpty()) {
            this.fail("is not empty");
        }
    }

    public void hasSize(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (String)"expectedSize (%s) must be >= 0", (int)expectedSize);
        int actualSize = ((AtomicLongMap)this.actual()).size();
        if (actualSize != expectedSize) {
            this.failWithBadResults("has a size of", expectedSize, "is", actualSize);
        }
    }

    public void hasSum(long expectedSum) {
        long actualSum = ((AtomicLongMap)this.actual()).sum();
        if (actualSum != expectedSum) {
            this.failWithBadResults("has a sum of", expectedSum, "is", actualSum);
        }
    }

    public void containsKey(Object key) {
        Preconditions.checkNotNull((Object)key, (Object)"AtomicLongMap does not support null keys");
        if (!((AtomicLongMap)this.actual()).containsKey(key)) {
            this.fail("contains key", key);
        }
    }

    public void doesNotContainKey(Object key) {
        Preconditions.checkNotNull((Object)key, (Object)"AtomicLongMap does not support null keys");
        if (((AtomicLongMap)this.actual()).containsKey(key)) {
            this.fail("does not contain key", key);
        }
    }

    public void containsEntry(Object key, long value) {
        Preconditions.checkNotNull((Object)key, (Object)"AtomicLongMap does not support null keys");
        long actualValue = ((AtomicLongMap)this.actual()).get(key);
        if (actualValue != value) {
            this.fail("contains entry", (Object)Maps.immutableEntry((Object)key, (Object)value));
        }
    }

    public void doesNotContainEntry(@Nullable Object key, long value) {
        long actualValue;
        if (key != null && (actualValue = ((AtomicLongMap)this.actual()).get(key)) == value) {
            this.fail("does not contain entry", (Object)Maps.immutableEntry((Object)key, (Object)value));
        }
    }
}

