/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.assign.reference;

import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;

public enum ReferenceTypeAwareAssigner implements Assigner
{
    INSTANCE;


    @Override
    public StackManipulation assign(TypeDescription sourceType, TypeDescription targetType, Assigner.Typing typing) {
        if (sourceType.isPrimitive() || targetType.isPrimitive()) {
            if (sourceType.equals(targetType)) {
                return StackManipulation.Trivial.INSTANCE;
            }
            return StackManipulation.Illegal.INSTANCE;
        }
        if (targetType.isAssignableFrom(sourceType)) {
            return StackManipulation.Trivial.INSTANCE;
        }
        if (typing.isDynamic()) {
            return TypeCasting.to(targetType);
        }
        return StackManipulation.Illegal.INSTANCE;
    }

    public String toString() {
        return "ReferenceTypeAwareAssigner." + this.name();
    }
}

