/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.ArrayList;
import java.util.List;
import lombok.ast.AbstractNode;
import lombok.ast.AstException;
import lombok.ast.AstVisitor;
import lombok.ast.Block;
import lombok.ast.Expression;
import lombok.ast.Node;
import lombok.ast.Statement;
import lombok.ast.VariableDefinition;

public class ForEach
extends AbstractNode
implements Statement {
    private AbstractNode variable = null;
    private AbstractNode iterable = null;
    private AbstractNode statement = null;

    @Override
    public Block upToBlock() {
        if (!(this.getParent() instanceof Block)) {
            return null;
        }
        Block out = (Block)this.getParent();
        if (!out.rawContents().contains(this)) {
            return null;
        }
        return out;
    }

    public VariableDefinition astVariable() {
        if (!(this.variable instanceof VariableDefinition)) {
            return null;
        }
        return (VariableDefinition)this.variable;
    }

    public ForEach astVariable(VariableDefinition variable) {
        if (variable == null) {
            throw new NullPointerException("variable is mandatory");
        }
        return this.rawVariable(variable);
    }

    public Node rawVariable() {
        return this.variable;
    }

    public ForEach rawVariable(Node variable) {
        if (variable == this.variable) {
            return this;
        }
        if (variable != null) {
            this.adopt((AbstractNode)variable);
        }
        if (this.variable != null) {
            this.disown(this.variable);
        }
        this.variable = (AbstractNode)variable;
        return this;
    }

    public Expression astIterable() {
        if (!(this.iterable instanceof Expression)) {
            return null;
        }
        return (Expression)((Object)this.iterable);
    }

    public ForEach astIterable(Expression iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable is mandatory");
        }
        return this.rawIterable(iterable);
    }

    public Node rawIterable() {
        return this.iterable;
    }

    public ForEach rawIterable(Node iterable) {
        if (iterable == this.iterable) {
            return this;
        }
        if (iterable != null) {
            this.adopt((AbstractNode)iterable);
        }
        if (this.iterable != null) {
            this.disown(this.iterable);
        }
        this.iterable = (AbstractNode)iterable;
        return this;
    }

    public Statement astStatement() {
        if (!(this.statement instanceof Statement)) {
            return null;
        }
        return (Statement)((Object)this.statement);
    }

    public ForEach astStatement(Statement statement) {
        if (statement == null) {
            throw new NullPointerException("statement is mandatory");
        }
        return this.rawStatement(statement);
    }

    public Node rawStatement() {
        return this.statement;
    }

    public ForEach rawStatement(Node statement) {
        if (statement == this.statement) {
            return this;
        }
        if (statement != null) {
            this.adopt((AbstractNode)statement);
        }
        if (this.statement != null) {
            this.disown(this.statement);
        }
        this.statement = (AbstractNode)statement;
        return this;
    }

    @Override
    public List<Node> getChildren() {
        ArrayList<Node> result = new ArrayList<Node>();
        if (this.variable != null) {
            result.add(this.variable);
        }
        if (this.iterable != null) {
            result.add(this.iterable);
        }
        if (this.statement != null) {
            result.add(this.statement);
        }
        return result;
    }

    @Override
    public boolean replaceChild(Node original, Node replacement) throws AstException {
        if (this.variable == original) {
            this.rawVariable(replacement);
            return true;
        }
        if (this.iterable == original) {
            this.rawIterable(replacement);
            return true;
        }
        if (this.statement == original) {
            this.rawStatement(replacement);
            return true;
        }
        return false;
    }

    @Override
    public boolean detach(Node child) {
        if (this.variable == child) {
            this.disown((AbstractNode)child);
            this.variable = null;
            return true;
        }
        if (this.iterable == child) {
            this.disown((AbstractNode)child);
            this.iterable = null;
            return true;
        }
        if (this.statement == child) {
            this.disown((AbstractNode)child);
            this.statement = null;
            return true;
        }
        return false;
    }

    @Override
    public void accept(AstVisitor visitor) {
        if (visitor.visitForEach(this)) {
            return;
        }
        if (this.variable != null) {
            this.variable.accept(visitor);
        }
        if (this.iterable != null) {
            this.iterable.accept(visitor);
        }
        if (this.statement != null) {
            this.statement.accept(visitor);
        }
        visitor.afterVisitForEach(this);
        visitor.endVisit(this);
    }

    @Override
    public ForEach copy() {
        ForEach result = new ForEach();
        if (this.variable != null) {
            result.rawVariable(this.variable.copy());
        }
        if (this.iterable != null) {
            result.rawIterable(this.iterable.copy());
        }
        if (this.statement != null) {
            result.rawStatement(this.statement.copy());
        }
        return result;
    }
}

