/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.platform;

import com.sun.source.util.Plugin;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.platform.PlatformProvider;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.StringUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Processor;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

public class JDKPlatformProvider
implements PlatformProvider {
    private static final String[] symbolFileLocation = new String[]{"lib", "ct.sym"};
    private static final Set<String> SUPPORTED_JAVA_PLATFORM_VERSIONS = new TreeSet<String>();

    @Override
    public Iterable<String> getSupportedPlatformNames() {
        return SUPPORTED_JAVA_PLATFORM_VERSIONS;
    }

    @Override
    public PlatformDescription getPlatform(String platformName, String options) {
        return new PlatformDescriptionImpl(platformName);
    }

    private static String targetNumericVersion(Target target) {
        return Integer.toString(target.ordinal() - Target.JDK1_1.ordinal() + 1);
    }

    static Path findCtSym() {
        String javaHome = System.getProperty("java.home");
        Path file = Paths.get(javaHome, new String[0]);
        for (String name : symbolFileLocation) {
            file = file.resolve(name);
        }
        return file;
    }

    static {
        Path ctSymFile = JDKPlatformProvider.findCtSym();
        if (Files.exists(ctSymFile, new LinkOption[0])) {
            try (FileSystem fs = FileSystems.newFileSystem(ctSymFile, null);
                 DirectoryStream<Path> dir = Files.newDirectoryStream(fs.getRootDirectories().iterator().next());){
                for (Path section : dir) {
                    if (section.getFileName().toString().contains("-")) continue;
                    for (char ver : section.getFileName().toString().toCharArray()) {
                        String verString = Character.toString(ver);
                        Target t = Target.lookup("" + Integer.parseInt(verString, 16));
                        if (t == null) continue;
                        SUPPORTED_JAVA_PLATFORM_VERSIONS.add(JDKPlatformProvider.targetNumericVersion(t));
                    }
                }
            }
            catch (IOException | ProviderNotFoundException exception) {
                // empty catch block
            }
        }
    }

    static class PlatformDescriptionImpl
    implements PlatformDescription {
        private final Map<Path, FileSystem> ctSym2FileSystem = new HashMap<Path, FileSystem>();
        private final String sourceVersion;
        private final String ctSymVersion;

        PlatformDescriptionImpl(String sourceVersion) {
            this.sourceVersion = sourceVersion;
            this.ctSymVersion = StringUtils.toUpperCase(Integer.toHexString(Integer.parseInt(sourceVersion)));
        }

        @Override
        public JavaFileManager getFileManager() {
            Context context = new Context();
            PrintWriter pw = new PrintWriter(System.err, true);
            context.put(Log.errKey, pw);
            CacheFSInfo.preRegister(context);
            JavacFileManager fm = new JavacFileManager(context, true, null){

                @Override
                public boolean hasLocation(JavaFileManager.Location location) {
                    return super.hasExplicitLocation(location);
                }

                @Override
                public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
                    if (kind == JavaFileObject.Kind.CLASS) {
                        String fileName = className.replace('.', '/');
                        JavaFileObject result = (JavaFileObject)this.getFileForInput(location, "", fileName + ".sig");
                        if (result == null) {
                            result = (JavaFileObject)this.getFileForInput(location, "", fileName + ".class");
                        }
                        if (result != null) {
                            return new SigJavaFileObject(result);
                        }
                        return null;
                    }
                    return super.getJavaFileForInput(location, className, kind);
                }

                @Override
                public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, final Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
                    EnumSet<JavaFileObject.Kind> enhancedKinds = EnumSet.copyOf(kinds);
                    enhancedKinds.add(JavaFileObject.Kind.OTHER);
                    final Iterable<JavaFileObject> listed = super.list(location, packageName, enhancedKinds, recurse);
                    return () -> new Iterator<JavaFileObject>(){
                        private JavaFileObject next;
                        private final Iterator original;
                        {
                            this.original = listed.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.next == null) {
                                while (this.original.hasNext()) {
                                    JavaFileObject fo = (JavaFileObject)this.original.next();
                                    if (fo.getKind() == JavaFileObject.Kind.OTHER && fo.getName().endsWith(".sig")) {
                                        this.next = new SigJavaFileObject(fo);
                                        break;
                                    }
                                    if (!kinds.contains((Object)fo.getKind())) continue;
                                    this.next = fo;
                                    break;
                                }
                            }
                            return this.next != null;
                        }

                        @Override
                        public JavaFileObject next() {
                            if (!this.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            JavaFileObject result = this.next;
                            this.next = null;
                            return result;
                        }
                    };
                }

                @Override
                public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
                    if (file instanceof SigJavaFileObject) {
                        file = ((SigJavaFileObject)file).getDelegate();
                    }
                    return super.inferBinaryName(location, file);
                }
            };
            Path file = JDKPlatformProvider.findCtSym();
            if (Files.exists(file, new LinkOption[0])) {
                try {
                    FileSystem fs = this.ctSym2FileSystem.get(file);
                    if (fs == null) {
                        fs = FileSystems.newFileSystem(file, null);
                        this.ctSym2FileSystem.put(file, fs);
                    }
                    ArrayList<Path> paths = new ArrayList<Path>();
                    Path modules = fs.getPath(this.ctSymVersion + "-modules", new String[0]);
                    Path root = fs.getRootDirectories().iterator().next();
                    boolean pathsSet = false;
                    Charset utf8 = Charset.forName("UTF-8");
                    try (DirectoryStream<Path> dir = Files.newDirectoryStream(root);){
                        for (Path section : dir) {
                            if (!section.getFileName().toString().contains(this.ctSymVersion) || section.getFileName().toString().contains("-")) continue;
                            Path systemModules = section.resolve("system-modules");
                            if (Files.isRegularFile(systemModules, new LinkOption[0])) {
                                fm.handleOption("--system", Arrays.asList("none").iterator());
                                Path jrtModules = FileSystems.getFileSystem(URI.create("jrt:/")).getPath("modules", new String[0]);
                                try (Stream<String> lines = Files.lines(systemModules, utf8);){
                                    lines.map(line -> jrtModules.resolve((String)line)).filter(mod -> Files.exists(mod, new LinkOption[0])).forEach(mod -> PlatformDescriptionImpl.setModule(fm, mod));
                                }
                                pathsSet = true;
                                continue;
                            }
                            paths.add(section);
                        }
                    }
                    if (Files.isDirectory(modules, new LinkOption[0])) {
                        dir = Files.newDirectoryStream(modules);
                        var12_13 = null;
                        try {
                            fm.handleOption("--system", Arrays.asList("none").iterator());
                            for (Path module : dir) {
                                fm.setLocationForModule(StandardLocation.SYSTEM_MODULES, module.getFileName().toString(), Stream.concat(paths.stream(), Stream.of(module)).collect(Collectors.toList()));
                            }
                        }
                        catch (Throwable throwable) {
                            var12_13 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (dir != null) {
                                PlatformDescriptionImpl.$closeResource(var12_13, dir);
                            }
                        }
                    } else if (!pathsSet) {
                        fm.setLocationFromPaths(StandardLocation.PLATFORM_CLASS_PATH, paths);
                    }
                    return fm;
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            throw new IllegalStateException("Cannot find ct.sym!");
        }

        private static void setModule(StandardJavaFileManager fm, Path mod) {
            try {
                fm.setLocationForModule(StandardLocation.SYSTEM_MODULES, mod.getFileName().toString(), Collections.singleton(mod));
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public String getSourceVersion() {
            return this.sourceVersion;
        }

        @Override
        public String getTargetVersion() {
            return this.sourceVersion;
        }

        @Override
        public List<PlatformDescription.PluginInfo<Processor>> getAnnotationProcessors() {
            return Collections.emptyList();
        }

        @Override
        public List<PlatformDescription.PluginInfo<Plugin>> getPlugins() {
            return Collections.emptyList();
        }

        @Override
        public List<String> getAdditionalOptions() {
            return Collections.emptyList();
        }

        @Override
        public void close() throws IOException {
            for (FileSystem fs : this.ctSym2FileSystem.values()) {
                fs.close();
            }
            this.ctSym2FileSystem.clear();
        }

        private static class SigJavaFileObject
        extends ForwardingJavaFileObject<JavaFileObject> {
            public SigJavaFileObject(JavaFileObject fileObject) {
                super(fileObject);
            }

            @Override
            public JavaFileObject.Kind getKind() {
                return JavaFileObject.Kind.CLASS;
            }

            @Override
            public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
                return super.isNameCompatible(simpleName + ".sig", JavaFileObject.Kind.OTHER);
            }

            public JavaFileObject getDelegate() {
                return (JavaFileObject)this.fileObject;
            }
        }
    }
}

