/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder.bound;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.bound.AnnotationMetadata;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.MemberImportIndex;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.TyVarSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.model.TurbineTyKind;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SourceTypeBoundClass
implements TypeBoundClass {
    private final TurbineTyKind kind;
    private final ClassSymbol owner;
    private final ImmutableMap<String, ClassSymbol> children;
    private final int access;
    private final ImmutableMap<String, TyVarSymbol> typeParameters;
    private final ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes;
    private final Type.ClassTy superClassType;
    private final ImmutableList<Type.ClassTy> interfaceTypes;
    private final ImmutableList<TypeBoundClass.MethodInfo> methods;
    private final ImmutableList<TypeBoundClass.FieldInfo> fields;
    private final CompoundScope enclosingScope;
    private final CompoundScope scope;
    private final MemberImportIndex memberImports;
    private final AnnotationMetadata annotationMetadata;
    private final ImmutableList<AnnoInfo> annotations;
    private final SourceFile source;

    public SourceTypeBoundClass(ImmutableList<Type.ClassTy> interfaceTypes, Type.ClassTy superClassType, ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes, int access, ImmutableList<TypeBoundClass.MethodInfo> methods, ImmutableList<TypeBoundClass.FieldInfo> fields, ClassSymbol owner, TurbineTyKind kind, ImmutableMap<String, ClassSymbol> children, ImmutableMap<String, TyVarSymbol> typeParameters, CompoundScope enclosingScope, CompoundScope scope, MemberImportIndex memberImports, AnnotationMetadata annotationMetadata, ImmutableList<AnnoInfo> annotations, SourceFile source) {
        this.interfaceTypes = interfaceTypes;
        this.superClassType = superClassType;
        this.typeParameterTypes = typeParameterTypes;
        this.access = access;
        this.methods = methods;
        this.fields = fields;
        this.owner = owner;
        this.kind = kind;
        this.children = children;
        this.typeParameters = typeParameters;
        this.enclosingScope = enclosingScope;
        this.scope = scope;
        this.memberImports = memberImports;
        this.annotationMetadata = annotationMetadata;
        this.annotations = annotations;
        this.source = source;
    }

    @Override
    public ClassSymbol superclass() {
        return this.superClassType() != null ? this.superClassType().sym() : null;
    }

    @Override
    public ImmutableList<ClassSymbol> interfaces() {
        return ImmutableList.copyOf((Iterable)Iterables.transform(this.interfaceTypes, (Function)new Function<Type.ClassTy, ClassSymbol>(){

            public ClassSymbol apply(Type.ClassTy classTy) {
                return classTy.sym();
            }
        }));
    }

    @Override
    public int access() {
        return this.access;
    }

    @Override
    public TurbineTyKind kind() {
        return this.kind;
    }

    @Override
    public @Nullable ClassSymbol owner() {
        return this.owner;
    }

    @Override
    public ImmutableMap<String, ClassSymbol> children() {
        return this.children;
    }

    @Override
    public ImmutableMap<String, TyVarSymbol> typeParameters() {
        return this.typeParameters;
    }

    public ImmutableList<Type.ClassTy> interfaceTypes() {
        return this.interfaceTypes;
    }

    @Override
    public Type.ClassTy superClassType() {
        return this.superClassType;
    }

    @Override
    public ImmutableList<TypeBoundClass.MethodInfo> methods() {
        return this.methods;
    }

    @Override
    public AnnotationMetadata annotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public ImmutableList<TypeBoundClass.FieldInfo> fields() {
        return this.fields;
    }

    @Override
    public ImmutableMap<TyVarSymbol, TypeBoundClass.TyVarInfo> typeParameterTypes() {
        return this.typeParameterTypes;
    }

    public CompoundScope enclosingScope() {
        return this.enclosingScope;
    }

    public CompoundScope scope() {
        return this.scope;
    }

    public MemberImportIndex memberImports() {
        return this.memberImports;
    }

    public ImmutableList<AnnoInfo> annotations() {
        return this.annotations;
    }

    public SourceFile source() {
        return this.source;
    }
}

