/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.map.impl.BinaryMapSizeEstimator;
import com.hazelcast.map.impl.SizeEstimator;
import com.hazelcast.map.impl.nearcache.NearCacheSizeEstimator;

public final class SizeEstimators {
    private static final SizeEstimator ZERO_SIZE_ESTIMATOR = new ZeroSizeEstimator();

    private SizeEstimators() {
    }

    public static SizeEstimator createMapSizeEstimator(InMemoryFormat inMemoryFormat) {
        if (InMemoryFormat.BINARY.equals((Object)inMemoryFormat)) {
            return new BinaryMapSizeEstimator();
        }
        return ZERO_SIZE_ESTIMATOR;
    }

    public static SizeEstimator createNearCacheSizeEstimator(NearCacheConfig nearCacheConfig) {
        if (nearCacheConfig == null) {
            return ZERO_SIZE_ESTIMATOR;
        }
        InMemoryFormat inMemoryFormat = nearCacheConfig.getInMemoryFormat();
        if (InMemoryFormat.BINARY.equals((Object)inMemoryFormat)) {
            return new NearCacheSizeEstimator();
        }
        return ZERO_SIZE_ESTIMATOR;
    }

    private static class ZeroSizeEstimator
    implements SizeEstimator {
        private ZeroSizeEstimator() {
        }

        @Override
        public long getSize() {
            return 0L;
        }

        @Override
        public void add(long size) {
        }

        public long calculateSize(Object object) {
            return 0L;
        }

        @Override
        public void reset() {
        }
    }
}

