/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.CaseFormat;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;

@BugPattern(name="ConstantField", category=BugPattern.Category.JDK, summary="Field name is CONSTANT_CASE, but field is not static and final", severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class ConstantField
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    public Description matchVariable(VariableTree tree, VisitorState state) {
        Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        if (sym == null || sym.getKind() != ElementKind.FIELD) {
            return Description.NO_MATCH;
        }
        String name = ((Name)sym.getSimpleName()).toString();
        if (sym.isStatic() && sym.getModifiers().contains((Object)Modifier.FINAL)) {
            return this.checkImmutable(tree, state, sym, name);
        }
        if (!name.equals(name.toUpperCase())) {
            return Description.NO_MATCH;
        }
        Description.Builder fixBuilder = this.buildDescription(tree);
        if (ConstantField.canBecomeStaticMember(sym)) {
            fixBuilder.addFix(SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL, Modifier.STATIC}));
        }
        return fixBuilder.addFix((Fix)SuggestedFixes.renameVariable((VariableTree)tree, (String)CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name), (VisitorState)state)).build();
    }

    private static boolean canBecomeStaticMember(Symbol.VarSymbol sym) {
        Symbol.ClassSymbol owningClass = sym.enclClass();
        switch (owningClass.getNestingKind()) {
            case LOCAL: 
            case ANONYMOUS: {
                return false;
            }
        }
        return !owningClass.isInner();
    }

    private Description checkImmutable(VariableTree tree, VisitorState state, Symbol.VarSymbol sym, String name) {
        Type type = sym.type;
        if (type == null) {
            return Description.NO_MATCH;
        }
        switch (name) {
            case "serialVersionUID": {
                return Description.NO_MATCH;
            }
        }
        if (name.toUpperCase().equals(name)) {
            return Description.NO_MATCH;
        }
        if (state.getTypes().unboxedTypeOrType(type).isPrimitive() || ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().stringType, (VisitorState)state) || type.tsym.getKind() == ElementKind.ENUM) {
            String constName = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, name);
            if (constName.startsWith("K_")) {
                constName = constName.substring("K_".length());
            }
            return this.buildDescription(tree).setMessage(String.format("%ss are immutable, field should be named '%s'", sym.type.tsym.getSimpleName(), constName)).addFix((Fix)SuggestedFixes.renameVariable((VariableTree)tree, (String)constName, (VisitorState)state)).build();
        }
        return Description.NO_MATCH;
    }
}

