/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.devtools.build.lib.skyframe.serialization.NotSerializableRuntimeException;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

class JavaSerializableCodec
implements ObjectCodec<Object> {
    JavaSerializableCodec() {
    }

    @Override
    public Class<Object> getEncodedClass() {
        return Object.class;
    }

    @Override
    public void serialize(Object obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        ByteString.Output out = ByteString.newOutput();
        ObjectOutputStream objOut = new ObjectOutputStream((OutputStream)out);
        try {
            objOut.writeObject(obj);
        }
        catch (NotSerializableException e) {
            throw new SerializationException.NoCodecException("Object " + obj + " not serializable", e);
        }
        catch (NotSerializableRuntimeException e) {
            throw new SerializationException.NoCodecException("Object " + obj + " not serializable", e);
        }
        codedOut.writeBytesNoTag(out.toByteString());
    }

    @Override
    public Object deserialize(CodedInputStream codedIn) throws SerializationException, IOException {
        try {
            ByteBuffer buffer = codedIn.readByteBuffer();
            ObjectInputStream objIn = new ObjectInputStream(new ByteArrayInputStream(buffer.array(), buffer.arrayOffset(), buffer.remaining()));
            return objIn.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new SerializationException("Java deserialization failed", e);
        }
    }
}

