/* exception.h - decls for exceptions
 *
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 * 		Author Robert Collins <robert.collins@canonical.com>
 * 
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#ifndef INCLUDE__BUGS__EXCEPTION_H
#define INCLUDE__BUGS__EXCEPTION_H


#include "hackerlab/machine/types.h"
#include "cexcept/talloc_except.h"

/* code is not well defined yet.
 * -1 is reserved for panics
 */
struct exception {
  int code;
  char *msg;
};
/* to extend this, use talloc to identify 
 * types at runtime in your catch block
 */

define_exception_type(struct exception *);

/* global exception context. This is not thread safe:
 * to make it so define it as a macro that uses
 * TLS
 */
extern struct exception_context the_exception_context[1];

static inline struct exception *
exception(int code, char const *msg)
{
  struct exception * foo = talloc(NULL,struct exception);
  foo->code=code;
  foo->msg=talloc_strdup (foo,msg);
  return foo;
}

#endif  /* INCLUDE__BUGS__EXCEPTION_H */
