/* conflict-hangling.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 * Copyright (C) Canonical Limited
 * 	Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__CONFLICT__HANDLING_H
#define INCLUDE__LIBARCH__CONFLICT__HANDLING_H 


#include "libarch/proj-tree-lint.h"
#include "libarch/project-tree.h"



enum arch_conflict_problems
{
  CONFLICTS_NO_LONGER_CONFLICTED = 1,
  CONFLICTS_NOTHING_CHANGED = 2,
  CONFLICTS_FS_PROBLEM = 4,
  CONFLICTS_TREE_PROBLEM = 8,
  CONFLICTS_REMOVED = 16,
};
extern void arch_tree_ensure_no_conflicts (arch_project_tree_t * tree);
extern int  arch_tree_conflicts_exist (arch_project_tree_t * tree);
extern void arch_tree_note_conflicts (arch_project_tree_t * tree,
				      struct arch_apply_changeset_report * r);
extern int arch_tree_clear_conflicts (arch_project_tree_t * tree);
extern int arch_tree_show_conflicts (t_uchar * program_name,
				     arch_project_tree_t * tree,
				     rel_table * output);
extern enum arch_conflict_problems arch_tree_unconflict_files (t_uchar * program_name,
                                                               arch_project_tree_t * tree,
                                                               rel_table filenames);




#endif  /* INCLUDE__LIBARCH__CONFLICT__HANDLING_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (conflict-handling.h)
 */
