/**
 * Provides information based on the programs on your PATH
 */
export default class Executables {
    private executables;
    private constructor();
    /**
     * @param path is expected to to be a ':' separated list of paths.
     */
    static fromPath(path: string): Promise<Executables>;
    /**
     * Find all programs in your PATH
     */
    list(): string[];
    /**
     * Check if the the given {{executable}} exists on the PATH
     */
    isExecutableOnPATH(executable: string): boolean;
}
