/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Occ;
import org.basex.util.InputInfo;

public final class ItemArray
extends XQArray {
    private Value members;

    ItemArray(Value members) {
        super(ArrayType.get(members.type.seqType()));
        this.members = members;
    }

    @Override
    public Value memberAt(long index) {
        return this.members.itemAt(index);
    }

    @Override
    public Iter itemsIter() {
        return this.members.iter();
    }

    @Override
    public Value items(QueryContext qc) {
        return this.members;
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this.members.atomValue(qc, ii);
    }

    @Override
    public long structSize() {
        return this.members.size();
    }

    @Override
    public XQArray putMember(long pos, Value value, QueryContext qc) {
        return this.toTree(qc).putMember(pos, value, qc);
    }

    @Override
    public XQArray insertMember(long pos, Value value, QueryContext qc) {
        return this.toTree(qc).insertMember(pos, value, qc);
    }

    @Override
    public XQArray removeMember(long pos, QueryContext qc) {
        return this.structSize() == 2L ? ItemArray.get(this.members.itemAt(pos == 0L ? 1L : 0L)) : new ItemArray(this.members.removeItem(pos, qc));
    }

    @Override
    protected XQArray subArr(long pos, long length, QueryContext qc) {
        return new ItemArray(this.members.subsequence(pos, length, qc));
    }

    @Override
    public XQArray reverseArray(QueryContext qc) {
        return new ItemArray(this.members.reverse(qc));
    }

    private XQArray toTree(QueryContext qc) {
        ArrayBuilder ab = new ArrayBuilder(qc, Long.MIN_VALUE);
        for (Item member : this.members) {
            ab.add(member);
        }
        return ab.array((ArrayType)this.type);
    }

    @Override
    public Item shrink(QueryContext qc) throws QueryException {
        this.members = this.members.shrink(qc);
        this.type = ArrayType.get(this.members.seqType().with(Occ.EXACTLY_ONE));
        return this;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "entries", this.structSize()), this.members);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("array { ");
        this.members.toString(qs);
        qs.token(" }");
    }
}

