/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.func.fn;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.expr.CmpG;
import org.basex.query.expr.Expr;
import org.basex.query.func.StandardFunc;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Itr;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class FnCompare
extends StandardFunc {
    @Override
    public Item item(QueryContext qc, InputInfo ii) throws QueryException {
        Item value1 = this.arg(0).atomItem(qc, this.info);
        Item value2 = this.arg(1).atomItem(qc, this.info);
        Collation collation = this.toCollation(this.arg(2), qc);
        if (value1 == null || value2 == null) {
            return Empty.VALUE;
        }
        Type type1 = value1.type;
        Type type2 = value2.type;
        if (!CmpG.comparable(type1, type2, false)) {
            throw QueryError.compareError(value1, value2, this.info);
        }
        long diff = value1.compare(value2, collation, true, this.info);
        return Itr.get(diff < 0L ? -1L : (diff > 0L ? 1L : 0L));
    }

    @Override
    protected Expr opt(CompileContext cc) {
        Expr value1 = this.arg(0);
        Expr value2 = this.arg(1);
        SeqType st1 = value1.seqType();
        SeqType st2 = value2.seqType();
        if (st1.zero()) {
            return value1;
        }
        if (st2.zero()) {
            return value2;
        }
        if (st1.oneOrMore() && !st1.mayBeArray() && st2.oneOrMore() && !st2.mayBeArray()) {
            this.exprType.assign(Occ.EXACTLY_ONE);
        }
        return this;
    }
}

