/* baobab-chart.c generated by valac 0.31.1.11-094fd, the Vala compiler
 * generated from baobab-chart.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2006, 2007, 2008  Igalia
 * Copyright (C) 2013  Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 *
 * Authors of the original code:
 *   Felipe Erias <femorandeira@igalia.com>
 *   Pablo Santamaria <psantamaria@igalia.com>
 *   Jacobo Aragunde <jaragunde@igalia.com>
 *   Eduardo Lima <elima@igalia.com>
 *   Mario Sanchez <msanchez@igalia.com>
 *   Miguel Gomez <magomez@igalia.com>
 *   Henrique Ferreiro <hferreiro@igalia.com>
 *   Alejandro Pinheiro <apinheiro@igalia.com>
 *   Carlos Sanmartin <csanmartin@igalia.com>
 *   Alejandro Garcia <alex@igalia.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define BAOBAB_TYPE_CHART_ITEM (baobab_chart_item_get_type ())
#define BAOBAB_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItem))
#define BAOBAB_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))
#define BAOBAB_IS_CHART_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_IS_CHART_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART_ITEM))
#define BAOBAB_CHART_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART_ITEM, BaobabChartItemClass))

typedef struct _BaobabChartItem BaobabChartItem;
typedef struct _BaobabChartItemClass BaobabChartItemClass;
typedef struct _BaobabChartItemPrivate BaobabChartItemPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BaobabParamSpecChartItem BaobabParamSpecChartItem;

#define BAOBAB_TYPE_CHART (baobab_chart_get_type ())
#define BAOBAB_CHART(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_CHART, BaobabChart))
#define BAOBAB_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_CHART, BaobabChartClass))
#define BAOBAB_IS_CHART(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_CHART))
#define BAOBAB_IS_CHART_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_CHART))
#define BAOBAB_CHART_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_CHART, BaobabChartClass))

typedef struct _BaobabChart BaobabChart;
typedef struct _BaobabChartClass BaobabChartClass;
typedef struct _BaobabChartPrivate BaobabChartPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__baobab_chart_item_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__baobab_chart_item_unref0_ (var), NULL)))
#define _gtk_tree_row_reference_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_row_reference_free (var), NULL)))
#define _baobab_chart_item_unref0(var) ((var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL)))
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define __vala_GdkEventMotion_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventMotion_free (var), NULL)))

#define BAOBAB_TYPE_WINDOW (baobab_window_get_type ())
#define BAOBAB_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_WINDOW, BaobabWindow))
#define BAOBAB_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_WINDOW, BaobabWindowClass))
#define BAOBAB_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_WINDOW))
#define BAOBAB_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_WINDOW))
#define BAOBAB_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_WINDOW, BaobabWindowClass))

typedef struct _BaobabWindow BaobabWindow;
typedef struct _BaobabWindowClass BaobabWindowClass;

#define BAOBAB_TYPE_APPLICATION (baobab_application_get_type ())
#define BAOBAB_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplication))
#define BAOBAB_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))
#define BAOBAB_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BAOBAB_TYPE_APPLICATION))
#define BAOBAB_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BAOBAB_TYPE_APPLICATION, BaobabApplicationClass))

typedef struct _BaobabApplication BaobabApplication;
typedef struct _BaobabApplicationClass BaobabApplicationClass;

struct _BaobabChartItem {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BaobabChartItemPrivate * priv;
	gchar* name;
	gchar* size;
	guint depth;
	gdouble rel_start;
	gdouble rel_size;
	GtkTreeIter iter;
	gboolean visible;
	gboolean has_any_child;
	gboolean has_visible_children;
	GdkRectangle rect;
	GList* parent;
};

struct _BaobabChartItemClass {
	GTypeClass parent_class;
	void (*finalize) (BaobabChartItem *self);
};

struct _BaobabParamSpecChartItem {
	GParamSpec parent_instance;
};

struct _BaobabChart {
	GtkDrawingArea parent_instance;
	BaobabChartPrivate * priv;
};

struct _BaobabChartClass {
	GtkDrawingAreaClass parent_class;
	void (*post_draw) (BaobabChart* self, cairo_t* cr);
	void (*draw_item) (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
	void (*calculate_item_geometry) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*is_point_over_item) (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
	void (*get_item_rectangle) (BaobabChart* self, BaobabChartItem* item);
	gboolean (*can_zoom_in) (BaobabChart* self);
	gboolean (*can_zoom_out) (BaobabChart* self);
	BaobabChartItem* (*create_new_chartitem) (BaobabChart* self);
	void (*item_activated) (BaobabChart* self, GtkTreeIter* iter);
};

struct _BaobabChartPrivate {
	guint name_column;
	guint size_column;
	guint info_column;
	guint percentage_column;
	guint valid_column;
	gboolean model_changed;
	GtkMenu* context_menu;
	GList* items;
	guint max_depth_;
	GtkTreeModel* model_;
	GtkTreeRowReference* root_;
	BaobabChartItem* highlighted_item_;
	GSimpleActionGroup* action_group;
};


static gpointer baobab_chart_item_parent_class = NULL;
static gpointer baobab_chart_parent_class = NULL;

gpointer baobab_chart_item_ref (gpointer instance);
void baobab_chart_item_unref (gpointer instance);
GParamSpec* baobab_param_spec_chart_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void baobab_value_set_chart_item (GValue* value, gpointer v_object);
void baobab_value_take_chart_item (GValue* value, gpointer v_object);
gpointer baobab_value_get_chart_item (const GValue* value);
GType baobab_chart_item_get_type (void) G_GNUC_CONST;
enum  {
	BAOBAB_CHART_ITEM_DUMMY_PROPERTY
};
BaobabChartItem* baobab_chart_item_construct (GType object_type);
static void baobab_chart_item_finalize (BaobabChartItem* obj);
GType baobab_chart_get_type (void) G_GNUC_CONST;
#define BAOBAB_CHART_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BAOBAB_TYPE_CHART, BaobabChartPrivate))
enum  {
	BAOBAB_CHART_DUMMY_PROPERTY,
	BAOBAB_CHART_MAX_DEPTH,
	BAOBAB_CHART_MODEL,
	BAOBAB_CHART_ROOT,
	BAOBAB_CHART_HIGHLIGHTED_ITEM
};
static void _baobab_chart_item_unref0_ (gpointer var);
static void _g_list_free__baobab_chart_item_unref0_ (GList* self);
#define BAOBAB_CHART_MAX_DEPTH ((guint) 5)
#define BAOBAB_CHART_MIN_DEPTH ((guint) 1)
void baobab_chart_open_file (BaobabChart* self);
static void _baobab_chart_open_file_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_copy_path (BaobabChart* self);
static void _baobab_chart_copy_path_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_trash_file (BaobabChart* self);
static void _baobab_chart_trash_file_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_move_up_root (BaobabChart* self);
static void _baobab_chart_move_up_root_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_zoom_in (BaobabChart* self);
static void _baobab_chart_zoom_in_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_zoom_out (BaobabChart* self);
static void _baobab_chart_zoom_out_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
void baobab_chart_set_model_with_columns (BaobabChart* self, GtkTreeModel* m, guint name_column_, guint size_column_, guint info_column_, guint percentage_column_, guint valid_column_, GtkTreePath* r);
void baobab_chart_set_model (BaobabChart* self, GtkTreeModel* value);
void baobab_chart_set_root (BaobabChart* self, GtkTreePath* value);
void baobab_chart_post_draw (BaobabChart* self, cairo_t* cr);
static void baobab_chart_real_post_draw (BaobabChart* self, cairo_t* cr);
void baobab_chart_draw_item (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
static void baobab_chart_real_draw_item (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted);
void baobab_chart_calculate_item_geometry (BaobabChart* self, BaobabChartItem* item);
static void baobab_chart_real_calculate_item_geometry (BaobabChart* self, BaobabChartItem* item);
gboolean baobab_chart_is_point_over_item (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
static gboolean baobab_chart_real_is_point_over_item (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y);
void baobab_chart_get_item_rectangle (BaobabChart* self, BaobabChartItem* item);
static void baobab_chart_real_get_item_rectangle (BaobabChart* self, BaobabChartItem* item);
gboolean baobab_chart_can_zoom_in (BaobabChart* self);
static gboolean baobab_chart_real_can_zoom_in (BaobabChart* self);
gboolean baobab_chart_can_zoom_out (BaobabChart* self);
static gboolean baobab_chart_real_can_zoom_out (BaobabChart* self);
BaobabChartItem* baobab_chart_create_new_chartitem (BaobabChart* self);
static BaobabChartItem* baobab_chart_real_create_new_chartitem (BaobabChart* self);
static void baobab_chart_real_size_allocate (GtkWidget* base, GtkAllocation* allocation);
static gboolean baobab_chart_highlight_item_at_point (BaobabChart* self, gdouble x, gdouble y);
void baobab_chart_set_highlighted_item (BaobabChart* self, BaobabChartItem* value);
static gboolean baobab_chart_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean baobab_chart_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* event);
static GList* baobab_chart_add_item (BaobabChart* self, guint depth, gdouble rel_start, gdouble rel_size, GtkTreeIter* iter);
GtkTreeModel* baobab_chart_get_model (BaobabChart* self);
static void baobab_chart_get_items (BaobabChart* self, GtkTreePath* root_path);
guint baobab_chart_get_max_depth (BaobabChart* self);
static void baobab_chart_draw_chart (BaobabChart* self, cairo_t* cr);
BaobabChartItem* baobab_chart_get_highlighted_item (BaobabChart* self);
static void baobab_chart_update_draw (BaobabChart* self, GtkTreePath* path);
GtkTreePath* baobab_chart_get_root (BaobabChart* self);
static void baobab_chart_row_changed (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void baobab_chart_row_inserted (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void baobab_chart_row_deleted (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path);
static void baobab_chart_row_has_child_toggled (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter);
static void baobab_chart_rows_reordered (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, void* new_order);
static gboolean baobab_chart_real_draw (GtkWidget* base, cairo_t* cr);
static void baobab_chart_interpolate_colors (BaobabChart* self, GdkRGBA* colora, GdkRGBA* colorb, gdouble percentage, GdkRGBA* result);
void baobab_chart_get_item_color (BaobabChart* self, gdouble rel_position, guint depth, gboolean highlighted, GdkRGBA* result);
static gboolean baobab_chart_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void baobab_chart_show_popup_menu (BaobabChart* self, GdkEventButton* event);
static gboolean baobab_chart_real_scroll_event (GtkWidget* base, GdkEventScroll* event);
static GdkEventMotion* _vala_GdkEventMotion_copy (GdkEventMotion* self);
static void _vala_GdkEventMotion_free (GdkEventMotion* self);
GType baobab_window_get_type (void) G_GNUC_CONST;
void baobab_window_open_item (BaobabWindow* self, GtkTreeIter* iter);
void baobab_window_copy_path (BaobabWindow* self, GtkTreeIter* iter);
void baobab_window_trash_file (BaobabWindow* self, GtkTreeIter* iter);
gboolean baobab_chart_can_move_up_root (BaobabChart* self);
void baobab_chart_set_max_depth (BaobabChart* self, guint value);
static void baobab_chart_build_context_menu (BaobabChart* self);
GType baobab_application_get_type (void) G_GNUC_CONST;
BaobabApplication* baobab_application_get_default (void);
static void baobab_chart_connect_model_signals (BaobabChart* self, GtkTreeModel* m);
static void _baobab_chart_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void _baobab_chart_row_inserted_gtk_tree_model_row_inserted (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void _baobab_chart_row_deleted_gtk_tree_model_row_deleted (GtkTreeModel* _sender, GtkTreePath* path, gpointer self);
static void _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gint* new_order, gpointer self);
static void baobab_chart_disconnect_model_signals (BaobabChart* self, GtkTreeModel* m);
static gboolean baobab_chart_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip);
BaobabChart* baobab_chart_construct (GType object_type);
static void baobab_chart_real_item_activated (BaobabChart* self, GtkTreeIter* iter);
static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * baobab_chart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void baobab_chart_finalize (GObject* obj);
static void _vala_baobab_chart_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_baobab_chart_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GdkRGBA BAOBAB_CHART_TANGO_COLORS[6] = {{0.94, 0.16, 0.16, 1.0}, {0.68, 0.49, 0.66, 1.0}, {0.45, 0.62, 0.82, 1.0}, {0.54, 0.89, 0.20, 1.0}, {0.91, 0.73, 0.43, 1.0}, {0.99, 0.68, 0.25, 1.0}};
static const GActionEntry BAOBAB_CHART_action_entries[6] = {{"open-file", _baobab_chart_open_file_gsimple_action_activate_callback}, {"copy-path", _baobab_chart_copy_path_gsimple_action_activate_callback}, {"trash-file", _baobab_chart_trash_file_gsimple_action_activate_callback}, {"move-up", _baobab_chart_move_up_root_gsimple_action_activate_callback}, {"zoom-in", _baobab_chart_zoom_in_gsimple_action_activate_callback}, {"zoom-out", _baobab_chart_zoom_out_gsimple_action_activate_callback}};

BaobabChartItem* baobab_chart_item_construct (GType object_type) {
	BaobabChartItem* self = NULL;
	self = (BaobabChartItem*) g_type_create_instance (object_type);
	return self;
}


static void baobab_value_chart_item_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void baobab_value_chart_item_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		baobab_chart_item_unref (value->data[0].v_pointer);
	}
}


static void baobab_value_chart_item_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = baobab_chart_item_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer baobab_value_chart_item_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* baobab_value_chart_item_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BaobabChartItem* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = baobab_chart_item_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* baobab_value_chart_item_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BaobabChartItem** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = baobab_chart_item_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* baobab_param_spec_chart_item (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BaobabParamSpecChartItem* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BAOBAB_TYPE_CHART_ITEM), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer baobab_value_get_chart_item (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM), NULL);
	return value->data[0].v_pointer;
}


void baobab_value_set_chart_item (GValue* value, gpointer v_object) {
	BaobabChartItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_CHART_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		baobab_chart_item_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_chart_item_unref (old);
	}
}


void baobab_value_take_chart_item (GValue* value, gpointer v_object) {
	BaobabChartItem* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BAOBAB_TYPE_CHART_ITEM));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BAOBAB_TYPE_CHART_ITEM));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		baobab_chart_item_unref (old);
	}
}


static void baobab_chart_item_class_init (BaobabChartItemClass * klass) {
	baobab_chart_item_parent_class = g_type_class_peek_parent (klass);
	((BaobabChartItemClass *) klass)->finalize = baobab_chart_item_finalize;
}


static void baobab_chart_item_instance_init (BaobabChartItem * self) {
	self->ref_count = 1;
}


static void baobab_chart_item_finalize (BaobabChartItem* obj) {
	BaobabChartItem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART_ITEM, BaobabChartItem);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->size);
}


GType baobab_chart_item_get_type (void) {
	static volatile gsize baobab_chart_item_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_chart_item_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { baobab_value_chart_item_init, baobab_value_chart_item_free_value, baobab_value_chart_item_copy_value, baobab_value_chart_item_peek_pointer, "p", baobab_value_chart_item_collect_value, "p", baobab_value_chart_item_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BaobabChartItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_chart_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabChartItem), 0, (GInstanceInitFunc) baobab_chart_item_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType baobab_chart_item_type_id;
		baobab_chart_item_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BaobabChartItem", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&baobab_chart_item_type_id__volatile, baobab_chart_item_type_id);
	}
	return baobab_chart_item_type_id__volatile;
}


gpointer baobab_chart_item_ref (gpointer instance) {
	BaobabChartItem* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void baobab_chart_item_unref (gpointer instance) {
	BaobabChartItem* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BAOBAB_CHART_ITEM_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _baobab_chart_item_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (baobab_chart_item_unref (var), NULL));
}


static void _g_list_free__baobab_chart_item_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _baobab_chart_item_unref0_, NULL);
	g_list_free (self);
}


static void _baobab_chart_open_file_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_open_file ((BaobabChart*) self);
}


static void _baobab_chart_copy_path_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_copy_path ((BaobabChart*) self);
}


static void _baobab_chart_trash_file_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_trash_file ((BaobabChart*) self);
}


static void _baobab_chart_move_up_root_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_move_up_root ((BaobabChart*) self);
}


static void _baobab_chart_zoom_in_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_zoom_in ((BaobabChart*) self);
}


static void _baobab_chart_zoom_out_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	baobab_chart_zoom_out ((BaobabChart*) self);
}


void baobab_chart_set_model_with_columns (BaobabChart* self, GtkTreeModel* m, guint name_column_, guint size_column_, guint info_column_, guint percentage_column_, guint valid_column_, GtkTreePath* r) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreePath* _tmp1_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	baobab_chart_set_model (self, _tmp0_);
	_tmp1_ = r;
	if (_tmp1_ != NULL) {
		GtkTreePath* _tmp2_ = NULL;
		_tmp2_ = r;
		baobab_chart_set_root (self, _tmp2_);
	}
	_tmp3_ = name_column_;
	self->priv->name_column = _tmp3_;
	_tmp4_ = size_column_;
	self->priv->size_column = _tmp4_;
	_tmp5_ = info_column_;
	self->priv->info_column = _tmp5_;
	_tmp6_ = percentage_column_;
	self->priv->percentage_column = _tmp6_;
	_tmp7_ = valid_column_;
	self->priv->valid_column = _tmp7_;
}


static void baobab_chart_real_post_draw (BaobabChart* self, cairo_t* cr) {
	g_return_if_fail (cr != NULL);
}


void baobab_chart_post_draw (BaobabChart* self, cairo_t* cr) {
	g_return_if_fail (self != NULL);
	BAOBAB_CHART_GET_CLASS (self)->post_draw (self, cr);
}


static void baobab_chart_real_draw_item (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_draw_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void baobab_chart_draw_item (BaobabChart* self, cairo_t* cr, BaobabChartItem* item, gboolean highlighted) {
	g_return_if_fail (self != NULL);
	BAOBAB_CHART_GET_CLASS (self)->draw_item (self, cr, item, highlighted);
}


static void baobab_chart_real_calculate_item_geometry (BaobabChart* self, BaobabChartItem* item) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_calculate_item_geometry'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void baobab_chart_calculate_item_geometry (BaobabChart* self, BaobabChartItem* item) {
	g_return_if_fail (self != NULL);
	BAOBAB_CHART_GET_CLASS (self)->calculate_item_geometry (self, item);
}


static gboolean baobab_chart_real_is_point_over_item (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_is_point_over_item'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean baobab_chart_is_point_over_item (BaobabChart* self, BaobabChartItem* item, gdouble x, gdouble y) {
	g_return_val_if_fail (self != NULL, FALSE);
	return BAOBAB_CHART_GET_CLASS (self)->is_point_over_item (self, item, x, y);
}


static void baobab_chart_real_get_item_rectangle (BaobabChart* self, BaobabChartItem* item) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_get_item_rectangle'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void baobab_chart_get_item_rectangle (BaobabChart* self, BaobabChartItem* item) {
	g_return_if_fail (self != NULL);
	BAOBAB_CHART_GET_CLASS (self)->get_item_rectangle (self, item);
}


static gboolean baobab_chart_real_can_zoom_in (BaobabChart* self) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_can_zoom_in'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean baobab_chart_can_zoom_in (BaobabChart* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return BAOBAB_CHART_GET_CLASS (self)->can_zoom_in (self);
}


static gboolean baobab_chart_real_can_zoom_out (BaobabChart* self) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_can_zoom_out'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean baobab_chart_can_zoom_out (BaobabChart* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return BAOBAB_CHART_GET_CLASS (self)->can_zoom_out (self);
}


static BaobabChartItem* baobab_chart_real_create_new_chartitem (BaobabChart* self) {
	g_critical ("Type `%s' does not implement abstract method `baobab_chart_create_new_chartitem'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


BaobabChartItem* baobab_chart_create_new_chartitem (BaobabChart* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return BAOBAB_CHART_GET_CLASS (self)->create_new_chartitem (self);
}


static gpointer _baobab_chart_item_ref0 (gpointer self) {
	return self ? baobab_chart_item_ref (self) : NULL;
}


static void baobab_chart_real_size_allocate (GtkWidget* base, GtkAllocation* allocation) {
	BaobabChart * self;
	GtkAllocation _tmp0_ = {0};
	GList* _tmp1_ = NULL;
	self = (BaobabChart*) base;
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	GTK_WIDGET_CLASS (baobab_chart_parent_class)->size_allocate ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_drawing_area_get_type (), GtkDrawingArea), &_tmp0_);
	_tmp1_ = self->priv->items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp1_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp2_ = NULL;
			BaobabChartItem* item = NULL;
			_tmp2_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp2_;
			{
				BaobabChartItem* _tmp3_ = NULL;
				BaobabChartItem* _tmp4_ = NULL;
				BaobabChartItem* _tmp5_ = NULL;
				_tmp3_ = item;
				_tmp3_->has_visible_children = FALSE;
				_tmp4_ = item;
				_tmp4_->visible = FALSE;
				_tmp5_ = item;
				baobab_chart_calculate_item_geometry (self, _tmp5_);
				_baobab_chart_item_unref0 (item);
			}
		}
	}
}


static gboolean baobab_chart_highlight_item_at_point (BaobabChart* self, gdouble x, gdouble y) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		GList* node = NULL;
		GList* _tmp0_ = NULL;
		GList* _tmp1_ = NULL;
		_tmp0_ = self->priv->items;
		_tmp1_ = g_list_last (_tmp0_);
		node = _tmp1_;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GList* _tmp5_ = NULL;
				BaobabChartItem* item = NULL;
				GList* _tmp6_ = NULL;
				gconstpointer _tmp7_ = NULL;
				BaobabChartItem* _tmp8_ = NULL;
				gboolean _tmp9_ = FALSE;
				BaobabChartItem* _tmp10_ = NULL;
				gboolean _tmp11_ = FALSE;
				if (!_tmp2_) {
					GList* _tmp3_ = NULL;
					GList* _tmp4_ = NULL;
					_tmp3_ = node;
					_tmp4_ = _tmp3_->prev;
					node = _tmp4_;
				}
				_tmp2_ = FALSE;
				_tmp5_ = node;
				if (!(_tmp5_ != NULL)) {
					break;
				}
				_tmp6_ = node;
				_tmp7_ = _tmp6_->data;
				_tmp8_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp7_);
				item = _tmp8_;
				_tmp10_ = item;
				_tmp11_ = _tmp10_->visible;
				if (_tmp11_) {
					BaobabChartItem* _tmp12_ = NULL;
					gdouble _tmp13_ = 0.0;
					gdouble _tmp14_ = 0.0;
					gboolean _tmp15_ = FALSE;
					_tmp12_ = item;
					_tmp13_ = x;
					_tmp14_ = y;
					_tmp15_ = baobab_chart_is_point_over_item (self, _tmp12_, _tmp13_, _tmp14_);
					_tmp9_ = _tmp15_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					BaobabChartItem* _tmp16_ = NULL;
					_tmp16_ = item;
					baobab_chart_set_highlighted_item (self, _tmp16_);
					result = TRUE;
					_baobab_chart_item_unref0 (item);
					return result;
				}
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	baobab_chart_set_highlighted_item (self, NULL);
	result = FALSE;
	return result;
}


static gboolean baobab_chart_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	BaobabChart * self;
	gboolean result = FALSE;
	GdkEventMotion* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GdkEventMotion* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	gboolean _tmp4_ = FALSE;
	GdkEventMotion* _tmp5_ = NULL;
	self = (BaobabChart*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->x;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->y;
	_tmp4_ = baobab_chart_highlight_item_at_point (self, _tmp1_, _tmp3_);
	gtk_widget_set_has_tooltip ((GtkWidget*) self, _tmp4_);
	_tmp5_ = event;
	gdk_event_request_motions (_tmp5_);
	result = FALSE;
	return result;
}


static gboolean baobab_chart_real_leave_notify_event (GtkWidget* base, GdkEventCrossing* event) {
	BaobabChart * self;
	gboolean result = FALSE;
	GtkMenu* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = (BaobabChart*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->context_menu;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		baobab_chart_set_highlighted_item (self, NULL);
	}
	result = FALSE;
	return result;
}


static GList* baobab_chart_add_item (BaobabChart* self, guint depth, gdouble rel_start, gdouble rel_size, GtkTreeIter* iter) {
	GList* result = NULL;
	gchar* name = NULL;
	guint64 size = 0ULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	BaobabChartItem* item = NULL;
	BaobabChartItem* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	GtkTreeIter _tmp11_ = {0};
	BaobabChartItem* _tmp12_ = NULL;
	GList* ret = NULL;
	GList* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *iter;
	_tmp3_ = self->priv->name_column;
	_tmp4_ = self->priv->size_column;
	gtk_tree_model_get (_tmp1_, &_tmp2_, _tmp3_, &name, _tmp4_, &size, -1, -1);
	_tmp5_ = baobab_chart_create_new_chartitem (self);
	item = _tmp5_;
	_tmp6_ = g_strdup (name);
	_g_free0 (item->name);
	item->name = _tmp6_;
	_tmp7_ = g_format_size_full (size, G_FORMAT_SIZE_DEFAULT);
	_g_free0 (item->size);
	item->size = _tmp7_;
	_tmp8_ = depth;
	item->depth = _tmp8_;
	_tmp9_ = rel_start;
	item->rel_start = _tmp9_;
	_tmp10_ = rel_size;
	item->rel_size = _tmp10_;
	item->has_any_child = FALSE;
	item->visible = FALSE;
	item->has_visible_children = FALSE;
	_tmp11_ = *iter;
	item->iter = _tmp11_;
	item->parent = NULL;
	_tmp12_ = _baobab_chart_item_ref0 (item);
	self->priv->items = g_list_prepend (self->priv->items, _tmp12_);
	_tmp13_ = self->priv->items;
	ret = _tmp13_;
	result = ret;
	_baobab_chart_item_unref0 (item);
	_g_free0 (name);
	return result;
}


static void baobab_chart_get_items (BaobabChart* self, GtkTreePath* root_path) {
	GList* node = NULL;
	GtkTreeIter initial_iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gdouble size = 0.0;
	GtkTreePath* model_root_path = NULL;
	GtkTreeIter model_root_iter = {0};
	GtkTreeIter child_iter = {0};
	GtkTreeIter _tmp1_ = {0};
	GList* child_node = NULL;
	gdouble rel_start = 0.0;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	GtkTreePath* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeModel* _tmp9_ = NULL;
	GtkTreePath* _tmp10_ = NULL;
	GtkTreeIter _tmp11_ = {0};
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeModel* _tmp13_ = NULL;
	GtkTreeIter _tmp14_ = {0};
	guint _tmp15_ = 0U;
	GtkTreeIter _tmp16_ = {0};
	GList* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root_path != NULL);
	node = NULL;
	_tmp0_.stamp = 0;
	initial_iter = _tmp0_;
	_tmp1_.stamp = 0;
	child_iter = _tmp1_;
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->items);
	self->priv->items = NULL;
	_tmp2_ = baobab_chart_get_model (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = root_path;
	_tmp6_ = gtk_tree_model_get_iter (_tmp3_, &_tmp5_, _tmp4_);
	initial_iter = _tmp5_;
	if (!_tmp6_) {
		self->priv->model_changed = FALSE;
		_gtk_tree_path_free0 (model_root_path);
		return;
	}
	_tmp7_ = gtk_tree_path_new_first ();
	_gtk_tree_path_free0 (model_root_path);
	model_root_path = _tmp7_;
	_tmp8_ = baobab_chart_get_model (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = model_root_path;
	gtk_tree_model_get_iter (_tmp9_, &_tmp11_, _tmp10_);
	model_root_iter = _tmp11_;
	_tmp12_ = baobab_chart_get_model (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = model_root_iter;
	_tmp15_ = self->priv->percentage_column;
	gtk_tree_model_get (_tmp13_, &_tmp14_, _tmp15_, &size, -1, -1);
	_tmp16_ = initial_iter;
	_tmp17_ = baobab_chart_add_item (self, (guint) 0, (gdouble) 0, (gdouble) 100, &_tmp16_);
	node = _tmp17_;
	{
		gboolean _tmp18_ = FALSE;
		_tmp18_ = TRUE;
		while (TRUE) {
			BaobabChartItem* item = NULL;
			GList* _tmp20_ = NULL;
			gconstpointer _tmp21_ = NULL;
			BaobabChartItem* _tmp22_ = NULL;
			BaobabChartItem* _tmp23_ = NULL;
			GtkTreeModel* _tmp24_ = NULL;
			GtkTreeModel* _tmp25_ = NULL;
			BaobabChartItem* _tmp26_ = NULL;
			GtkTreeIter _tmp27_ = {0};
			GtkTreeIter _tmp28_ = {0};
			gboolean _tmp29_ = FALSE;
			BaobabChartItem* _tmp30_ = NULL;
			BaobabChartItem* _tmp31_ = NULL;
			gboolean _tmp32_ = FALSE;
			gboolean _tmp35_ = FALSE;
			BaobabChartItem* _tmp36_ = NULL;
			gboolean _tmp37_ = FALSE;
			GList* _tmp63_ = NULL;
			GList* _tmp64_ = NULL;
			if (!_tmp18_) {
				GList* _tmp19_ = NULL;
				_tmp19_ = node;
				if (!(_tmp19_ != NULL)) {
					break;
				}
			}
			_tmp18_ = FALSE;
			_tmp20_ = node;
			_tmp21_ = _tmp20_->data;
			_tmp22_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp21_);
			item = _tmp22_;
			_tmp23_ = item;
			_tmp24_ = baobab_chart_get_model (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = item;
			_tmp27_ = _tmp26_->iter;
			_tmp29_ = gtk_tree_model_iter_children (_tmp25_, &_tmp28_, &_tmp27_);
			child_iter = _tmp28_;
			_tmp23_->has_any_child = _tmp29_;
			_tmp30_ = item;
			baobab_chart_calculate_item_geometry (self, _tmp30_);
			_tmp31_ = item;
			_tmp32_ = _tmp31_->visible;
			if (!_tmp32_) {
				GList* _tmp33_ = NULL;
				GList* _tmp34_ = NULL;
				_tmp33_ = node;
				_tmp34_ = _tmp33_->prev;
				node = _tmp34_;
				_baobab_chart_item_unref0 (item);
				continue;
			}
			_tmp36_ = item;
			_tmp37_ = _tmp36_->has_any_child;
			if (_tmp37_) {
				BaobabChartItem* _tmp38_ = NULL;
				guint _tmp39_ = 0U;
				guint _tmp40_ = 0U;
				guint _tmp41_ = 0U;
				_tmp38_ = item;
				_tmp39_ = _tmp38_->depth;
				_tmp40_ = baobab_chart_get_max_depth (self);
				_tmp41_ = _tmp40_;
				_tmp35_ = _tmp39_ < (_tmp41_ + 1);
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				rel_start = (gdouble) 0;
				{
					gboolean _tmp42_ = FALSE;
					_tmp42_ = TRUE;
					while (TRUE) {
						GtkTreeModel* _tmp46_ = NULL;
						GtkTreeModel* _tmp47_ = NULL;
						GtkTreeIter _tmp48_ = {0};
						guint _tmp49_ = 0U;
						BaobabChartItem* _tmp50_ = NULL;
						guint _tmp51_ = 0U;
						gdouble _tmp52_ = 0.0;
						gdouble _tmp53_ = 0.0;
						GtkTreeIter _tmp54_ = {0};
						GList* _tmp55_ = NULL;
						BaobabChartItem* child = NULL;
						GList* _tmp56_ = NULL;
						gconstpointer _tmp57_ = NULL;
						BaobabChartItem* _tmp58_ = NULL;
						BaobabChartItem* _tmp59_ = NULL;
						GList* _tmp60_ = NULL;
						gdouble _tmp61_ = 0.0;
						gdouble _tmp62_ = 0.0;
						if (!_tmp42_) {
							GtkTreeModel* _tmp43_ = NULL;
							GtkTreeModel* _tmp44_ = NULL;
							gboolean _tmp45_ = FALSE;
							_tmp43_ = baobab_chart_get_model (self);
							_tmp44_ = _tmp43_;
							_tmp45_ = gtk_tree_model_iter_next (_tmp44_, &child_iter);
							if (!_tmp45_) {
								break;
							}
						}
						_tmp42_ = FALSE;
						_tmp46_ = baobab_chart_get_model (self);
						_tmp47_ = _tmp46_;
						_tmp48_ = child_iter;
						_tmp49_ = self->priv->percentage_column;
						gtk_tree_model_get (_tmp47_, &_tmp48_, _tmp49_, &size, -1, -1);
						_tmp50_ = item;
						_tmp51_ = _tmp50_->depth;
						_tmp52_ = rel_start;
						_tmp53_ = size;
						_tmp54_ = child_iter;
						_tmp55_ = baobab_chart_add_item (self, _tmp51_ + 1, _tmp52_, _tmp53_, &_tmp54_);
						child_node = _tmp55_;
						_tmp56_ = child_node;
						_tmp57_ = _tmp56_->data;
						_tmp58_ = _baobab_chart_item_ref0 ((BaobabChartItem*) _tmp57_);
						child = _tmp58_;
						_tmp59_ = child;
						_tmp60_ = node;
						_tmp59_->parent = _tmp60_;
						_tmp61_ = rel_start;
						_tmp62_ = size;
						rel_start = _tmp61_ + _tmp62_;
						_baobab_chart_item_unref0 (child);
					}
				}
			}
			_tmp63_ = node;
			_tmp64_ = _tmp63_->prev;
			node = _tmp64_;
			_baobab_chart_item_unref0 (item);
		}
	}
	self->priv->items = g_list_reverse (self->priv->items);
	self->priv->model_changed = FALSE;
	_gtk_tree_path_free0 (model_root_path);
}


static void baobab_chart_draw_chart (BaobabChart* self, cairo_t* cr) {
	cairo_t* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	cairo_t* _tmp24_ = NULL;
	cairo_t* _tmp25_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = cr;
	cairo_save (_tmp0_);
	_tmp1_ = self->priv->items;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp1_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			BaobabChartItem* _tmp2_ = NULL;
			BaobabChartItem* item = NULL;
			_tmp2_ = _baobab_chart_item_ref0 ((BaobabChartItem*) item_it->data);
			item = _tmp2_;
			{
				GdkRectangle clip = {0};
				gboolean _tmp3_ = FALSE;
				gboolean _tmp4_ = FALSE;
				gboolean _tmp5_ = FALSE;
				cairo_t* _tmp6_ = NULL;
				GdkRectangle _tmp7_ = {0};
				gboolean _tmp8_ = FALSE;
				_tmp6_ = cr;
				_tmp8_ = gdk_cairo_get_clip_rectangle (_tmp6_, &_tmp7_);
				clip = _tmp7_;
				if (_tmp8_) {
					BaobabChartItem* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = item;
					_tmp10_ = _tmp9_->visible;
					_tmp5_ = _tmp10_;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					BaobabChartItem* _tmp11_ = NULL;
					GdkRectangle _tmp12_ = {0};
					gboolean _tmp13_ = FALSE;
					_tmp11_ = item;
					_tmp12_ = _tmp11_->rect;
					_tmp13_ = gdk_rectangle_intersect (&clip, &_tmp12_, NULL);
					_tmp4_ = _tmp13_;
				} else {
					_tmp4_ = FALSE;
				}
				if (_tmp4_) {
					BaobabChartItem* _tmp14_ = NULL;
					guint _tmp15_ = 0U;
					guint _tmp16_ = 0U;
					guint _tmp17_ = 0U;
					_tmp14_ = item;
					_tmp15_ = _tmp14_->depth;
					_tmp16_ = baobab_chart_get_max_depth (self);
					_tmp17_ = _tmp16_;
					_tmp3_ = _tmp15_ <= _tmp17_;
				} else {
					_tmp3_ = FALSE;
				}
				if (_tmp3_) {
					gboolean highlighted = FALSE;
					BaobabChartItem* _tmp18_ = NULL;
					BaobabChartItem* _tmp19_ = NULL;
					BaobabChartItem* _tmp20_ = NULL;
					cairo_t* _tmp21_ = NULL;
					BaobabChartItem* _tmp22_ = NULL;
					gboolean _tmp23_ = FALSE;
					_tmp18_ = item;
					_tmp19_ = baobab_chart_get_highlighted_item (self);
					_tmp20_ = _tmp19_;
					highlighted = _tmp18_ == _tmp20_;
					_tmp21_ = cr;
					_tmp22_ = item;
					_tmp23_ = highlighted;
					baobab_chart_draw_item (self, _tmp21_, _tmp22_, _tmp23_);
				}
				_baobab_chart_item_unref0 (item);
			}
		}
	}
	_tmp24_ = cr;
	cairo_restore (_tmp24_);
	_tmp25_ = cr;
	baobab_chart_post_draw (self, _tmp25_);
}


static void baobab_chart_update_draw (BaobabChart* self, GtkTreePath* path) {
	gboolean _tmp0_ = FALSE;
	gint root_depth = 0;
	GtkTreePath* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint node_depth = 0;
	GtkTreePath* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = gtk_widget_get_realized ((GtkWidget*) self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = baobab_chart_get_root (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_tree_path_get_depth (_tmp3_);
	_tmp5_ = _tmp4_;
	_gtk_tree_path_free0 (_tmp3_);
	root_depth = _tmp5_;
	_tmp6_ = path;
	_tmp7_ = gtk_tree_path_get_depth (_tmp6_);
	node_depth = _tmp7_;
	_tmp9_ = node_depth;
	_tmp10_ = root_depth;
	_tmp11_ = baobab_chart_get_max_depth (self);
	_tmp12_ = _tmp11_;
	if (((guint) (_tmp9_ - _tmp10_)) <= _tmp12_) {
		gboolean _tmp13_ = FALSE;
		GtkTreePath* _tmp14_ = NULL;
		GtkTreePath* _tmp15_ = NULL;
		GtkTreePath* _tmp16_ = NULL;
		GtkTreePath* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp14_ = baobab_chart_get_root (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = path;
		_tmp18_ = gtk_tree_path_is_ancestor (_tmp16_, _tmp17_);
		_tmp19_ = _tmp18_;
		_gtk_tree_path_free0 (_tmp16_);
		if (_tmp19_) {
			_tmp13_ = TRUE;
		} else {
			GtkTreePath* _tmp20_ = NULL;
			GtkTreePath* _tmp21_ = NULL;
			GtkTreePath* _tmp22_ = NULL;
			GtkTreePath* _tmp23_ = NULL;
			gint _tmp24_ = 0;
			_tmp20_ = baobab_chart_get_root (self);
			_tmp21_ = _tmp20_;
			_tmp22_ = _tmp21_;
			_tmp23_ = path;
			_tmp24_ = gtk_tree_path_compare (_tmp22_, _tmp23_);
			_tmp13_ = _tmp24_ == 0;
			_gtk_tree_path_free0 (_tmp22_);
		}
		_tmp8_ = _tmp13_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
}


static void baobab_chart_row_changed (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static void baobab_chart_row_inserted (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static void baobab_chart_row_deleted (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static void baobab_chart_row_has_child_toggled (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (iter != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static void baobab_chart_rows_reordered (BaobabChart* self, GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, void* new_order) {
	GtkTreePath* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (path != NULL);
	self->priv->model_changed = TRUE;
	_tmp0_ = path;
	baobab_chart_update_draw (self, _tmp0_);
}


static gboolean baobab_chart_real_draw (GtkWidget* base, cairo_t* cr) {
	BaobabChart * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	self = (BaobabChart*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->name_column;
	_tmp1_ = self->priv->percentage_column;
	if (_tmp0_ == _tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = baobab_chart_get_model (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		cairo_t* _tmp25_ = NULL;
		_tmp5_ = self->priv->model_changed;
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			GList* _tmp6_ = NULL;
			_tmp6_ = self->priv->items;
			_tmp4_ = _tmp6_ == NULL;
		}
		if (_tmp4_) {
			GtkTreePath* _tmp7_ = NULL;
			GtkTreePath* _tmp8_ = NULL;
			GtkTreePath* _tmp9_ = NULL;
			_tmp7_ = baobab_chart_get_root (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = _tmp8_;
			baobab_chart_get_items (self, _tmp9_);
			_gtk_tree_path_free0 (_tmp9_);
		} else {
			GtkTreePath* current_path = NULL;
			GtkTreeModel* _tmp10_ = NULL;
			GtkTreeModel* _tmp11_ = NULL;
			GList* _tmp12_ = NULL;
			gconstpointer _tmp13_ = NULL;
			GtkTreeIter _tmp14_ = {0};
			GtkTreePath* _tmp15_ = NULL;
			GtkTreePath* _tmp16_ = NULL;
			GtkTreePath* _tmp17_ = NULL;
			GtkTreePath* _tmp18_ = NULL;
			GtkTreePath* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gboolean _tmp21_ = FALSE;
			_tmp10_ = baobab_chart_get_model (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = self->priv->items;
			_tmp13_ = _tmp12_->data;
			_tmp14_ = ((BaobabChartItem*) _tmp13_)->iter;
			_tmp15_ = gtk_tree_model_get_path (_tmp11_, &_tmp14_);
			current_path = _tmp15_;
			_tmp16_ = baobab_chart_get_root (self);
			_tmp17_ = _tmp16_;
			_tmp18_ = _tmp17_;
			_tmp19_ = current_path;
			_tmp20_ = gtk_tree_path_compare (_tmp18_, _tmp19_);
			_tmp21_ = _tmp20_ != 0;
			_gtk_tree_path_free0 (_tmp18_);
			if (_tmp21_) {
				GtkTreePath* _tmp22_ = NULL;
				GtkTreePath* _tmp23_ = NULL;
				GtkTreePath* _tmp24_ = NULL;
				_tmp22_ = baobab_chart_get_root (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = _tmp23_;
				baobab_chart_get_items (self, _tmp24_);
				_gtk_tree_path_free0 (_tmp24_);
			}
			_gtk_tree_path_free0 (current_path);
		}
		_tmp25_ = cr;
		baobab_chart_draw_chart (self, _tmp25_);
	}
	result = FALSE;
	return result;
}


static void baobab_chart_interpolate_colors (BaobabChart* self, GdkRGBA* colora, GdkRGBA* colorb, gdouble percentage, GdkRGBA* result) {
	GdkRGBA color = {0};
	gdouble diff = 0.0;
	GdkRGBA _tmp0_ = {0};
	gdouble _tmp1_ = 0.0;
	GdkRGBA _tmp2_ = {0};
	gdouble _tmp3_ = 0.0;
	GdkRGBA _tmp4_ = {0};
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	GdkRGBA _tmp8_ = {0};
	gdouble _tmp9_ = 0.0;
	GdkRGBA _tmp10_ = {0};
	gdouble _tmp11_ = 0.0;
	GdkRGBA _tmp12_ = {0};
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	GdkRGBA _tmp16_ = {0};
	gdouble _tmp17_ = 0.0;
	GdkRGBA _tmp18_ = {0};
	gdouble _tmp19_ = 0.0;
	GdkRGBA _tmp20_ = {0};
	gdouble _tmp21_ = 0.0;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (colora != NULL);
	g_return_if_fail (colorb != NULL);
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp0_ = *colora;
	_tmp1_ = _tmp0_.red;
	_tmp2_ = *colorb;
	_tmp3_ = _tmp2_.red;
	diff = _tmp1_ - _tmp3_;
	_tmp4_ = *colora;
	_tmp5_ = _tmp4_.red;
	_tmp6_ = diff;
	_tmp7_ = percentage;
	color.red = _tmp5_ - (_tmp6_ * _tmp7_);
	_tmp8_ = *colora;
	_tmp9_ = _tmp8_.green;
	_tmp10_ = *colorb;
	_tmp11_ = _tmp10_.green;
	diff = _tmp9_ - _tmp11_;
	_tmp12_ = *colora;
	_tmp13_ = _tmp12_.green;
	_tmp14_ = diff;
	_tmp15_ = percentage;
	color.green = _tmp13_ - (_tmp14_ * _tmp15_);
	_tmp16_ = *colora;
	_tmp17_ = _tmp16_.blue;
	_tmp18_ = *colorb;
	_tmp19_ = _tmp18_.blue;
	diff = _tmp17_ - _tmp19_;
	_tmp20_ = *colora;
	_tmp21_ = _tmp20_.blue;
	_tmp22_ = diff;
	_tmp23_ = percentage;
	color.blue = _tmp21_ - (_tmp22_ * _tmp23_);
	color.alpha = 1.0;
	*result = color;
	return;
}


void baobab_chart_get_item_color (BaobabChart* self, gdouble rel_position, guint depth, gboolean highlighted, GdkRGBA* result) {
	static const GdkRGBA level_color = {0.83, 0.84, 0.82, 1.0};
	static const GdkRGBA level_color_hi = {0.88, 0.89, 0.87, 1.0};
	GdkRGBA color = {0};
	gdouble intensity = 0.0;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gboolean _tmp17_ = FALSE;
	g_return_if_fail (self != NULL);
	memset (&color, 0, sizeof (GdkRGBA));
	_tmp0_ = depth;
	intensity = 1 - (((_tmp0_ - 1) * 0.3) / BAOBAB_CHART_MAX_DEPTH);
	_tmp1_ = depth;
	if (_tmp1_ == ((guint) 0)) {
		color = level_color;
	} else {
		gint color_number = 0;
		gdouble _tmp2_ = 0.0;
		gint next_color_number = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		GdkRGBA _tmp5_ = {0};
		gint _tmp6_ = 0;
		GdkRGBA _tmp7_ = {0};
		gdouble _tmp8_ = 0.0;
		gint _tmp9_ = 0;
		GdkRGBA _tmp10_ = {0};
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		gdouble _tmp13_ = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		_tmp2_ = rel_position;
		color_number = (gint) (_tmp2_ / (100.0 / 3));
		_tmp3_ = color_number;
		next_color_number = (_tmp3_ + 1) % 6;
		_tmp4_ = color_number;
		_tmp5_ = BAOBAB_CHART_TANGO_COLORS[_tmp4_];
		_tmp6_ = next_color_number;
		_tmp7_ = BAOBAB_CHART_TANGO_COLORS[_tmp6_];
		_tmp8_ = rel_position;
		_tmp9_ = color_number;
		baobab_chart_interpolate_colors (self, &_tmp5_, &_tmp7_, (_tmp8_ - ((_tmp9_ * 100) / 3)) / (100 / 3), &_tmp10_);
		color = _tmp10_;
		_tmp11_ = color.red;
		_tmp12_ = intensity;
		color.red = _tmp11_ * _tmp12_;
		_tmp13_ = color.green;
		_tmp14_ = intensity;
		color.green = _tmp13_ * _tmp14_;
		_tmp15_ = color.blue;
		_tmp16_ = intensity;
		color.blue = _tmp15_ * _tmp16_;
	}
	_tmp17_ = highlighted;
	if (_tmp17_) {
		guint _tmp18_ = 0U;
		_tmp18_ = depth;
		if (_tmp18_ == ((guint) 0)) {
			color = level_color_hi;
		} else {
			gdouble maximum = 0.0;
			GdkRGBA _tmp19_ = {0};
			gdouble _tmp20_ = 0.0;
			GdkRGBA _tmp21_ = {0};
			gdouble _tmp22_ = 0.0;
			GdkRGBA _tmp23_ = {0};
			gdouble _tmp24_ = 0.0;
			gdouble _tmp25_ = 0.0;
			gdouble _tmp26_ = 0.0;
			gdouble _tmp27_ = 0.0;
			gdouble _tmp28_ = 0.0;
			gdouble _tmp29_ = 0.0;
			gdouble _tmp30_ = 0.0;
			gdouble _tmp31_ = 0.0;
			gdouble _tmp32_ = 0.0;
			_tmp19_ = color;
			_tmp20_ = _tmp19_.red;
			_tmp21_ = color;
			_tmp22_ = _tmp21_.green;
			_tmp23_ = color;
			_tmp24_ = _tmp23_.blue;
			_tmp25_ = MAX (_tmp22_, _tmp24_);
			_tmp26_ = MAX (_tmp20_, _tmp25_);
			maximum = _tmp26_;
			_tmp27_ = color.red;
			_tmp28_ = maximum;
			color.red = _tmp27_ / _tmp28_;
			_tmp29_ = color.green;
			_tmp30_ = maximum;
			color.green = _tmp29_ / _tmp30_;
			_tmp31_ = color.blue;
			_tmp32_ = maximum;
			color.blue = _tmp31_ / _tmp32_;
		}
	}
	*result = color;
	return;
}


static gboolean baobab_chart_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	BaobabChart * self;
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	GdkEventType _tmp1_ = 0;
	self = (BaobabChart*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ == GDK_BUTTON_PRESS) {
		GdkEventButton* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		GdkEventButton* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		_tmp2_ = event;
		_tmp3_ = gdk_event_triggers_context_menu ((GdkEvent*) _tmp2_);
		if (_tmp3_) {
			GdkEventButton* _tmp4_ = NULL;
			_tmp4_ = event;
			baobab_chart_show_popup_menu (self, _tmp4_);
			result = TRUE;
			return result;
		}
		_tmp5_ = event;
		_tmp6_ = _tmp5_->button;
		switch (_tmp6_) {
			case GDK_BUTTON_PRIMARY:
			{
				GdkEventButton* _tmp7_ = NULL;
				gdouble _tmp8_ = 0.0;
				GdkEventButton* _tmp9_ = NULL;
				gdouble _tmp10_ = 0.0;
				gboolean _tmp11_ = FALSE;
				_tmp7_ = event;
				_tmp8_ = _tmp7_->x;
				_tmp9_ = event;
				_tmp10_ = _tmp9_->y;
				_tmp11_ = baobab_chart_highlight_item_at_point (self, _tmp8_, _tmp10_);
				if (_tmp11_) {
					GtkTreePath* path = NULL;
					GtkTreeModel* _tmp12_ = NULL;
					GtkTreeModel* _tmp13_ = NULL;
					BaobabChartItem* _tmp14_ = NULL;
					BaobabChartItem* _tmp15_ = NULL;
					GtkTreeIter _tmp16_ = {0};
					GtkTreePath* _tmp17_ = NULL;
					GtkTreePath* _tmp18_ = NULL;
					GtkTreePath* _tmp19_ = NULL;
					GtkTreePath* _tmp20_ = NULL;
					GtkTreePath* _tmp21_ = NULL;
					gint _tmp22_ = 0;
					gboolean _tmp23_ = FALSE;
					_tmp12_ = baobab_chart_get_model (self);
					_tmp13_ = _tmp12_;
					_tmp14_ = baobab_chart_get_highlighted_item (self);
					_tmp15_ = _tmp14_;
					_tmp16_ = _tmp15_->iter;
					_tmp17_ = gtk_tree_model_get_path (_tmp13_, &_tmp16_);
					path = _tmp17_;
					_tmp18_ = baobab_chart_get_root (self);
					_tmp19_ = _tmp18_;
					_tmp20_ = _tmp19_;
					_tmp21_ = path;
					_tmp22_ = gtk_tree_path_compare (_tmp20_, _tmp21_);
					_tmp23_ = _tmp22_ == 0;
					_gtk_tree_path_free0 (_tmp20_);
					if (_tmp23_) {
						baobab_chart_move_up_root (self);
					} else {
						BaobabChartItem* _tmp24_ = NULL;
						BaobabChartItem* _tmp25_ = NULL;
						GtkTreeIter _tmp26_ = {0};
						_tmp24_ = baobab_chart_get_highlighted_item (self);
						_tmp25_ = _tmp24_;
						_tmp26_ = _tmp25_->iter;
						g_signal_emit_by_name (self, "item-activated", &_tmp26_);
					}
					_gtk_tree_path_free0 (path);
				}
				break;
			}
			case GDK_BUTTON_MIDDLE:
			{
				baobab_chart_move_up_root (self);
				break;
			}
			default:
			break;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static GdkEventMotion* _vala_GdkEventMotion_copy (GdkEventMotion* self) {
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer __vala_GdkEventMotion_copy0 (gpointer self) {
	return self ? _vala_GdkEventMotion_copy (self) : NULL;
}


static void _vala_GdkEventMotion_free (GdkEventMotion* self) {
	g_boxed_free (gdk_event_get_type (), self);
}


static gboolean baobab_chart_real_scroll_event (GtkWidget* base, GdkEventScroll* event) {
	BaobabChart * self;
	gboolean result = FALSE;
	GdkEventMotion* e = NULL;
	GdkEventScroll* _tmp0_ = NULL;
	GdkEventMotion* _tmp1_ = NULL;
	GdkEventScroll* _tmp2_ = NULL;
	GdkScrollDirection _tmp3_ = 0;
	self = (BaobabChart*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = __vala_GdkEventMotion_copy0 ((GdkEventMotion*) _tmp0_);
	e = _tmp1_;
	_tmp2_ = event;
	_tmp3_ = _tmp2_->direction;
	switch (_tmp3_) {
		case GDK_SCROLL_LEFT:
		case GDK_SCROLL_UP:
		{
			GdkEventMotion* _tmp4_ = NULL;
			gboolean _tmp5_ = FALSE;
			baobab_chart_zoom_out (self);
			_tmp4_ = e;
			g_signal_emit_by_name ((GtkWidget*) self, "motion-notify-event", _tmp4_, &_tmp5_);
			break;
		}
		case GDK_SCROLL_RIGHT:
		case GDK_SCROLL_DOWN:
		{
			GdkEventMotion* _tmp6_ = NULL;
			gboolean _tmp7_ = FALSE;
			baobab_chart_zoom_in (self);
			_tmp6_ = e;
			g_signal_emit_by_name ((GtkWidget*) self, "motion-notify-event", _tmp6_, &_tmp7_);
			break;
		}
		case GDK_SCROLL_SMOOTH:
		{
			break;
		}
		default:
		break;
	}
	result = FALSE;
	__vala_GdkEventMotion_free0 (e);
	return result;
}


void baobab_chart_open_file (BaobabChart* self) {
	GtkWidget* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	BaobabChartItem* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_open_item (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_WINDOW) ? ((BaobabWindow*) _tmp0_) : NULL, &_tmp3_);
}


void baobab_chart_copy_path (BaobabChart* self) {
	GtkWidget* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	BaobabChartItem* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_copy_path (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_WINDOW) ? ((BaobabWindow*) _tmp0_) : NULL, &_tmp3_);
}


void baobab_chart_trash_file (BaobabChart* self) {
	GtkWidget* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	BaobabChartItem* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = baobab_chart_get_highlighted_item (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->iter;
	baobab_window_trash_file (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, BAOBAB_TYPE_WINDOW) ? ((BaobabWindow*) _tmp0_) : NULL, &_tmp3_);
}


gboolean baobab_chart_can_move_up_root (BaobabChart* self) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreeIter parent_iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter _tmp8_ = {0};
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = baobab_chart_get_root (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	gtk_tree_model_get_iter (_tmp1_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	_gtk_tree_path_free0 (_tmp4_);
	_tmp6_ = baobab_chart_get_model (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = iter;
	_tmp10_ = gtk_tree_model_iter_parent (_tmp7_, &_tmp9_, &_tmp8_);
	parent_iter = _tmp9_;
	result = _tmp10_;
	return result;
}


void baobab_chart_move_up_root (BaobabChart* self) {
	GtkTreeIter iter = {0};
	GtkTreeIter parent_iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreePath* _tmp2_ = NULL;
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeIter _tmp8_ = {0};
	GtkTreeIter _tmp9_ = {0};
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = baobab_chart_get_root (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	gtk_tree_model_get_iter (_tmp1_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	_gtk_tree_path_free0 (_tmp4_);
	_tmp6_ = baobab_chart_get_model (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = iter;
	_tmp10_ = gtk_tree_model_iter_parent (_tmp7_, &_tmp9_, &_tmp8_);
	parent_iter = _tmp9_;
	if (_tmp10_) {
		GtkTreeModel* _tmp11_ = NULL;
		GtkTreeModel* _tmp12_ = NULL;
		GtkTreeIter _tmp13_ = {0};
		GtkTreePath* _tmp14_ = NULL;
		GtkTreePath* _tmp15_ = NULL;
		GtkTreeIter _tmp16_ = {0};
		_tmp11_ = baobab_chart_get_model (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = parent_iter;
		_tmp14_ = gtk_tree_model_get_path (_tmp12_, &_tmp13_);
		_tmp15_ = _tmp14_;
		baobab_chart_set_root (self, _tmp15_);
		_gtk_tree_path_free0 (_tmp15_);
		_tmp16_ = parent_iter;
		g_signal_emit_by_name (self, "item-activated", &_tmp16_);
	}
}


void baobab_chart_zoom_in (BaobabChart* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_can_zoom_in (self);
	if (_tmp0_) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		_tmp1_ = baobab_chart_get_max_depth (self);
		_tmp2_ = _tmp1_;
		baobab_chart_set_max_depth (self, _tmp2_ - 1);
	}
}


void baobab_chart_zoom_out (BaobabChart* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_can_zoom_out (self);
	if (_tmp0_) {
		guint _tmp1_ = 0U;
		guint _tmp2_ = 0U;
		_tmp1_ = baobab_chart_get_max_depth (self);
		_tmp2_ = _tmp1_;
		baobab_chart_set_max_depth (self, _tmp2_ + 1);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void baobab_chart_build_context_menu (BaobabChart* self) {
	GMenu* menu_model = NULL;
	BaobabApplication* _tmp0_ = NULL;
	BaobabApplication* _tmp1_ = NULL;
	GMenu* _tmp2_ = NULL;
	GMenu* _tmp3_ = NULL;
	GMenu* _tmp4_ = NULL;
	GtkMenu* _tmp5_ = NULL;
	GtkMenu* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_application_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_application_get_menu_by_id ((GtkApplication*) _tmp1_, "chartmenu");
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	menu_model = _tmp4_;
	_tmp5_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) menu_model);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->context_menu);
	self->priv->context_menu = _tmp5_;
	_tmp6_ = self->priv->context_menu;
	gtk_menu_attach_to_widget (_tmp6_, (GtkWidget*) self, NULL);
	_g_object_unref0 (menu_model);
}


static void baobab_chart_show_popup_menu (BaobabChart* self, GdkEventButton* event) {
	gboolean enable = FALSE;
	BaobabChartItem* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	GSimpleAction* action = NULL;
	GSimpleActionGroup* _tmp2_ = NULL;
	GAction* _tmp3_ = NULL;
	GSimpleAction* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GSimpleActionGroup* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	GSimpleAction* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GSimpleActionGroup* _tmp12_ = NULL;
	GAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	GSimpleActionGroup* _tmp17_ = NULL;
	GAction* _tmp18_ = NULL;
	GSimpleAction* _tmp19_ = NULL;
	GSimpleAction* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GSimpleActionGroup* _tmp22_ = NULL;
	GAction* _tmp23_ = NULL;
	GSimpleAction* _tmp24_ = NULL;
	GSimpleAction* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GSimpleActionGroup* _tmp27_ = NULL;
	GAction* _tmp28_ = NULL;
	GSimpleAction* _tmp29_ = NULL;
	GSimpleAction* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GdkEventButton* _tmp32_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_highlighted_item (self);
	_tmp1_ = _tmp0_;
	enable = _tmp1_ != NULL;
	_tmp2_ = self->priv->action_group;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) _tmp2_, "open-file");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp3_) : NULL);
	action = _tmp4_;
	_tmp5_ = action;
	_tmp6_ = enable;
	g_simple_action_set_enabled (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->action_group;
	_tmp8_ = g_action_map_lookup_action ((GActionMap*) _tmp7_, "copy-path");
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp8_) : NULL);
	_g_object_unref0 (action);
	action = _tmp9_;
	_tmp10_ = action;
	_tmp11_ = enable;
	g_simple_action_set_enabled (_tmp10_, _tmp11_);
	_tmp12_ = self->priv->action_group;
	_tmp13_ = g_action_map_lookup_action ((GActionMap*) _tmp12_, "trash-file");
	_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp13_) : NULL);
	_g_object_unref0 (action);
	action = _tmp14_;
	_tmp15_ = action;
	_tmp16_ = enable;
	g_simple_action_set_enabled (_tmp15_, _tmp16_);
	_tmp17_ = self->priv->action_group;
	_tmp18_ = g_action_map_lookup_action ((GActionMap*) _tmp17_, "move-up");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp18_) : NULL);
	_g_object_unref0 (action);
	action = _tmp19_;
	_tmp20_ = action;
	_tmp21_ = baobab_chart_can_move_up_root (self);
	g_simple_action_set_enabled (_tmp20_, _tmp21_);
	_tmp22_ = self->priv->action_group;
	_tmp23_ = g_action_map_lookup_action ((GActionMap*) _tmp22_, "zoom-in");
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp23_) : NULL);
	_g_object_unref0 (action);
	action = _tmp24_;
	_tmp25_ = action;
	_tmp26_ = baobab_chart_can_zoom_in (self);
	g_simple_action_set_enabled (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->action_group;
	_tmp28_ = g_action_map_lookup_action ((GActionMap*) _tmp27_, "zoom-out");
	_tmp29_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp28_) : NULL);
	_g_object_unref0 (action);
	action = _tmp29_;
	_tmp30_ = action;
	_tmp31_ = baobab_chart_can_zoom_out (self);
	g_simple_action_set_enabled (_tmp30_, _tmp31_);
	_tmp32_ = event;
	if (_tmp32_ != NULL) {
		GtkMenu* _tmp33_ = NULL;
		GdkEventButton* _tmp34_ = NULL;
		guint _tmp35_ = 0U;
		GdkEventButton* _tmp36_ = NULL;
		guint32 _tmp37_ = 0U;
		_tmp33_ = self->priv->context_menu;
		_tmp34_ = event;
		_tmp35_ = _tmp34_->button;
		_tmp36_ = event;
		_tmp37_ = _tmp36_->time;
		gtk_menu_popup (_tmp33_, NULL, NULL, NULL, NULL, _tmp35_, _tmp37_);
	} else {
		GtkMenu* _tmp38_ = NULL;
		guint32 _tmp39_ = 0U;
		_tmp38_ = self->priv->context_menu;
		_tmp39_ = gtk_get_current_event_time ();
		gtk_menu_popup (_tmp38_, NULL, NULL, NULL, NULL, (guint) 0, _tmp39_);
	}
	_g_object_unref0 (action);
}


static void _baobab_chart_row_changed_gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	baobab_chart_row_changed ((BaobabChart*) self, _sender, path, iter);
}


static void _baobab_chart_row_inserted_gtk_tree_model_row_inserted (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	baobab_chart_row_inserted ((BaobabChart*) self, _sender, path, iter);
}


static void _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	baobab_chart_row_has_child_toggled ((BaobabChart*) self, _sender, path, iter);
}


static void _baobab_chart_row_deleted_gtk_tree_model_row_deleted (GtkTreeModel* _sender, GtkTreePath* path, gpointer self) {
	baobab_chart_row_deleted ((BaobabChart*) self, _sender, path);
}


static void _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gint* new_order, gpointer self) {
	baobab_chart_rows_reordered ((BaobabChart*) self, _sender, path, iter, new_order);
}


static void baobab_chart_connect_model_signals (BaobabChart* self, GtkTreeModel* m) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	g_signal_connect_object (_tmp0_, "row-changed", (GCallback) _baobab_chart_row_changed_gtk_tree_model_row_changed, self, 0);
	_tmp1_ = m;
	g_signal_connect_object (_tmp1_, "row-inserted", (GCallback) _baobab_chart_row_inserted_gtk_tree_model_row_inserted, self, 0);
	_tmp2_ = m;
	g_signal_connect_object (_tmp2_, "row-has-child-toggled", (GCallback) _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled, self, 0);
	_tmp3_ = m;
	g_signal_connect_object (_tmp3_, "row-deleted", (GCallback) _baobab_chart_row_deleted_gtk_tree_model_row_deleted, self, 0);
	_tmp4_ = m;
	g_signal_connect_object (_tmp4_, "rows-reordered", (GCallback) _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered, self, 0);
}


static void baobab_chart_disconnect_model_signals (BaobabChart* self, GtkTreeModel* m) {
	GtkTreeModel* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	GtkTreeModel* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GtkTreeModel* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	GtkTreeModel* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	GtkTreeModel* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = m;
	g_signal_parse_name ("row-changed", GTK_TYPE_TREE_MODEL, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _baobab_chart_row_changed_gtk_tree_model_row_changed, self);
	_tmp2_ = m;
	g_signal_parse_name ("row-inserted", GTK_TYPE_TREE_MODEL, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _baobab_chart_row_inserted_gtk_tree_model_row_inserted, self);
	_tmp4_ = m;
	g_signal_parse_name ("row-has-child-toggled", GTK_TYPE_TREE_MODEL, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _baobab_chart_row_has_child_toggled_gtk_tree_model_row_has_child_toggled, self);
	_tmp6_ = m;
	g_signal_parse_name ("row-deleted", GTK_TYPE_TREE_MODEL, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _baobab_chart_row_deleted_gtk_tree_model_row_deleted, self);
	_tmp8_ = m;
	g_signal_parse_name ("rows-reordered", GTK_TYPE_TREE_MODEL, &_tmp9_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _baobab_chart_rows_reordered_gtk_tree_model_rows_reordered, self);
}


static gboolean baobab_chart_real_query_tooltip (GtkWidget* base, gint x, gint y, gboolean keyboard_tooltip, GtkTooltip* tooltip) {
	BaobabChart * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	BaobabChartItem* _tmp2_ = NULL;
	BaobabChartItem* _tmp3_ = NULL;
	GtkTooltip* _tmp10_ = NULL;
	BaobabChartItem* _tmp11_ = NULL;
	BaobabChartItem* _tmp12_ = NULL;
	GdkRectangle _tmp13_ = {0};
	gchar* markup = NULL;
	BaobabChartItem* _tmp14_ = NULL;
	BaobabChartItem* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	BaobabChartItem* _tmp19_ = NULL;
	BaobabChartItem* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GtkTooltip* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	self = (BaobabChart*) base;
	g_return_val_if_fail (tooltip != NULL, FALSE);
	_tmp2_ = baobab_chart_get_highlighted_item (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		BaobabChartItem* _tmp4_ = NULL;
		BaobabChartItem* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = baobab_chart_get_highlighted_item (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_->name;
		_tmp1_ = _tmp6_ == NULL;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		BaobabChartItem* _tmp7_ = NULL;
		BaobabChartItem* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp7_ = baobab_chart_get_highlighted_item (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_->size;
		_tmp0_ = _tmp9_ == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp10_ = tooltip;
	_tmp11_ = baobab_chart_get_highlighted_item (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_->rect;
	gtk_tooltip_set_tip_area (_tmp10_, &_tmp13_);
	_tmp14_ = baobab_chart_get_highlighted_item (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_->name;
	_tmp17_ = g_strconcat (_tmp16_, "\n", NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = baobab_chart_get_highlighted_item (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = _tmp20_->size;
	_tmp22_ = g_strconcat (_tmp18_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp18_);
	markup = _tmp23_;
	_tmp24_ = tooltip;
	_tmp25_ = markup;
	_tmp26_ = g_markup_escape_text (_tmp25_, (gssize) -1);
	_tmp27_ = _tmp26_;
	gtk_tooltip_set_markup (_tmp24_, _tmp27_);
	_g_free0 (_tmp27_);
	result = TRUE;
	_g_free0 (markup);
	return result;
}


BaobabChart* baobab_chart_construct (GType object_type) {
	BaobabChart * self = NULL;
	self = (BaobabChart*) g_object_new (object_type, NULL);
	return self;
}


guint baobab_chart_get_max_depth (BaobabChart* self) {
	guint result;
	guint _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->max_depth_;
	result = _tmp0_;
	return result;
}


void baobab_chart_set_max_depth (BaobabChart* self, guint value) {
	guint m = 0U;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = CLAMP (_tmp0_, BAOBAB_CHART_MIN_DEPTH, BAOBAB_CHART_MAX_DEPTH);
	m = _tmp1_;
	_tmp2_ = self->priv->max_depth_;
	_tmp3_ = m;
	if (_tmp2_ == _tmp3_) {
		return;
	}
	_tmp4_ = m;
	self->priv->max_depth_ = _tmp4_;
	self->priv->model_changed = TRUE;
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "max-depth");
}


GtkTreeModel* baobab_chart_get_model (BaobabChart* self) {
	GtkTreeModel* result;
	GtkTreeModel* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->model_;
	result = _tmp0_;
	return result;
}


void baobab_chart_set_model (BaobabChart* self, GtkTreeModel* value) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->model_;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = self->priv->model_;
	if (_tmp2_ != NULL) {
		GtkTreeModel* _tmp3_ = NULL;
		_tmp3_ = self->priv->model_;
		baobab_chart_disconnect_model_signals (self, _tmp3_);
	}
	_tmp4_ = value;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->model_);
	self->priv->model_ = _tmp5_;
	self->priv->model_changed = TRUE;
	baobab_chart_set_root (self, NULL);
	_tmp6_ = self->priv->model_;
	baobab_chart_connect_model_signals (self, _tmp6_);
	gtk_widget_queue_draw ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "model");
}


GtkTreePath* baobab_chart_get_root (BaobabChart* self) {
	GtkTreePath* result;
	const GtkTreeRowReference* _tmp0_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->root_;
	if (_tmp0_ != NULL) {
		GtkTreePath* path = NULL;
		const GtkTreeRowReference* _tmp1_ = NULL;
		GtkTreePath* _tmp2_ = NULL;
		GtkTreePath* _tmp3_ = NULL;
		_tmp1_ = self->priv->root_;
		_tmp2_ = gtk_tree_row_reference_get_path (_tmp1_);
		path = _tmp2_;
		_tmp3_ = path;
		if (_tmp3_ != NULL) {
			result = path;
			return result;
		}
		_gtk_tree_row_reference_free0 (self->priv->root_);
		self->priv->root_ = NULL;
		_gtk_tree_path_free0 (path);
	}
	_tmp4_ = gtk_tree_path_new_first ();
	result = _tmp4_;
	return result;
}


static gpointer _gtk_tree_row_reference_copy0 (gpointer self) {
	return self ? gtk_tree_row_reference_copy (self) : NULL;
}


void baobab_chart_set_root (BaobabChart* self, GtkTreePath* value) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	const GtkTreeRowReference* _tmp2_ = NULL;
	GtkTreeRowReference* _tmp13_ = NULL;
	GtkTreePath* _tmp14_ = NULL;
	GtkTreeRowReference* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = self->priv->root_;
	if (_tmp2_ != NULL) {
		GtkTreePath* current_root = NULL;
		const GtkTreeRowReference* _tmp3_ = NULL;
		GtkTreePath* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		GtkTreePath* _tmp7_ = NULL;
		_tmp3_ = self->priv->root_;
		_tmp4_ = gtk_tree_row_reference_get_path (_tmp3_);
		current_root = _tmp4_;
		_tmp7_ = current_root;
		if (_tmp7_ != NULL) {
			GtkTreePath* _tmp8_ = NULL;
			_tmp8_ = value;
			_tmp6_ = _tmp8_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			GtkTreePath* _tmp9_ = NULL;
			GtkTreePath* _tmp10_ = NULL;
			gint _tmp11_ = 0;
			_tmp9_ = current_root;
			_tmp10_ = value;
			_tmp11_ = gtk_tree_path_compare (_tmp9_, _tmp10_);
			_tmp5_ = _tmp11_ == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			_gtk_tree_path_free0 (current_root);
			return;
		}
		_gtk_tree_path_free0 (current_root);
	} else {
		GtkTreePath* _tmp12_ = NULL;
		_tmp12_ = value;
		if (_tmp12_ == NULL) {
			return;
		}
	}
	_tmp14_ = value;
	if (_tmp14_ != NULL) {
		GtkTreeModel* _tmp15_ = NULL;
		GtkTreeModel* _tmp16_ = NULL;
		GtkTreePath* _tmp17_ = NULL;
		GtkTreeRowReference* _tmp18_ = NULL;
		_tmp15_ = baobab_chart_get_model (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = value;
		_tmp18_ = gtk_tree_row_reference_new (_tmp16_, _tmp17_);
		_gtk_tree_row_reference_free0 (_tmp13_);
		_tmp13_ = _tmp18_;
	} else {
		_gtk_tree_row_reference_free0 (_tmp13_);
		_tmp13_ = NULL;
	}
	_tmp19_ = _gtk_tree_row_reference_copy0 (_tmp13_);
	_gtk_tree_row_reference_free0 (self->priv->root_);
	self->priv->root_ = _tmp19_;
	baobab_chart_set_highlighted_item (self, NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
	_gtk_tree_row_reference_free0 (_tmp13_);
	g_object_notify ((GObject *) self, "root");
}


BaobabChartItem* baobab_chart_get_highlighted_item (BaobabChart* self) {
	BaobabChartItem* result;
	BaobabChartItem* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->highlighted_item_;
	result = _tmp0_;
	return result;
}


void baobab_chart_set_highlighted_item (BaobabChart* self, BaobabChartItem* value) {
	BaobabChartItem* _tmp0_ = NULL;
	BaobabChartItem* _tmp1_ = NULL;
	BaobabChartItem* _tmp2_ = NULL;
	BaobabChartItem* _tmp6_ = NULL;
	BaobabChartItem* _tmp10_ = NULL;
	BaobabChartItem* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->highlighted_item_;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp2_ = self->priv->highlighted_item_;
	if (_tmp2_ != NULL) {
		GdkWindow* _tmp3_ = NULL;
		BaobabChartItem* _tmp4_ = NULL;
		GdkRectangle _tmp5_ = {0};
		_tmp3_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp4_ = self->priv->highlighted_item_;
		_tmp5_ = _tmp4_->rect;
		gdk_window_invalidate_rect (_tmp3_, &_tmp5_, TRUE);
	}
	_tmp6_ = value;
	if (_tmp6_ != NULL) {
		GdkWindow* _tmp7_ = NULL;
		BaobabChartItem* _tmp8_ = NULL;
		GdkRectangle _tmp9_ = {0};
		_tmp7_ = gtk_widget_get_window ((GtkWidget*) self);
		_tmp8_ = value;
		_tmp9_ = _tmp8_->rect;
		gdk_window_invalidate_rect (_tmp7_, &_tmp9_, TRUE);
	}
	_tmp10_ = value;
	_tmp11_ = _baobab_chart_item_ref0 (_tmp10_);
	_baobab_chart_item_unref0 (self->priv->highlighted_item_);
	self->priv->highlighted_item_ = _tmp11_;
	g_object_notify ((GObject *) self, "highlighted-item");
}


static void baobab_chart_real_item_activated (BaobabChart* self, GtkTreeIter* iter) {
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	GtkTreePath* _tmp3_ = NULL;
	GtkTreePath* _tmp4_ = NULL;
	g_return_if_fail (iter != NULL);
	_tmp0_ = baobab_chart_get_model (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = *iter;
	_tmp3_ = gtk_tree_model_get_path (_tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	baobab_chart_set_root (self, _tmp4_);
	_gtk_tree_path_free0 (_tmp4_);
}


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}


static GObject * baobab_chart_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	BaobabChart * self;
	GSimpleActionGroup* _tmp0_ = NULL;
	GSimpleActionGroup* _tmp1_ = NULL;
	GSimpleActionGroup* _tmp2_ = NULL;
	parent_class = G_OBJECT_CLASS (baobab_chart_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART, BaobabChart);
	gtk_widget_add_events ((GtkWidget*) self, (gint) (((((GDK_EXPOSURE_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK) | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_SCROLL_MASK));
	_tmp0_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp0_;
	_tmp1_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp1_, BAOBAB_CHART_action_entries, G_N_ELEMENTS (BAOBAB_CHART_action_entries), self);
	_tmp2_ = self->priv->action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "chart", (GActionGroup*) _tmp2_);
	baobab_chart_build_context_menu (self);
	return obj;
}


static void baobab_chart_class_init (BaobabChartClass * klass) {
	baobab_chart_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BaobabChartPrivate));
	((BaobabChartClass *) klass)->post_draw = baobab_chart_real_post_draw;
	((BaobabChartClass *) klass)->draw_item = baobab_chart_real_draw_item;
	((BaobabChartClass *) klass)->calculate_item_geometry = baobab_chart_real_calculate_item_geometry;
	((BaobabChartClass *) klass)->is_point_over_item = baobab_chart_real_is_point_over_item;
	((BaobabChartClass *) klass)->get_item_rectangle = baobab_chart_real_get_item_rectangle;
	((BaobabChartClass *) klass)->can_zoom_in = baobab_chart_real_can_zoom_in;
	((BaobabChartClass *) klass)->can_zoom_out = baobab_chart_real_can_zoom_out;
	((BaobabChartClass *) klass)->create_new_chartitem = baobab_chart_real_create_new_chartitem;
	((GtkWidgetClass *) klass)->size_allocate = baobab_chart_real_size_allocate;
	((GtkWidgetClass *) klass)->motion_notify_event = baobab_chart_real_motion_notify_event;
	((GtkWidgetClass *) klass)->leave_notify_event = baobab_chart_real_leave_notify_event;
	((GtkWidgetClass *) klass)->draw = baobab_chart_real_draw;
	((GtkWidgetClass *) klass)->button_press_event = baobab_chart_real_button_press_event;
	((GtkWidgetClass *) klass)->scroll_event = baobab_chart_real_scroll_event;
	((GtkWidgetClass *) klass)->query_tooltip = baobab_chart_real_query_tooltip;
	((BaobabChartClass *) klass)->item_activated = baobab_chart_real_item_activated;
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_chart_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_chart_set_property;
	G_OBJECT_CLASS (klass)->constructor = baobab_chart_constructor;
	G_OBJECT_CLASS (klass)->finalize = baobab_chart_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_MAX_DEPTH, g_param_spec_uint ("max-depth", "max-depth", "max-depth", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_MODEL, g_param_spec_object ("model", "model", "model", GTK_TYPE_TREE_MODEL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_ROOT, g_param_spec_boxed ("root", "root", "root", gtk_tree_path_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_CHART_HIGHLIGHTED_ITEM, baobab_param_spec_chart_item ("highlighted-item", "highlighted-item", "highlighted-item", BAOBAB_TYPE_CHART_ITEM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("item_activated", BAOBAB_TYPE_CHART, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (BaobabChartClass, item_activated), NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, GTK_TYPE_TREE_ITER);
}


static void baobab_chart_instance_init (BaobabChart * self) {
	self->priv = BAOBAB_CHART_GET_PRIVATE (self);
	self->priv->context_menu = NULL;
	self->priv->max_depth_ = BAOBAB_CHART_MAX_DEPTH;
	self->priv->highlighted_item_ = NULL;
}


static void baobab_chart_finalize (GObject* obj) {
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_CHART, BaobabChart);
	_g_object_unref0 (self->priv->context_menu);
	__g_list_free__baobab_chart_item_unref0_0 (self->priv->items);
	_g_object_unref0 (self->priv->model_);
	_gtk_tree_row_reference_free0 (self->priv->root_);
	_baobab_chart_item_unref0 (self->priv->highlighted_item_);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (baobab_chart_parent_class)->finalize (obj);
}


GType baobab_chart_get_type (void) {
	static volatile gsize baobab_chart_type_id__volatile = 0;
	if (g_once_init_enter (&baobab_chart_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BaobabChartClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_chart_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabChart), 0, (GInstanceInitFunc) baobab_chart_instance_init, NULL };
		GType baobab_chart_type_id;
		baobab_chart_type_id = g_type_register_static (gtk_drawing_area_get_type (), "BaobabChart", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&baobab_chart_type_id__volatile, baobab_chart_type_id);
	}
	return baobab_chart_type_id__volatile;
}


static void _vala_baobab_chart_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CHART, BaobabChart);
	switch (property_id) {
		case BAOBAB_CHART_MAX_DEPTH:
		g_value_set_uint (value, baobab_chart_get_max_depth (self));
		break;
		case BAOBAB_CHART_MODEL:
		g_value_set_object (value, baobab_chart_get_model (self));
		break;
		case BAOBAB_CHART_ROOT:
		g_value_take_boxed (value, baobab_chart_get_root (self));
		break;
		case BAOBAB_CHART_HIGHLIGHTED_ITEM:
		baobab_value_set_chart_item (value, baobab_chart_get_highlighted_item (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_baobab_chart_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BaobabChart * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_CHART, BaobabChart);
	switch (property_id) {
		case BAOBAB_CHART_MAX_DEPTH:
		baobab_chart_set_max_depth (self, g_value_get_uint (value));
		break;
		case BAOBAB_CHART_MODEL:
		baobab_chart_set_model (self, g_value_get_object (value));
		break;
		case BAOBAB_CHART_ROOT:
		baobab_chart_set_root (self, g_value_get_boxed (value));
		break;
		case BAOBAB_CHART_HIGHLIGHTED_ITEM:
		baobab_chart_set_highlighted_item (self, baobab_value_get_chart_item (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



