#!/bin/sh
spitshell=cat
package=IRC

echo "Extracting $package/src/version.c..."

if test -r version.c.last
then
	generation=`sed -n 's/^char \*generation = \"\(.*\)\";/\1/p' < version.c.last`
if test ! "$generation" ; then generation=0; fi
else
	generation=0
fi

generation=`expr $generation + 1`

uname=`uname -a`

creation=`date | \
awk '{if (NF == 6) \
{ print $1 " "  $2 " " $3 " "  $6 " at " $4 " " $5 } \
else \
{ print $1 " "  $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

$spitshell >version.c <<!SUB!THIS!
/*
 *   IRC - Internet Relay Chat, src/version.c
 *   Copyright (C) 1990 Chelsea Ashley Dyerman
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#include "struct.h"
#include "patchlevel.h"

char *generation = "$generation";
char *creation = "$creation";
char version[128];

char *infotext[] =
    {
	 "$package --",
	 "Based on the original code written by Jarkko Oikarinen",
	 "Copyright 1988, 1989, 1990, 1991 University of Oulu, Computing Center",
	 "",
	 "This program is free software; you can redistribute it and/or",
	 "modify it under the terms of the GNU General Public License as",
	 "published by the Free Software Foundation; either version 1, or",
	 "(at your option) any later version.",
	 "",
     "Regular expression support is provided by the PCRE library package,",
     "which is open source software, written by Philip Hazel, and copyright",
     "by the University of Cambridge, England.",
     "",
	 "Send bug reports to dalnet-src@dal.net",
	 "",
	 "The following people currently compose the bahamut team and",
     "actively maintain the bahamut codebase:",
	 "epiphani            Aaron Wiebe         epiphani@dal.net",
         "Quension            Trevor Talbot       quension@dal.net",
	 "Kobi                Kobi Shmueli        kobi@dal.net",
	 "",
	 "The following people have contributed code or support",
	 "to the bahamut team:",
	 "aClient             Diane Bruce         db@koruna.varner.com",
	 "Dakal               David Knepper       dakal@dal.net",
	 "Dalvenjah           Sven Nielsen        dalvenjah@dal.net",
     "lucas               Lucas Madar         lucas@dal.net",
	 "MSofty              Mark Salerno        msofty@dal.net",
     "Raistlin_Majere     Jason Slagle        raistlin@bahamut.net",
	 "Rakarra             Ian Westcott        rakarra@dal.net",
     "sedition            David Parton        sedition@dal.net",
	 "srd                 Holbrook Bunting          srd@powertrip.net",
	 "White_Dragon        Chip Norkus         wd@dal.net",
     "xPsycho             Ryan Smith          xpsycho@dal.net",
	 "",
	 "The following people have contributed ideas or testing to the",
	 "bahamut project:",
	 "driz                David Friedman      driz@dal.net",
	 "drone               Mike Wilson         drone@dal.net",
	 "habit               Melinda Thompson    habit@dal.net",
	 "Kevin               Kevin Turner        kevin@dal.net",
	 "",
	 "",
	 "Developers and Contributors for previous versions:",
	 "Chris A. Bongaarts  Chris Behrens       Diane Bruce",
	 "Johannes Erdfelt    Roger Espel Llima   Jon Lusky",
	 "Michael Pearce      Brian Kraemer       Joan Touzet",
	 "Chris Portman       Keith Fralick       Sam Noble",
	 "Taner Halicioglu    Chris Behrens       Darren Reed",
	 "Markku Savela       Greg Lindahl        Jarkko Oikarinen",
	 "Armin Gruner        Matthew Green       Chuck Kane",
	 "Matt Lyle           Vesa Ruokonen       Nicolas PIOCH",
	 "Stellan Klebom      Dan Goodwin         Mike Bolotski",
	 "Ian Frechette       Markku Jarvinen     Kimmo Suominen",
	 "Jeff Trim           Vijay Subramaniam   Karl Kleinpaste",
	 "Bill Wisner         Tom Davis           Hugo Calendar",
	 "Tom Hopkins         Stephen van den Berg",
	 "Bo Adler            Michael Sandrof     Jon Solomon",
	 "Jan Peterson        Helen Rose          Paul Graham",
	 "",
	 "Thanks also goes to those persons not mentioned here who have added",
	 "their advice, opinions, and code to IRC.",
	 "Thanks also to those who provide the kind sys admins who let me and",
	 "others continue to develop IRC.",
	 "",
	 0,
};
!SUB!THIS!
