<?xml version="1.0"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="text"/>
  <xsl:template match="/interface">
    <!-- header -->
    /* Generated by script-code.xsl */

#include "scripts.h"
#include "scripttypes.h"

    <xsl:value-of select="header"/>

    <!-- generate global static class type holders -->
    <xsl:for-each select="type">
      <xsl:if test="cppwrap">
        SCRIPT_WRAP(<xsl:value-of select="cppwrap"/>, <xsl:value-of select="name"/>)
      </xsl:if>
      const Scriptix::Type* AweMUD_<xsl:value-of select="name"/>Type = NULL;
    </xsl:for-each>

    <!-- private namespace -->
    <xsl:text>namespace {</xsl:text>

    <!-- generate iterators -->
    <xsl:for-each select="function[not(call) or string-length(call)!=0]">
      <xsl:if test="string(return/type)='Iterator'">
        namespace _Iterators {
          class Func_<xsl:value-of select="name"/>_Iter : public Scriptix::Iterator{
            public:
            <xsl:value-of select="iterdata"/>

            protected:
            virtual bool Next (const Scriptix::System* _system, Value*&amp; _iterval) {
              <xsl:value-of select="iternext"/>
            }

            public:
            Func_<xsl:value-of select="name"/>_Iter (const Scriptix::System* system) : Scriptix::Iterator(system) {
              <xsl:value-of select="iternew"/>
            }
            virtual ~Func_<xsl:value-of select="name"/>_Iter (void) {
              <xsl:value-of select="iterdel"/>
            }
          };
        }
      </xsl:if>
    </xsl:for-each>
    <xsl:for-each select="type[not(doconly)]">
      <xsl:if test="new">
        namespace _New {
          Scriptix::Value*
          Create_<xsl:value-of select="name"/>_Type (const Scriptix::System* _system, const Scriptix::Type* _type) {
            <xsl:value-of select="new"/>
          }
        }
      </xsl:if>
      <xsl:for-each select="smethod">
        <xsl:if test="string(return/type)='Iterator'">
          namespace _Iterators {
            class Class_<xsl:value-of select="../name"/>_SMethod_<xsl:value-of select="name"/>_Iter : public Scriptix::Iterator{
              public:
              <xsl:value-of select="iterdata"/>
  
              protected:
              virtual bool Next (const Scriptix::System* _system, Value*&amp; _iterval) {
                <xsl:value-of select="iternext"/>
              }

              public:
              Class_<xsl:value-of select="../name"/>_SMethod_<xsl:value-of select="name"/>_Iter (const Scriptix::System* system) : Scriptix::Iterator(system) {
                <xsl:value-of select="iternew"/>
              }
              virtual ~Class_<xsl:value-of select="../name"/>_SMethod_<xsl:value-of select="name"/>_Iter (void) {
                <xsl:value-of select="iterdel"/>
              }
            };
          }
        </xsl:if>
      </xsl:for-each>
      <xsl:for-each select="method[not(call) or string-length(call)!=0]">
        <xsl:if test="string(return/type)='Iterator'">
          namespace _Iterators {
            class Class_<xsl:value-of select="../name"/>_Method_<xsl:value-of select="name"/>_Iter : public Scriptix::Iterator{
              public:
              <xsl:value-of select="iterdata"/>
  
              protected:
              virtual bool Next (const Scriptix::System* _system, Value*&amp; _iterval) {
                <xsl:value-of select="iternext"/>
              }

              public:
              Class_<xsl:value-of select="../name"/>_Method_<xsl:value-of select="name"/>_Iter (const Scriptix::System* system) : Scriptix::Iterator(system) {
                <xsl:value-of select="iternew"/>
              }
              virtual ~Class_<xsl:value-of select="../name"/>_Method_<xsl:value-of select="name"/>_Iter (void) {
                <xsl:value-of select="iterdel"/>
              }
            };
          }
        </xsl:if>
      </xsl:for-each>
    </xsl:for-each>

/* helper */
#define _system _thread->GetSystem()

    <!-- functions -->
    <xsl:for-each select="function[not(call) or string-length(call)!=0]">
    Scriptix::Value*
      _inter_function_<xsl:value-of select="name"/> (Scriptix::Thread* _thread, size_t _argc, Scriptix::Value** _argv) {
      <xsl:apply-templates select="arg" mode="define"/>
      <xsl:apply-templates select="." mode="define-ret"/>
      <xsl:apply-templates select="arg" mode="get"/>
      <xsl:if test="string(return/type)='Iterator'">
        typedef _Iterators::Func_<xsl:value-of select="name"/>_Iter _iterator;
      </xsl:if>
      <xsl:choose>
        <xsl:when test="call">
          <xsl:apply-templates select="call"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:if test="return/type">_return = </xsl:if><xsl:value-of select="name"/> (<xsl:apply-templates select="arg" mode="list"/>);
        </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="." mode="do-ret"/>
      }
    </xsl:for-each>
    
    <!-- class attrs/methods -->
    <xsl:for-each select="type[not(doconly)]">
      <!-- methods -->
      <xsl:for-each select="method[not(call) or string-length(call)!=0]">
      Scriptix::Value*
        _inter_method_<xsl:value-of select="../name"/>_<xsl:value-of select="name"/> (Scriptix::Thread* _thread, Scriptix::Value* _sxself, size_t _argc, Scriptix::Value** _argv) {
        <xsl:apply-templates select=".." mode="cppname"/>* _self = (<xsl:apply-templates select=".." mode="cppname"/>*)_sxself;;
        <xsl:apply-templates select="arg" mode="define"/>
        <xsl:apply-templates select="." mode="define-ret"/>
  
        <xsl:apply-templates select="arg" mode="get"/>
        <xsl:if test="string(return/type)='Iterator'">
          typedef _Iterators::Class_<xsl:value-of select="../name"/>_Method_<xsl:value-of select="name"/>_Iter _iterator;
        </xsl:if>
        <xsl:choose>
          <xsl:when test="call">
            <xsl:apply-templates select="call"/>
          </xsl:when>
          <xsl:when test="cppname">
            <xsl:if test="return/type">_return = </xsl:if>_self-><xsl:value-of select="cppname"/> (<xsl:apply-templates select="arg" mode="list"/>);
          </xsl:when>
          <xsl:otherwise>
            <xsl:if test="return/type">_return = </xsl:if>_self-><xsl:value-of select="name"/> (<xsl:apply-templates select="arg" mode="list"/>);
          </xsl:otherwise>
        </xsl:choose>
        <xsl:apply-templates select="." mode="do-ret"/>
        }
      </xsl:for-each>

      <!-- Static methods -->
      <xsl:for-each select="smethod">
      Scriptix::Value*
        _inter_smethod_<xsl:value-of select="../name"/>_<xsl:value-of select="name"/> (Scriptix::Thread* _thread, size_t _argc, Scriptix::Value** _argv) {
        <xsl:apply-templates select="arg" mode="define"/>
        <xsl:apply-templates select="." mode="define-ret"/>
        <xsl:apply-templates select="arg" mode="get"/>
        <xsl:if test="string(return/type)='Iterator'">
          typedef _Iterators::Class_<xsl:value-of select="../name"/>_SMethod_<xsl:value-of select="name"/>_Iter _iterator;
        </xsl:if>
        <xsl:choose>
          <xsl:when test="call">
            <xsl:apply-templates select="call"/>
          </xsl:when>
          <xsl:if test="return/type">_return = </xsl:if><xsl:value-of select="return/name"/> (<xsl:apply-templates select="arg" mode="list"/>);
        </xsl:choose>
        <xsl:apply-templates select="." mode="do-ret"/>
        }
      </xsl:for-each>
    </xsl:for-each>

    <!-- end private namespace -->
    <xsl:text>}</xsl:text>

    <!-- Type defs -->
    <xsl:for-each select="type[not(doconly)]">
      SX_TYPEIMPL(
        <xsl:apply-templates select="." mode="cppname"/>,
        "<xsl:value-of select="name"/>",
        <xsl:choose>
          <xsl:when test="parent"><xsl:value-of select="parent"/></xsl:when>
          <xsl:otherwise>Scriptix::Struct</xsl:otherwise>
        </xsl:choose>,
        <xsl:choose>
          <xsl:when test="new">_New::Create_<xsl:value-of select="name"/>_Type</xsl:when>
          <xsl:otherwise>SX_TYPECREATENONE(<xsl:apply-templates select="." mode="cppname"/>)</xsl:otherwise>
        </xsl:choose>
      )
      SX_BEGINMETHODS(<xsl:apply-templates select="." mode="cppname"/>)
      <xsl:for-each select="method[not(call) or string-length(call)!=0]">
        SX_DEFMETHOD(_inter_method_<xsl:value-of select="../name"/>_<xsl:value-of select="name"/>, "<xsl:value-of select="name"/>", <xsl:value-of select="count(arg)"/>, 0)
      </xsl:for-each>
      SX_ENDMETHODS
      SX_BEGINSMETHODS(<xsl:apply-templates select="." mode="cppname"/>)
      <xsl:for-each select="smethod">
        SX_DEFMETHOD(_inter_smethod_<xsl:value-of select="../name"/>_<xsl:value-of select="name"/>, "<xsl:value-of select="name"/>", <xsl:value-of select="count(arg)"/>, 0)
      </xsl:for-each>
      SX_ENDSMETHODS
    </xsl:for-each>
      
    void
    init_scriptix_interface(Scriptix::System* system) {
    <xsl:for-each select="function[not(call) or string-length(call)!=0]">
      system->AddFunction(new Scriptix::Function(system, Scriptix::NameToID("<xsl:value-of select="name"/>"), <xsl:value-of select="count(arg)"/>, 0, _inter_function_<xsl:value-of select="name"/>));
    </xsl:for-each>

    <xsl:for-each select="type[not(doconly)]">
      AweMUD_<xsl:value-of select="name"/>Type = system->AddType(<xsl:apply-templates select="." mode="cppname"/>::GetTypeDef());
    </xsl:for-each>

    <xsl:for-each select="global-group/global">
      <xsl:choose>
      <xsl:when test="type='Integer'">
        system->AddGlobal(Scriptix::NameToID("<xsl:value-of select="name"/>"), Scriptix::Number::Create(<xsl:choose><xsl:when test="expr"><xsl:value-of select="expr"/></xsl:when><xsl:otherwise><xsl:value-of select="name"/></xsl:otherwise></xsl:choose>));
      </xsl:when>
      <xsl:when test="type='String'">
        system->AddGlobal(Scriptix::NameToID("<xsl:value-of select="name"/>"), new Scriptix::String(system, <xsl:choose><xsl:when test="expr"><xsl:value-of select="expr"/></xsl:when><xsl:otherwise><xsl:value-of select="name"/></xsl:otherwise></xsl:choose>));
      </xsl:when>
      <xsl:otherwise>
        system->AddGlobal(Scriptix::NameToID("<xsl:value-of select="name"/>"), <xsl:choose><xsl:when test="expr"><xsl:value-of select="expr"/></xsl:when><xsl:otherwise><xsl:value-of select="name"/></xsl:otherwise></xsl:choose>);
      </xsl:otherwise>
    </xsl:choose>
    </xsl:for-each>
}

    <!-- footer -->
    <xsl:value-of select="footer"/>

    <xsl:text>/* eof */
</xsl:text>
  </xsl:template>

  <!-- argument definition -->
  <xsl:template match="arg" mode="define">
    <xsl:choose>
      <xsl:when test="string(type)='Integer'">
        int _arg_<xsl:value-of select="name"/> = 0;
      </xsl:when>
      <xsl:when test="string(type)='Boolean'">
        int _arg_<xsl:value-of select="name"/> = 0;
      </xsl:when>
      <xsl:when test="string(type)='String'">
        String _arg_<xsl:value-of select="name"/>;
      </xsl:when>
      <xsl:when test="string(type)='Array'">
        Scriptix::Array* _arg_<xsl:value-of select="name"/>;
      </xsl:when>
      <xsl:when test="string(type)='function'">
        Scriptix::Function* _arg_<xsl:value-of select="name"/> = NULL;
      </xsl:when>
      <xsl:when test="string(type)='Mixed'">
        Scriptix::Value* _arg_<xsl:value-of select="name"/> = NULL;
      </xsl:when>
      <xsl:when test="string(type)='core'">
        Scriptix::<xsl:value-of select="ctype"/>* _arg_<xsl:value-of select="name"/> = NULL;
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="." mode="cppname"/>* _arg_<xsl:value-of select="name"/> = NULL;
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- argument get-->
  <xsl:template match="arg" mode="get">
    <xsl:if test="nullok">if (_argv[<xsl:value-of select="position()-1"/>] != NULL) {</xsl:if>
    <xsl:choose>
      <xsl:when test="string(type)='Integer'">
        _arg_<xsl:value-of select="name"/> = Scriptix::Number::ToInt(_argv[<xsl:value-of select="position()-1"/>]);
      </xsl:when>
      <xsl:when test="string(type)='Boolean'">
        _arg_<xsl:value-of select="name"/> = Scriptix::Number::ToInt(_argv[<xsl:value-of select="position()-1"/>]);
      </xsl:when>
      <xsl:when test="string(type)='String'">
        if (!Scriptix::Value::IsA&lt;Scriptix::String&gt;(_thread->GetSystem(), _argv[<xsl:value-of select="position()-1"/>])) {
          _thread->RaiseError(Scriptix::SXE_BADTYPE, "Argument '<xsl:value-of select="name"/>' is not a string");
          return NULL;
        } else {
          _arg_<xsl:value-of select="name"/> = ((Scriptix::String*)_argv[<xsl:value-of select="position()-1"/>])->GetStr();
        }
      </xsl:when>
      <xsl:when test="string(type)='Array'">
        if (!Scriptix::Value::IsA&lt;Scriptix::Array&gt;(_thread->GetSystem(), _argv[<xsl:value-of select="position()-1"/>])) {
          _thread->RaiseError(Scriptix::SXE_BADTYPE, "Argument '<xsl:value-of select="name"/>' is not an array");
          return NULL;
        } else {
          _arg_<xsl:value-of select="name"/> = (Scriptix::Array*)_argv[<xsl:value-of select="position()-1"/>];
        }
      </xsl:when>
      <xsl:when test="string(type)='function'">
        if (!Scriptix::Value::IsA&lt;Scriptix::Function&gt;(_thread->GetSystem(), _argv[<xsl:value-of select="position()-1"/>])) {
          _thread->RaiseError(Scriptix::SXE_BADTYPE, "Argument '<xsl:value-of select="name"/>' is not invocable");
          return NULL;
        } else {
          _arg_<xsl:value-of select="name"/> = (Scriptix::Function*)_argv[<xsl:value-of select="position()-1"/>];
        }
      </xsl:when>
      <xsl:when test="string(type)='core'">
        if (!Scriptix::Value::IsA&lt;Scriptix::<xsl:value-of select="ctype"/>&gt;(_thread->GetSystem(), _argv[<xsl:value-of select="position()-1"/>])) {
              _thread->RaiseError(Scriptix::SXE_BADTYPE, "Argument '<xsl:value-of select="name"/>' is not a <xsl:value-of select="ctype"/>");
              return NULL;
        } else {
          _arg_<xsl:value-of select="name"/> = (Scriptix::<xsl:value-of select="ctype"/>*)_argv[<xsl:value-of select="position()-1"/>];
        }
      </xsl:when>
      <xsl:when test="string(type)='Mixed'">
        _arg_<xsl:value-of select="name"/> = _argv[<xsl:value-of select="position()-1"/>];
      </xsl:when>
      <xsl:otherwise>
        if (!Scriptix::Value::IsA(_thread->GetSystem(), _argv[<xsl:value-of select="position()-1"/>], AweMUD_<xsl:value-of select="type"/>Type)) {
          _thread->RaiseError(Scriptix::SXE_BADTYPE, "Argument '<xsl:value-of select="name"/>' is not a <xsl:value-of select="type"/>");
          return NULL;
        }
        _arg_<xsl:value-of select="name"/> = (<xsl:apply-templates select="." mode="cppname"/>*)_argv[<xsl:value-of select="position()-1"/>];
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="nullok">}</xsl:if>
  </xsl:template>

  <!-- argument list -->
  <xsl:template match="arg" mode="list">
    <xsl:if test="position()-1!=0">, </xsl:if>_arg_<xsl:value-of select="name"/>
  </xsl:template>

  <!-- type cppname -->
  <xsl:template match="type" mode="cppname">
    <xsl:choose><xsl:when test="cppname"><xsl:value-of select="cppname"/></xsl:when><xsl:otherwise><xsl:value-of select="name"/></xsl:otherwise></xsl:choose>
  </xsl:template>
  <xsl:template match="function|method|smethod" mode="cppname">
    <xsl:variable name="type"><xsl:value-of select="return/type"/></xsl:variable>
    <xsl:choose><xsl:when test="//type[child::name=$type and cppname]"><xsl:value-of select="//type[child::name=$type]/cppname"/></xsl:when><xsl:otherwise><xsl:value-of select="$type"/></xsl:otherwise></xsl:choose>
  </xsl:template>
  <xsl:template match="arg" mode="cppname">
    <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
    <xsl:choose><xsl:when test="//type[child::name=$type and cppname]"><xsl:value-of select="//type[child::name=$type]/cppname"/></xsl:when><xsl:otherwise><xsl:value-of select="$type"/></xsl:otherwise></xsl:choose>
  </xsl:template>

  <!-- function return -->
  <xsl:template match="function|method|smethod" mode="define-ret">
    <xsl:choose>
      <xsl:when test="string(return/type)='Integer'">
        int _return = 0;
      </xsl:when>
      <xsl:when test="string(return/type)='Boolean'">
        int _return = 0;
      </xsl:when>
      <xsl:when test="string(return/type)='String'">
        String _return;
      </xsl:when>
      <xsl:when test="string(return/type)='Array'">
        Scriptix::Array* _return = NULL;
      </xsl:when>
      <xsl:when test="string(return/type)='Mixed'">
        Scriptix::Value* _return = NULL;
      </xsl:when>
      <xsl:when test="string(return/type)='Iterator'">
        <xsl:choose>
          <xsl:when test="name()='function'">
            _Iterators::Func_<xsl:value-of select="name"/>_Iter* _return = NULL;
          </xsl:when>
          <xsl:when test="name()='smethod'">
            _Iterators::Class_<xsl:value-of select="../name"/>_SMethod_<xsl:value-of select="name"/>_Iter* _return = NULL;
          </xsl:when>
          <xsl:when test="name()='method'">
            _Iterators::Class_<xsl:value-of select="../name"/>_Method_<xsl:value-of select="name"/>_Iter* _return = NULL;
          </xsl:when>
        </xsl:choose>
      </xsl:when>
      <xsl:when test="return/type">
        <xsl:apply-templates select="." mode="cppname"/>* _return = NULL;
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <!-- do function return -->
  <xsl:template match="function|method|smethod" mode="do-ret">
    <xsl:choose>
      <xsl:when test="string(return/type)='Integer'">
        return Scriptix::Number::Create(_return);
      </xsl:when>
      <xsl:when test="string(return/type)='Boolean'">
        if (_return)
          return Scriptix::Number::Create(1);
      </xsl:when>
      <xsl:when test="string(return/type)='String'">
        if (_return)
          return new Scriptix::String(_thread->GetSystem(), _return);
      </xsl:when>
      <xsl:when test="string(return/type)='Mixed'">
        return _return;
      </xsl:when>
      <xsl:when test="return/type">
        if (_return)
          return _return;
      </xsl:when>
    </xsl:choose>
    return NULL;
  </xsl:template>

  <!-- implement 'call' code -->
  <xsl:template match="call">
    <xsl:if test="function-available('saxon:line-number')" xmlns:saxon="http://icl.com/saxon">
<xsl:text>
#line </xsl:text><xsl:value-of select="saxon:line-number()"/> <xsl:text> "doc/script-intr.xml"
</xsl:text>
    </xsl:if>
    <xsl:value-of select="."/>
  </xsl:template>
</xsl:stylesheet>
<!-- vim: set filetype=xml tabstop=2 shiftwidth=2 expandtab: -->
