#!/bin/sh

BASE_VERSION=`sed -n 's/^BASE_VERSION=\(.*\)$/\1/p' configure.in`
CURVER=`sed -n 's/^VERSION=\(.*\)$/\1/p' configure.in`

if [ -n "$1" ] ; then
	NEWVER="$1"
else
	DATE=`date +%Y%m%d`
	NEWVER="$BASE_VERSION.$DATE"
fi

if [ "x$CURVER" = "x$NEWVER" ] ; then
	# no change...
	exit 1
fi

echo "Current version: $CURVER"
echo "New version:     $NEWVER"

if ! echo "$NEWVER" | grep -q -E "^$BASE_VERSION" ; then
	echo
	read -p "Different version base - update configure.in base version? (Y/n) " DOBASE
	echo
else
	DOBASE='n'
fi

if [ "x$NEWVER" != "x$CURVER" ] ; then
	echo "Updating configure.in..."
	sed "/BASE_VERSION/!s/$CURVER/$NEWVER/" configure.in > configure.new

	if [ "x$DOBASE" != "xn" ] ; then
		sed "s/^BASE_VERSION=.*$/BASE_VERSION=$NEWVER/" configure.new > configure.in
		rm -f configure.new
	else
		mv -f configure.new configure.in
	fi
fi

exit 0
