#!/bin/sh

CONFIG=./awemud.conf
EXPORT=
PREFIX=aweconf
CAPS=no

while test -n "$1"
do
  case "$1" in
    -export)
      EXPORT='export'
      ;;
    -caps)
      CAPS=yes
      ;;
    -prefix)
      shift
      PREFIX="$1"
      ;;
    -config)
      shift
      CONFIG="$1"
      ;;
    *)
      CONFIG="$1"
      ;;
  esac
  shift
done

SECTION=other

echo '## Clearing old variables ##'
if test "$CAPS" = yes
then
  PREFIX=$(echo "$PREFIX" | tr '[a-z]' '[A-Z]')
fi

for VAR in $(env | grep -E "^${PREFIX}_" | sed 's/^\([^=]*\)=.*$/\1/')
do
  echo "${EXPORT} ${VAR}=''"
done

exec < "$CONFIG"
while read LINE
do
  LINE=$(echo "$LINE" | sed 's/;.*$//')
  if test -n "$LINE"
  then
    if echo "$LINE" | grep -q -E '^\[.*\]'
    then
      SECTION=$(echo "$LINE" | sed 's/^.*\[\(.*\)\].*$/\1/')
    else
      ITEM=$(echo "$LINE" | sed 's/^\(.*\)[\t ]*=.*$/\1/')
      VALUE=$(echo "$LINE" | sed 's/^[^=]*=[\t ]*\(.*\)[\t ]*$/\1/')
      echo "## ${SECTION}/${ITEM} = ${VALUE} ##"
      VAR="${PREFIX}_${SECTION}_${ITEM}"
      if test "$CAPS" = yes
      then
        VAR=$(echo "$VAR" | tr '[a-z]' '[A-Z]')
      fi
      echo "${EXPORT} ${VAR}='${VALUE}'"
    fi
  fi
done
