<?xml version="1.0"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="text"/>
  <xsl:template match="/events">

<!-- header -->
<xsl:text><![CDATA[
/* Generated by events-code.xsl */

#include "eventids.h"

namespace Events {
]]></xsl:text>

<!-- event ids -->
<xsl:for-each select="event">
	<xsl:text>EventID </xsl:text><xsl:value-of select="translate(name, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/><xsl:text>;
</xsl:text>
</xsl:for-each>

<!-- initializer -->
<xsl:text><![CDATA[
void initialize (void) {
]]></xsl:text>
<xsl:for-each select="event">
	<xsl:value-of select="translate(name, 'abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/><xsl:text> = EventID::lookup("</xsl:text><xsl:value-of select="name"/><xsl:text>");
</xsl:text>
</xsl:for-each>

<!-- footer -->
<xsl:text><![CDATA[
} // initialize()

} // namespace Events
]]></xsl:text>

  </xsl:template>
</xsl:stylesheet>
